/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute;

import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.SearchResult;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class SplunkConfExtractor
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(SplunkConfExtractor.class);

    public static HashMap<SearchResult.FieldMeta, Object> extract(ComputeEngineContext ctx) {
        Integer listSize;
        HashMap<SearchResult.FieldMeta, Object> executorContext = new HashMap<SearchResult.FieldMeta, Object>();
        try {
            Object x = ctx.get("splunkConf");
            JSONObject jsonObject = new JSONObject((String)x);
            String value = jsonObject.getJSONObject("limits").getJSONObject("stats").getString(LIST_MAX_SIZE.fieldName());
            listSize = Integer.parseInt(value);
        }
        catch (NullPointerException | NumberFormatException e) {
            logger.warn((Object)"List_maxsize configuration from splunk has NOT been parsed successfully, using default list_maxsize=100");
            listSize = 100;
        }
        executorContext.put(LIST_MAX_SIZE, listSize);
        return executorContext;
    }
}

