/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.SearchProcessor;
import com.splunk.df.search.SparkUtils;
import com.splunk.df.search.SplunkEvent;
import com.splunk.df.search.SplunkEventChunk;
import com.splunk.df.search.SplunkSearchStatus;
import com.splunk.df.search.processors.EventingSearchProcessor;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.IteratorUtils;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

@Deprecated
public class SplunkSparkSearchService {
    private static final Logger logger = Logger.getLogger(SplunkSparkSearchService.class);
    private static final int DEFAULT_SERVICE_PORT = 17000;
    private static final int DEFAULT_NUM_RECEIVERS = 1;
    private static final int DEFAULT_RECEIVER_START_PORT = 17000;
    private static int numReceivers = 1;
    private transient ScheduledExecutorService ses = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private HashMap<String, String> processors = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplunkSparkSearchService(final JavaSparkContext jsc) {
        this.registerProcessors();
        int port = 17000;
        String splunkNumPeers = System.getenv("SPLUNK_NUM_PEERS");
        if (splunkNumPeers != null) {
            numReceivers = Integer.valueOf(splunkNumPeers);
        }
        logger.debug((Object)("Number of receivers used: " + numReceivers));
        ServerSocket ss = null;
        try {
            while (true) {
                try {
                    ss = new ServerSocket(port);
                    logger.info((Object)("Successfully started search service on port: " + port));
                }
                catch (Throwable t2) {
                    logger.warn((Object)("Could not start service port at: " + port + " will retry with: " + (port + 1)));
                    ++port;
                    continue;
                }
                break;
            }
            Socket s = null;
            while ((s = ss.accept()) != null) {
                logger.info((Object)("Received connection from client: " + s.getInetAddress().getHostName()));
                final Socket tempS = s;
                this.ses.schedule(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Override
                    public void run() {
                        block51: {
                            startTime = System.currentTimeMillis();
                            bw = null;
                            br = null;
                            status = new SplunkSearchStatus();
                            shutdownDispatch = new boolean[]{false};
                            dispatcherEnded = new boolean[]{false};
                            try {
                                block52: {
                                    bw = new BufferedWriter(new OutputStreamWriter(tempS.getOutputStream()));
                                    br = new BufferedReader(new InputStreamReader(tempS.getInputStream()));
                                    tempBw = bw;
                                    tempBr = br;
                                    chunksToDispatch = new LinkedBlockingDeque<SplunkEventChunk>(20);
                                    SplunkSparkSearchService.access$100(SplunkSparkSearchService.this).schedule(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                while (true) {
                                                    SplunkEventChunk chunk = (SplunkEventChunk)chunksToDispatch.poll(1000L, TimeUnit.MILLISECONDS);
                                                    long start = System.currentTimeMillis();
                                                    if (chunk == null) {
                                                        if (!shutdownDispatch[0]) continue;
                                                        logger.debug((Object)"No more chunks to read and shutdown dispatch requested");
                                                        break;
                                                    }
                                                    logger.debug((Object)("About to dispatch chunk: " + chunk));
                                                    String header = chunk.getHeader();
                                                    String sparkLookupCode = chunk.getSparkLookupCode();
                                                    String compressedInfoCsv = chunk.getCompressedInfoCsv();
                                                    String compressedData = chunk.getCompressedData();
                                                    tempBw.write(header + "\n");
                                                    logger.debug((Object)("Wrote header to client: " + header));
                                                    tempBw.write(sparkLookupCode + "\n");
                                                    tempBw.write(compressedInfoCsv + "\n");
                                                    tempBw.write(compressedData + "\n");
                                                    tempBw.flush();
                                                    compressedData = null;
                                                    logger.info((Object)("Dispatched chunk: " + chunk + " to search provider in: " + (System.currentTimeMillis() - start) + " millis"));
                                                }
                                            }
                                            catch (Throwable t) {
                                                logger.error((Object)("Error while dispatching chunks: " + t.getMessage()), t);
                                            }
                                            try {
                                                tempBw.write("<END_OF_SEARCH_RESULTS>\n");
                                                tempBw.flush();
                                                while (true) {
                                                    if (!tempBr.ready()) {
                                                        Utils.sleep(100L);
                                                        continue;
                                                    }
                                                    String line = tempBr.readLine();
                                                    if ((line = line.trim()).startsWith("<ALL_CHUNKS_READ>")) {
                                                        logger.debug((Object)"Received the all chunks read ack hence breaking");
                                                        break;
                                                    }
                                                    logger.debug((Object)("Received ack but not the all-chunks-read ack: " + line));
                                                }
                                            }
                                            catch (Throwable t) {
                                                logger.error((Object)("Error while writing end of results to search provider: " + t.getMessage()), t);
                                            }
                                            logger.debug((Object)"Splunk search has ended and no more event chunks to read hence finishing search");
                                            dispatcherEnded[0] = true;
                                            logger.debug((Object)"Chunk dispatcher ended");
                                        }
                                    }, 0L, TimeUnit.SECONDS);
                                    procs = null;
                                    receiversRdd = null;
                                    uuid = UUID.randomUUID().toString();
                                    SplunkSparkSearchService.access$000().debug((Object)("Uuid of the search session is: " + uuid + "; client: " + tempS.getRemoteSocketAddress()));
                                    wait = 0L;
                                    block31: while (true) {
                                        if (status.finished) {
                                            SplunkSparkSearchService.access$000().debug((Object)"Search has ended and all events pushed to dispatch queue");
                                            while (!dispatcherEnded[0]) {
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (Throwable t) {
                                                    SplunkSparkSearchService.access$000().error((Object)("Error while sleep: " + t.getMessage()), t);
                                                }
                                            }
                                            break block51;
                                        }
                                        if (!br.ready()) {
                                            start = System.currentTimeMillis();
                                            if (wait > 1000L) {
                                                // empty if block
                                            }
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (Throwable t) {
                                                SplunkSparkSearchService.access$000().error((Object)("Error received while sleeping: " + t.getMessage()));
                                            }
                                            wait += System.currentTimeMillis() - start;
                                            continue;
                                        }
                                        wait = 0L;
                                        request = br.readLine();
                                        SplunkSparkSearchService.access$000().debug((Object)("Received request from client: " + request));
                                        if (request.startsWith("PREPARE_FOR_SEARCH")) {
                                            sparkSpl = request.substring("PREPARE_FOR_SEARCH".length() + 1);
                                            SplunkSparkSearchService.access$000().debug((Object)("Received spark spl: " + sparkSpl));
                                            procs = SplunkSparkSearchService.access$200(SplunkSparkSearchService.this, sparkSpl);
                                            receiversRdd = SparkUtils.createReceivers(jsc, 17000, SplunkSparkSearchService.access$300(), uuid);
                                            partitioner = receiversRdd.partitioner();
                                            if (partitioner.isPresent()) {
                                                SplunkSparkSearchService.access$000().error((Object)("Receivers rdd partitioner: " + receiversRdd.partitioner().get()));
                                            } else {
                                                SplunkSparkSearchService.access$000().error((Object)"Receivers rdd has no partitoners");
                                            }
                                            receiversRdd = receiversRdd.cache();
                                            hostPorts = receiversRdd.toLocalIterator();
                                            hostPortsList = new ArrayList<HostPort>();
                                            while (hostPorts.hasNext()) {
                                                hp = (HostPort)hostPorts.next();
                                                hostPortsList.add(hp);
                                            }
                                            hostPortsTxt = new StringBuilder();
                                            hostPorts = hostPortsList.iterator();
                                            while (hostPorts.hasNext()) {
                                                hostPort = (HostPort)hostPorts.next();
                                                hostPortsTxt.append(hostPort.getHost()).append(":").append(hostPort.getPort());
                                                if (!hostPorts.hasNext()) continue;
                                                hostPortsTxt.append(",");
                                            }
                                            bw.write(hostPortsTxt + "\n");
                                            bw.flush();
                                            SplunkSparkSearchService.access$000().debug((Object)("Receivers host port sent to client: " + hostPortsTxt));
                                            continue;
                                        }
                                        if (!request.startsWith("RUN_SEARCH")) break block52;
                                        SplunkSparkSearchService.access$000().debug((Object)("Running search: " + request));
                                        if (receiversRdd == null) {
                                            SplunkSparkSearchService.access$000().error((Object)"Search session is not prepared!");
                                            throw new RuntimeException("Receivers not created hence search session is not prepared");
                                        }
                                        numChunksAtATime = 1;
                                        chunksRdd = SparkUtils.createEventingRdd(receiversRdd, uuid, numChunksAtATime);
                                        SplunkSparkSearchService.access$000().debug((Object)"Created rdd which can read the event cache at scale");
                                        chunksRdd = SplunkSparkSearchService.access$400(chunksRdd, procs);
                                        partitioner = receiversRdd.partitioner();
                                        if (partitioner.isPresent()) {
                                            SplunkSparkSearchService.access$000().info((Object)("Receivers rdd partitioner after applying search transforms: " + receiversRdd.partitioner().get()));
                                        } else {
                                            SplunkSparkSearchService.access$000().info((Object)"Receivers rdd has no partitoners after search transform application");
                                        }
                                        SplunkSparkSearchService.access$100(SplunkSparkSearchService.this).schedule(new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    while (true) {
                                                        if (!tempBr.ready()) {
                                                            try {
                                                                Thread.sleep(100L);
                                                            }
                                                            catch (Throwable t) {
                                                                logger.error((Object)("error while sleeping: " + t.getMessage()));
                                                            }
                                                            continue;
                                                        }
                                                        String ack = tempBr.readLine();
                                                        logger.debug((Object)"Ack received from client indicating that event chunk has been read");
                                                        if (ack.startsWith("<SPLUNK_SEARCH_ENDED>")) {
                                                            status.finished = true;
                                                            logger.debug((Object)"Search has ended on splunk side");
                                                            break;
                                                        }
                                                        logger.debug((Object)("Splunkd search is still running, ack received: " + ack));
                                                    }
                                                }
                                                catch (Throwable t) {
                                                    logger.error((Object)("Error received while listening to ack from search provider: " + t.getMessage()));
                                                    status.finished = true;
                                                }
                                            }
                                        }, 0L, TimeUnit.SECONDS);
                                        parallel = 10;
lbl94:
                                        // 3 sources

                                        while (true) {
                                            chunksReceived = new boolean[]{false};
                                            received = new ArrayList<E>();
                                            tempChunksRdd = chunksRdd;
                                            threads = new ArrayList<Thread>();
                                            for (i = 0; i < parallel; ++i) {
                                                thread = new Thread(new Runnable(){

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    @Override
                                                    public void run() {
                                                        try {
                                                            Iterator ci = tempChunksRdd.toLocalIterator();
                                                            while (ci.hasNext()) {
                                                                SplunkEventChunk chunk = (SplunkEventChunk)ci.next();
                                                                if (chunk != null) {
                                                                    ArrayList arrayList = received;
                                                                    synchronized (arrayList) {
                                                                        received.add(chunk);
                                                                    }
                                                                    chunksReceived[0] = true;
                                                                    continue;
                                                                }
                                                                logger.error((Object)"Received null chunk!");
                                                                throw new RuntimeException("Received a null chunk!");
                                                            }
                                                        }
                                                        catch (Throwable t) {
                                                            logger.error((Object)("Error while fetching events from dfs workers: " + t.getMessage()), t);
                                                            throw t;
                                                        }
                                                    }
                                                });
                                                threads.add(thread);
                                                thread.start();
                                            }
                                            for (Thread thread : threads) {
                                                thread.join();
                                            }
                                            Collections.sort(received, new Comparator<SplunkEventChunk>(){

                                                @Override
                                                public int compare(SplunkEventChunk lhs, SplunkEventChunk rhs) {
                                                    if (lhs.getStartTime() < rhs.getStartTime()) {
                                                        return 1;
                                                    }
                                                    if (lhs.getStartTime() > rhs.getStartTime()) {
                                                        return -1;
                                                    }
                                                    return 0;
                                                }
                                            });
                                            for (SplunkEventChunk chunk : received) {
                                                while (!chunksToDispatch.offer(chunk, 1L, TimeUnit.SECONDS)) {
                                                    try {
                                                        SplunkSparkSearchService.access$000().info((Object)"Chunk cache full capacity hence waiting before retrying");
                                                        Thread.sleep(100L);
                                                    }
                                                    catch (Throwable t) {
                                                        SplunkSparkSearchService.access$000().error((Object)"Error while sleeping");
                                                    }
                                                }
                                                SplunkSparkSearchService.access$000().debug((Object)("Added chunk to dispatch queue: " + chunk));
                                            }
                                            if (chunksReceived[0] || !status.finished) break block31;
                                            shutdownDispatch[0] = true;
                                            SplunkSparkSearchService.access$000().info((Object)"About to shutdown receivers since no more chunks to read and the search has ended");
                                            SparkUtils.shutdownReceivers((JavaRDD<HostPort>)receiversRdd, uuid);
                                            SplunkSparkSearchService.access$000().error((Object)"Receivers shutdown");
                                            continue block31;
                                            break;
                                        }
                                        break;
                                    }
                                    if (chunksReceived[0] || status.finished) ** GOTO lbl94
                                    Utils.sleep(100L);
                                    ** continue;
                                }
                                SplunkSparkSearchService.access$000().error((Object)("Invalid request received from search provider: " + request));
                                bw.write("<ABORT_SEARCH>\n");
                                bw.flush();
                                SplunkSparkSearchService.access$000().error((Object)"Search aborted because the request was invalid");
                            }
                            catch (Throwable t) {
                                SplunkSparkSearchService.access$000().error((Object)("Error while processing search request: " + t.getMessage()), t);
                                try {
                                    bw.write("<ABORT_SEARCH>\n");
                                    bw.flush();
                                    SplunkSparkSearchService.access$000().error((Object)("Search aborted due to error: " + t.getMessage()));
                                }
                                catch (IOException ie) {
                                    SplunkSparkSearchService.access$000().error((Object)("Error while sending abort to client: " + ie.getMessage()));
                                }
                            }
                            finally {
                                if (bw != null) {
                                    try {
                                        bw.close();
                                    }
                                    catch (Throwable t1) {
                                        SplunkSparkSearchService.access$000().error((Object)("Error while closing socket writer: " + t1.getMessage()));
                                    }
                                    bw = null;
                                }
                                if (br != null) {
                                    try {
                                        br.close();
                                    }
                                    catch (Throwable t1) {
                                        SplunkSparkSearchService.access$000().error((Object)("Error while closing socket reader: " + t1.getMessage()));
                                    }
                                    br = null;
                                }
                                try {
                                    tempS.close();
                                    SplunkSparkSearchService.access$000().debug((Object)"Closed socket connection with client");
                                }
                                catch (Throwable t1) {
                                    SplunkSparkSearchService.access$000().error((Object)("Error while closing socket: " + t1.getMessage()));
                                }
                            }
                        }
                        SplunkSparkSearchService.access$000().info((Object)("Completed processing search session in: " + (System.currentTimeMillis() - startTime) + " millis"));
                    }
                }, 0L, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error occurred during search service start: " + t.getMessage()), t);
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Throwable t1) {
                    logger.error((Object)("Error closing service socket: " + t1.getMessage()));
                }
                ss = null;
            }
        }
    }

    private static JavaRDD<SplunkEventChunk> applySearchTransforms(JavaRDD<SplunkEventChunk> chunksRdd, final List<SearchProcessor> procs) {
        JavaRDD output = chunksRdd.map((Function)new Function<SplunkEventChunk, SplunkEventChunk>(){
            private static final long serialVersionUID = 1L;

            public SplunkEventChunk call(SplunkEventChunk chunk) throws Exception {
                if (chunk == null) {
                    logger.error((Object)"Received null chunk!");
                    throw new IllegalArgumentException("Received null chunk which should not be the case!");
                }
                try {
                    long start = System.currentTimeMillis();
                    String source = chunk.getSource();
                    String compressedInfoCsv = chunk.getCompressedInfoCsv();
                    String sparkLookupCode = chunk.getSparkLookupCode();
                    boolean lastChunk = chunk.isLastChunk();
                    long start1 = System.currentTimeMillis();
                    List<SplunkEvent> events = IteratorUtils.toList(chunk.getEvents());
                    logger.debug((Object)("Profiling: chunk processing: time taken to get events from chunk: " + (System.currentTimeMillis() - start1) + " millis"));
                    Iterator pi = procs.iterator();
                    long start2 = System.currentTimeMillis();
                    while (pi.hasNext()) {
                        SearchProcessor sp = (SearchProcessor)pi.next();
                        if (sp instanceof EventingSearchProcessor) {
                            EventingSearchProcessor esp = (EventingSearchProcessor)sp;
                            long start4 = System.currentTimeMillis();
                            events = esp.process(events);
                            logger.debug((Object)("Profiling: time to process events by: " + sp.getName() + ": " + (System.currentTimeMillis() - start4) + " millis"));
                            continue;
                        }
                        logger.debug((Object)("Ignoring search processor: " + sp.getName() + " since reporting search processor not allowed in this version"));
                    }
                    logger.debug((Object)("Profiling: chunk processing: time taken to apply search processors: " + (System.currentTimeMillis() - start2) + " millis"));
                    long start3 = System.currentTimeMillis();
                    chunk = new SplunkEventChunk(source, events, compressedInfoCsv, sparkLookupCode, lastChunk);
                    logger.debug((Object)("Profiling: chunk processing: time taken to create output event chunk: " + (System.currentTimeMillis() - start3) + " millis"));
                    logger.error((Object)("Profiling: total time taken for processing chunk: " + chunk + ": " + (System.currentTimeMillis() - start) + " millis, thread: " + Thread.currentThread().getId()));
                    return chunk;
                }
                catch (Throwable t) {
                    logger.error((Object)("Error processing chunk with data: " + Utils.decodeAndDecompress(chunk.getCompressedData())));
                    logger.error((Object)("Error received while processing chunk: " + t.getMessage()), t);
                    throw t;
                }
            }
        });
        return output;
    }

    public static void main(String[] args) {
        logger.info((Object)"Splunk Data Fabric Service");
        SparkConf conf = new SparkConf().setAppName("Splunk Data Fabric Service");
        conf.registerKryoClasses(new Class[]{SplunkEvent.class});
        JavaSparkContext jsc = new JavaSparkContext(conf);
        logger.info((Object)"Created java spark context for splunk spark search service");
        new SplunkSparkSearchService(jsc);
        jsc.close();
    }

    private void registerProcessors() {
        this.processors.put("dfeval", "com.splunk.df.search.processors.EvalProcessor");
        this.processors.put("dfwhere", "com.splunk.df.search.processors.FilterProcessor");
    }

    private List<SearchProcessor> createProcessors(String sparkSpl) {
        logger.debug((Object)("Spl received: " + sparkSpl));
        String[] parts = sparkSpl.split("\\|");
        ArrayList<SearchProcessor> procs = new ArrayList<SearchProcessor>();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            part = part.trim();
            logger.debug((Object)("Part of sparkspl: " + part));
            if (part.isEmpty()) {
                logger.debug((Object)"Part is empty");
                continue;
            }
            SearchProcessor proc = this.createProcessor(part);
            procs.add(proc);
            logger.debug((Object)("Created processor: " + proc.getName()));
        }
        return procs;
    }

    private SearchProcessor createProcessor(String spl) {
        SearchProcessor proc;
        if (spl == null) {
            throw new RuntimeException("spl processor part is null");
        }
        String procName = null;
        String args = null;
        if (spl.indexOf(" ") < 0) {
            procName = spl;
        } else {
            String[] splits = spl.split(" ");
            procName = splits[0];
            args = splits[1];
        }
        procName = procName.trim();
        if (args != null) {
            args = args.trim();
        }
        if (procName.isEmpty()) {
            logger.error((Object)"Received empty processor name");
            throw new RuntimeException("Processor name cannot be empty");
        }
        String procClass = this.processors.get(procName);
        if (procClass == null) {
            logger.error((Object)("No processor with name: " + procName + " found"));
            throw new RuntimeException("No processor with name: " + procName + " found");
        }
        try {
            proc = (SearchProcessor)Class.forName(procClass).newInstance();
            if (args != null) {
                proc.setArgs(args);
                proc.setName(procName);
                logger.debug((Object)("Set args: " + args + " and name: " + procName));
            } else {
                logger.debug((Object)"Received null as args");
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Could not load processor class: " + t.getMessage()));
            throw new RuntimeException(t);
        }
        logger.info((Object)("Successfully created processor: " + procName));
        return proc;
    }

    static /* synthetic */ ScheduledExecutorService access$100(SplunkSparkSearchService x0) {
        return x0.ses;
    }

    static /* synthetic */ List access$200(SplunkSparkSearchService x0, String x1) {
        return x0.createProcessors(x1);
    }

    static /* synthetic */ int access$300() {
        return numReceivers;
    }

    static /* synthetic */ JavaRDD access$400(JavaRDD x0, List x1) {
        return SplunkSparkSearchService.applySearchTransforms((JavaRDD<SplunkEventChunk>)x0, x1);
    }
}

