/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import au.com.bytecode.opencsv.CSVParser;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

@Deprecated
public class SparkSearchProvider {
    private static final int DEFAULT_SPARK_SERVICE_PORT = 17000;
    private static final String SPARK_SEARCH_SERVICE_PORT_STR = "SPARK_SEARCH_SERVICE_PORT";
    private static final String SPARK_SEARCH_SERVICE_HOST_STR = "SPARK_SEARCH_SERVICE_HOST";
    static Logger logger = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparkSearchProvider(BufferedReader br, BufferedWriter bw, String host, int port) {
        Socket s = null;
        BufferedReader sbr = null;
        BufferedWriter sbw = null;
        try {
            block49: {
                String line;
                s = new Socket(host, port);
                logger.info((Object)("Connected to spark search service at host: " + host + ", port: " + port));
                sbr = new BufferedReader(new InputStreamReader(s.getInputStream()));
                sbw = new BufferedWriter(new OutputStreamWriter(s.getOutputStream()));
                bw.write("SEARCH_PROVIDER_STARTED\n");
                bw.flush();
                boolean endOfSearchResults = false;
                long alertWait = 0L;
                CSVParser parser = new CSVParser(',', '\"');
                block33: while (true) {
                    if (endOfSearchResults) {
                        logger.info((Object)"Read all search results from search service");
                        break block49;
                    }
                    if (!br.ready()) {
                        long start = System.currentTimeMillis();
                        if (alertWait > 1000L) {
                            // empty if block
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Throwable t) {
                            logger.error((Object)("Error while sleeping: " + t.getMessage()));
                        }
                        alertWait += System.currentTimeMillis() - start;
                        continue;
                    }
                    alertWait = 0L;
                    line = br.readLine();
                    logger.info((Object)("Received request from splunkd: " + line));
                    if (line.startsWith("PREPARE_FOR_SEARCH")) {
                        sbw.write(line + "\n");
                        sbw.flush();
                        logger.debug((Object)("Sent request to search service to start receivers and return the receiver addresses: " + line));
                        while (true) {
                            if (s.isInputShutdown()) {
                                logger.error((Object)"Search service has closed the connection");
                                throw new RuntimeException("Search service has aborted connection");
                            }
                            if (sbr.ready()) break;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable t) {
                                logger.error((Object)("Error while sleeping: " + t.getMessage()));
                            }
                        }
                        String receiversStr = sbr.readLine();
                        if (receiversStr.startsWith("<ABORT_SEARCH>")) {
                            logger.warn((Object)"Received search abort from search service");
                            break block49;
                        }
                        bw.write(receiversStr + "\n");
                        bw.flush();
                        logger.debug((Object)("Received receiver list from search service and returned to splunkd: " + receiversStr));
                        continue;
                    }
                    if (!line.startsWith("RUN_SEARCH")) break;
                    sbw.write(line + "\n");
                    sbw.flush();
                    logger.debug((Object)("Running search on search service: " + line));
                    while (true) {
                        if (!sbr.ready()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable t) {
                                logger.error((Object)("Error while sleeping: " + t.getMessage()));
                            }
                            continue;
                        }
                        line = sbr.readLine();
                        logger.debug((Object)("Read line from search service: " + line));
                        if (line.startsWith("<END_OF_SEARCH_RESULTS>")) {
                            logger.debug((Object)"End fof search results received from search service");
                            sbw.write("<ALL_CHUNKS_READ>\n");
                            sbw.flush();
                            logger.debug((Object)"Sent all chunks, received ack to search service");
                            endOfSearchResults = true;
                            continue block33;
                        }
                        String header = line;
                        String[] splits = parser.parseLine(header);
                        String lastChunkStr = splits[4];
                        boolean lastChunk = Boolean.valueOf(lastChunkStr);
                        String startTimeStr = splits[1];
                        int actionCode = lastChunk ? 1 : 0;
                        String sparkLookupCode = sbr.readLine();
                        String compressedInfoCsv = sbr.readLine();
                        String compressedData = sbr.readLine();
                        logger.debug((Object)("Compressed and encoded event chunk received from search service: " + compressedData.length() + " bytes and header: " + header));
                        String infoCsv = Utils.decodeAndDecompress(compressedInfoCsv);
                        String data = Utils.decodeAndDecompress(compressedData);
                        logger.debug((Object)("Decompressed and decoded event chunk size: " + data.length() + " bytes"));
                        bw.write("splunkToSpark 20160406," + actionCode + "," + sparkLookupCode.length() + "," + startTimeStr.length() + "," + infoCsv.length() + "," + data.length() + "\n");
                        bw.write(sparkLookupCode);
                        bw.write(startTimeStr);
                        bw.write(infoCsv);
                        bw.write(data);
                        bw.flush();
                        logger.debug((Object)("Written a chunk of events to splunkd containing: " + data.length() + " bytes; header: " + header));
                        while (!br.ready()) {
                            logger.debug((Object)"Waiting for ack back from splunkd ...");
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable t) {
                                logger.error((Object)("Error while sleeping: " + t.getMessage()));
                            }
                        }
                        String ack = br.readLine();
                        logger.debug((Object)("Ack received from splunkd: " + ack));
                        String ackToSearchService = "<SPLUNK_SEARCH_IN_PROGRESS>";
                        if (ack.startsWith("<SPLUNK_SEARCH_ENDED>")) {
                            ackToSearchService = "<SPLUNK_SEARCH_ENDED>";
                        }
                        sbw.write(ackToSearchService + "\n");
                        sbw.flush();
                        logger.debug((Object)("Sent chunk received ack to search service: " + ackToSearchService));
                    }
                    break;
                }
                logger.error((Object)("Invalid request received from splunkd: " + line + ", aborting search session with search service"));
                sbw.write("<ABORT_SEARCH>\n");
                sbw.flush();
                logger.error((Object)"Aborted search on search service");
            }
            logger.debug((Object)"Search provider processing completed");
        }
        catch (Throwable t) {
            logger.error((Object)("Error received while processing search: " + t.getMessage()), t);
            try {
                bw.write("<ERROR>: " + t.getMessage() + "\n");
                bw.flush();
            }
            catch (Throwable t1) {
                logger.error((Object)("Could not respond to splunkd: " + t1.getMessage() + " exiting search provider"));
            }
        }
        finally {
            if (sbw != null) {
                try {
                    sbw.close();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Error while closing socket writer: " + t.getMessage()));
                }
                sbw = null;
            }
            if (sbr != null) {
                try {
                    sbr.close();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Error while closing socket reader: " + t.getMessage()));
                }
                sbr = null;
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Error while closing socket: " + t.getMessage()));
                }
                s = null;
            }
        }
        logger.info((Object)"Completed processing search request");
    }

    public static void main(String[] args) {
        logger.info((Object)"Search provider started");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(System.out));
        String sparkServicePortStr = System.getenv(SPARK_SEARCH_SERVICE_PORT_STR);
        String host = "localhost";
        String hostStr = System.getenv(SPARK_SEARCH_SERVICE_HOST_STR);
        if (hostStr != null) {
            host = hostStr;
            logger.info((Object)("Spark search service host received from getenv: " + host));
        } else {
            logger.info((Object)("Using default spark search service host: " + host));
        }
        int port = 17000;
        if (sparkServicePortStr != null) {
            port = Integer.valueOf(sparkServicePortStr);
            logger.info((Object)("Spark search service port received from envvar: " + port));
        } else {
            logger.info((Object)("Default spark service port used: " + port));
        }
        new SparkSearchProvider(br, bw, host, port);
    }

    static {
        PropertyConfigurator.configure((String)(System.getenv("DFS_HOME") + "/spark-1.6.0-bin-hadoop2.6/conf/log4j.properties"));
        logger = Logger.getLogger(SparkSearchProvider.class);
    }
}

