/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.DistributedDataset;
import com.splunk.df.search.compute.MapPartitioner;
import com.splunk.df.search.compute.Mapper;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.search.compute.transformers.FieldExtractor;
import com.splunk.df.security.SSLConfig;
import com.splunk.df.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ReceiversDDFactory
implements DFSSearchConstants,
ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(ReceiversDDFactory.class);

    public static Pair<DistributedDataset, List<HostPort>> createReceiversDD(DistributedDataset root, final int startPort, int portCount, int numPars, int keyStoreProviderPort, String host, int numCores, boolean isFSHExecution, int numCoresPerExecutor) {
        long start = System.currentTimeMillis();
        List<SearchResult> placeholders = ReceiversDDFactory.getReceiverPlaceholders(startPort, numPars, numCores);
        DistributedDataset placeholdersdd = root.resetSearchResults(placeholders, placeholders.size());
        if (numPars > placeholders.size()) {
            placeholdersdd = placeholdersdd.repartition(numPars);
            logger.info((Object)String.format("repartitioning the placeholders dd: %d to the required partitions: %d", placeholders.size(), numPars));
        }
        placeholdersdd = placeholdersdd.transform(new MapPartitioner(){
            private static final long serialVersionUID = 1L;

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }

            @Override
            public Iterator<SearchResult> mapPartitions(int parid, Iterator<SearchResult> srs) {
                ArrayList<SearchResult> ret = new ArrayList<SearchResult>(1);
                int counter = 0;
                while (srs.hasNext()) {
                    SearchResult sr = srs.next();
                    if (counter == 0) {
                        ret.add(sr);
                    }
                    ++counter;
                }
                if (ret.isEmpty()) {
                    SearchResult portSr = SearchResultFactory.getInstance().createSearchResult(DFSSearchConstants.DFS_PORT, startPort);
                    ret.add(portSr);
                }
                return ret.iterator();
            }

            @Override
            public boolean repartition() {
                return false;
            }
        });
        DistributedDataset receiversdd = ReceiversDDFactory.getReceiversDD(placeholdersdd, startPort, portCount, keyStoreProviderPort, Utils.getLocalHostAddress(), SSLConfig.getInstance().getTlsProtocol(), isFSHExecution, numCoresPerExecutor);
        receiversdd = receiversdd.cacheDisk();
        if (logger.isDebugEnabled()) {
            long numReceivers = receiversdd.count();
            logger.debug((Object)String.format("Number of rdin receivers: %d, number of partitions: %d", numReceivers, receiversdd.partitions()));
        }
        List<HostPort> hostPorts = ReceiversDDFactory.getHostPorts(receiversdd);
        logger.info((Object)String.format("Time taken to read the host ports {%s}, is %d millis; total host ports: %d", hostPorts.toString(), System.currentTimeMillis() - start, hostPorts.size()));
        return new Pair<DistributedDataset, List<HostPort>>(receiversdd, hostPorts);
    }

    private static List<HostPort> getHostPorts(DistributedDataset receiversdd) {
        try {
            receiversdd = receiversdd.repartition(1);
            Iterator<SearchResult> srs = receiversdd.retrieve();
            HashSet<HostPort> hostPorts = new HashSet<HostPort>();
            while (srs.hasNext()) {
                SearchResult sr = srs.next();
                if (sr.isEmpty()) continue;
                String host = sr.getDataMap().get(DFC_RECEIVER_HOST).toString();
                int port = Integer.valueOf(sr.getDataMap().get(DFC_RECEIVER_PORT).toString());
                HostPort hp = new HostPort(host, port);
                hostPorts.add(hp);
            }
            return new ArrayList<HostPort>(hostPorts);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("Error creating receivers for rdins: %s", t.getMessage()), t);
            throw new RuntimeException(String.format("error creating receivers for rdin: %s", t.getMessage()), t);
        }
    }

    private static int getPlaceholdersCoreBoost() {
        int boost = 10;
        String boostStr = System.getenv("PLACEHOLDERS_CORE_BOOST");
        if (boostStr != null) {
            try {
                boost = Integer.parseInt(boostStr);
                logger.info((Object)String.format("receiver placeholders core boost set to: %d based on envvar, will determine the partition count if > num pars", boost));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s not set properly, should be int, but is: %s", "PLACEHOLDERS_CORE_BOOST", boostStr));
            }
        }
        logger.info((Object)String.format("receiver placeholders core boost set to: %d", boost));
        return boost;
    }

    private static List<SearchResult> getReceiverPlaceholders(int port, int numPars, int numCores) {
        int boost = ReceiversDDFactory.getPlaceholdersCoreBoost();
        int numHolders = numCores * boost;
        ArrayList<SearchResult> placeholders = new ArrayList<SearchResult>(numHolders);
        for (int i = 0; i < numHolders; ++i) {
            SearchResult portSr = SearchResultFactory.getInstance().createSearchResult(DFS_PORT, port);
            placeholders.add(portSr);
        }
        logger.info((Object)String.format("number of placeholders created: %d, number of partitons: %d", placeholders.size(), numPars));
        return placeholders;
    }

    private static int getNumChunksPerConn12gExecutor() {
        int numChunks = 3;
        String numChunksStr = System.getenv("NUM_CHUNKS_PER_CONN_12G_EXEC");
        if (numChunksStr != null) {
            try {
                numChunks = Integer.parseInt(numChunksStr);
                logger.info((Object)String.format("number of simultaneously processed remote connection chunks for 12g dfs worker set through envvar: %d", numChunks));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, it should be an int, but the value is: %s", "NUM_CHUNKS_PER_CONN_12G_EXEC", numChunksStr));
            }
        }
        logger.info((Object)String.format("number of rdin chunks per remote connections processed simultaneously: %d", numChunks));
        return numChunks;
    }

    private static int getMaxNumChunksPerConn() {
        int maxChunks = 3;
        String maxChunksStr = System.getenv("MAX_NUM_CHUNKS_PER_CONN");
        if (maxChunksStr != null) {
            try {
                maxChunks = Integer.parseInt(maxChunksStr);
                logger.info((Object)String.format("max chunks per remote connections set to: %d through envar", maxChunks));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, needs to be an int - but the value is: %s", "MAX_NUM_CHUNKS_PER_CONN", maxChunksStr));
            }
        }
        return maxChunks;
    }

    private static int getSearchResultQSize12gExecutor() {
        int qSize = 500;
        String qSizeStr = System.getenv("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC");
        if (qSizeStr != null) {
            try {
                qSize = Integer.parseInt(qSizeStr);
                logger.info((Object)String.format("rdin search result queue size for 12g worker set through envvar: %d", qSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, should be an int but is set to: %s", "SEARCH_RESULT_QUEUE_SIZE_12G_EXEC", qSizeStr));
            }
        }
        logger.info((Object)String.format("rdin search result queue size set to: %d", qSize));
        return qSize;
    }

    private static int getCoreBoostForChunkParsing() {
        int coreBoost = 1;
        String coreBoostStr = System.getenv("DFS_CORE_BOOST_FOR_CHUNK_PARSING");
        if (coreBoostStr != null) {
            try {
                coreBoost = Integer.parseInt(coreBoostStr);
                logger.info((Object)String.format("core boost to increase chunk parsing speed on the dfs workers but would also lead to increased gc pressures: %d", coreBoost));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar incorrectly set, it needs to be an int but the value is: %s", "DFS_CORE_BOOST_FOR_CHUNK_PARSING", coreBoostStr));
            }
        }
        logger.info((Object)String.format("core boost set to: %d, which increases the size of the thread pool to proces the rdin chunks from remote connections", coreBoost));
        return coreBoost;
    }

    private static int getMaxSearchQueueSize() {
        int maxSize = 500;
        String maxSizeStr = System.getenv("MAX_SEARCH_RESULT_QUEUE_SIZE");
        if (maxSizeStr != null) {
            try {
                maxSize = Integer.parseInt(maxSizeStr);
                logger.info((Object)String.format("max size of search results queue on the dfs workers set to: %d through envvar", maxSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("%s envvar not set properly, it needs to be an int but set to: %s", "MAX_SEARCH_RESULT_QUEUE_SIZE", maxSizeStr));
            }
        }
        return maxSize;
    }

    private static DistributedDataset getReceiversDD(DistributedDataset placeholdersdd, final int receiverPort, final int receiverPortCount, final int keyStoreProviderPort, final String keyStoreHost, final String tlsProtocol, final boolean isFSHExecution, final int numCoresPerExecutor) {
        int numChunksPerConn12gExec = ReceiversDDFactory.getNumChunksPerConn12gExecutor();
        int maxNumChunks = ReceiversDDFactory.getMaxNumChunksPerConn();
        int searchResultQSize12gExec = ReceiversDDFactory.getSearchResultQSize12gExecutor();
        int maxSrQSize = ReceiversDDFactory.getMaxSearchQueueSize();
        int coreBoost = ReceiversDDFactory.getCoreBoostForChunkParsing();
        final HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("NUM_CHUNKS_PER_CONN_12G_EXEC", numChunksPerConn12gExec);
        params.put("MAX_NUM_CHUNKS_PER_CONN", maxNumChunks);
        params.put("SEARCH_RESULT_QUEUE_SIZE_12G_EXEC", searchResultQSize12gExec);
        params.put("MAX_SEARCH_RESULT_QUEUE_SIZE", maxSrQSize);
        params.put("DFS_CORE_BOOST_FOR_CHUNK_PARSING", coreBoost);
        logger.info((Object)String.format("number of cores per executor: %d", numCoresPerExecutor));
        DistributedDataset receiversDD = placeholdersdd.transform(new Mapper(){
            private static final long serialVersionUID = 1L;

            @Override
            public SearchResult map(SearchResult sr) {
                SearchResult hostPort = NIOSearchResultsReceiverManager.getInstance().getReceiverPort(receiverPort, receiverPortCount, keyStoreProviderPort, keyStoreHost, tlsProtocol, isFSHExecution, numCoresPerExecutor, params);
                return hostPort;
            }

            @Override
            public boolean repartition() {
                return false;
            }

            @Override
            public FieldExtractor.ExtractionHint fieldExtractionHint() {
                return FieldExtractor.ExtractionHint.NOT_PRECOMPUTED;
            }
        });
        return receiversDD;
    }
}

