/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.CollectionArgs;
import com.splunk.Event;
import com.splunk.Job;
import com.splunk.ResultsReaderXml;
import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSChunkToDispatch;
import com.splunk.df.search.FSHMetricsInfo;
import com.splunk.df.search.FSHSplunkConnectionHandler;
import com.splunk.df.search.NIOSearchResultsReceiverManager;
import com.splunk.df.search.compute.ComputeEngineConstants;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SplunkSearchEndpoint;
import com.splunk.df.search.compute.sdk.Pair;
import com.splunk.df.security.NIOTls;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.log4j.Logger;

public class FSHSearchResultShuffler
implements ComputeEngineConstants {
    static final Logger logger = Logger.getLogger(FSHSearchResultShuffler.class);
    private int DEFAULT_MAX_SEARCH_RESULTS = 100000;
    private ArrayList<Thread> fshExecutionThreadList = new ArrayList();
    private HashMap<String, LinkedBlockingDeque<DFSChunkToDispatch>> cachePerSR = new HashMap();
    static FSHSearchResultShuffler singleton = new FSHSearchResultShuffler();

    public static FSHSearchResultShuffler getInstance() {
        return singleton;
    }

    private FSHSearchResultShuffler() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Iterator itr = FSHSearchResultShuffler.this.fshExecutionThreadList.iterator();
                while (itr.hasNext()) {
                    try {
                        Thread t = (Thread)itr.next();
                        t.interrupt();
                        t.join();
                    }
                    catch (Exception e) {
                        logger.error((Object)e.toString());
                    }
                }
                FSHSearchResultShuffler.this.fshExecutionThreadList.clear();
            }
        });
    }

    private static SearchResult toSearchResult(Event event) {
        int size = event.size();
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> data = new SearchResult.SRHashMap<SearchResult.FieldMeta, Object>(size + 1, 1.0f);
        SearchResult.FieldMeta[] fields = new SearchResult.FieldMeta[size];
        Object[] values = new Object[size];
        Set keys = event.keySet();
        Iterator ki = keys.iterator();
        int i = 0;
        while (ki.hasNext()) {
            SearchResult.FieldMeta key = SearchResult.FieldMeta.newFieldMeta((String)ki.next());
            String value = event.get(key.fieldName());
            fields[i] = key;
            values[i] = value;
            data.put(key, value);
            ++i;
        }
        return SearchResultFactory.getInstance().createSearchResult(data, fields, values);
    }

    public void handlePartitionedExecution(String conId, String sidForRemoteSearch, Job job, List<HostPort> hp, SplunkSearchEndpoint sse) {
        this.handlePartitionedExecution(conId, sidForRemoteSearch, job, hp, sse, sse.getSPL());
    }

    public void handlePartitionedExecution(final String conId, final String sidForRemoteSearch, final Job job, final List<HostPort> hp, final SplunkSearchEndpoint sse, final String queryToFire) {
        Thread t = new Thread(new DFCRunnable(){
            String currentSid;
            String connectionId;
            Job currentJob;
            SplunkSearchEndpoint remoteSearchInfo;
            List<HostPort> toWorkers;

            @Override
            protected void runInternal() throws Exception {
                this.currentSid = sidForRemoteSearch;
                this.connectionId = conId;
                this.currentJob = job;
                this.remoteSearchInfo = sse;
                this.toWorkers = hp;
                int scanCount = -1;
                int eventCount = -1;
                int resultCount = -1;
                float duration = 0.0f;
                boolean status = false;
                boolean[] abort = new boolean[1];
                logger.info((Object)String.format("Partitioned execution for sid=%s.", this.currentSid));
                long start = System.currentTimeMillis();
                try {
                    while (!this.currentJob.isReady()) {
                        long elapsed;
                        block11: {
                            try {
                                if (this.currentJob.isFailed()) {
                                    abort[0] = true;
                                    throw new RuntimeException(String.format("search job failed for sid=%s.", this.currentSid));
                                }
                                Thread.sleep(10L);
                            }
                            catch (Throwable t) {
                                if (!abort[0]) break block11;
                                NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                            }
                        }
                        if ((elapsed = System.currentTimeMillis() - start) <= 60000L) continue;
                        RuntimeException re = new RuntimeException(String.format("search job did not report as ready within timeout limits: sid: %s, elapsed: %d millis", this.currentSid, elapsed));
                        NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, re);
                        FSHSplunkConnectionHandler.cleanupConnection(conId);
                        return;
                    }
                }
                catch (Throwable t) {
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                NIOSearchResultsReceiverManager.getInstance().setWaitForFSHMetrics(this.currentSid, true, false);
                logger.debug((Object)String.format("Splunk remote search=%s is ready to send results.", this.currentSid));
                try {
                    while (!job.isDone()) {
                        Thread.sleep(100L);
                    }
                    if (job.isFailed()) {
                        String error = String.format("The job with sid=%s failed in partitioned execution.", this.currentSid);
                        logger.error((Object)error);
                        throw new RuntimeException(error);
                    }
                    logger.debug((Object)"Going to collect FSH metrics.");
                    scanCount = job.getScanCount();
                    eventCount = job.getEventCount();
                    resultCount = job.getResultCount();
                    duration = job.getRunDuration();
                    status = true;
                }
                catch (InterruptedException e) {
                    logger.error((Object)String.format("The job with sid=%s got interrupted.", this.currentSid));
                    job.cancel();
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, e);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("FSH Partitioned job=%s failed due to=%s", this.currentSid, t.toString()));
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                FSHMetricsInfo fshMetricsInfo = new FSHMetricsInfo(this.currentSid, "", "", this.remoteSearchInfo.getUser(), this.remoteSearchInfo.getProvider(), queryToFire, eventCount, resultCount, scanCount, duration, status);
                NIOSearchResultsReceiverManager.getInstance().setFSHMetrics(this.currentSid, fshMetricsInfo);
                logger.info((Object)("Cleaning up connection id" + conId));
                FSHSplunkConnectionHandler.cleanupConnection(conId);
            }
        });
        this.fshExecutionThreadList.add(t);
        t.start();
    }

    public void handleNonPartitionedExecution(String conId, String remoteSidForRemote, Job job, List<HostPort> hp, SplunkSearchEndpoint sse) {
        this.handleNonPartitionedExecution(conId, remoteSidForRemote, job, hp, sse, sse.getSPL());
    }

    public void handleNonPartitionedExecution(final String conId, final String remoteSidForRemote, final Job job, final List<HostPort> hp, final SplunkSearchEndpoint sse, final String queryToFire) {
        Thread receiver = new Thread(new DFCRunnable(){
            private LinkedBlockingDeque<DFSChunkToDispatch> handleToCache;
            String currentSid;
            String connectionId;
            Job currentJob;
            SplunkSearchEndpoint remoteSearchInfo;
            List<HostPort> dfsWorkers;
            int scanCount = -1;
            int eventCount = -1;
            int resultCount = -1;
            float duration = 0.0f;
            boolean status = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() throws Exception {
                this.currentSid = remoteSidForRemote;
                this.connectionId = conId;
                this.currentJob = job;
                this.dfsWorkers = hp;
                this.remoteSearchInfo = sse;
                SearchResult.FieldMeta[] srKeys = null;
                boolean firstSR = true;
                ArrayList<SearchResult> toSendSRChunk = new ArrayList<SearchResult>(FSHSearchResultShuffler.this.DEFAULT_MAX_SEARCH_RESULTS);
                logger.info((Object)("Non-partitioned execution, dispatcher thread dispatching results to dfs workers for sid" + this.currentSid));
                HashMap hashMap = FSHSearchResultShuffler.this.cachePerSR;
                synchronized (hashMap) {
                    this.handleToCache = new LinkedBlockingDeque();
                    FSHSearchResultShuffler.this.cachePerSR.put(this.currentSid, this.handleToCache);
                }
                boolean[] abort = new boolean[1];
                long start = System.currentTimeMillis();
                try {
                    while (!this.currentJob.isReady()) {
                        long elapsed;
                        block16: {
                            logger.debug((Object)("Job is not ready yet, time elapsed" + (System.currentTimeMillis() - start)));
                            try {
                                if (this.currentJob.isFailed()) {
                                    abort[0] = true;
                                    throw new RuntimeException(String.format("search job failed for sid: %s", this.currentSid));
                                }
                                Thread.sleep(10L);
                            }
                            catch (Throwable t) {
                                if (!abort[0]) break block16;
                                throw new RuntimeException(String.format("aborting search since search failed: %s", this.currentSid));
                            }
                        }
                        if ((elapsed = System.currentTimeMillis() - start) <= 60000L) continue;
                        RuntimeException re = new RuntimeException(String.format("search job did not report as ready within timeout limits: sid: %s, elapsed: %d millis", this.currentSid, elapsed));
                        NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, re);
                        throw re;
                    }
                }
                catch (Throwable t) {
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                logger.info((Object)String.format("Splunk search:%s, ready to return results.", this.currentSid));
                NIOSearchResultsReceiverManager.getInstance().setWaitForFSHMetrics(this.currentSid, true, false);
                int chunkSize = FSHSplunkConnectionHandler.getChunkSize(this.connectionId);
                long numRecs = Long.MAX_VALUE;
                int numberOfResults = 0;
                try {
                    SplunkResultIterator srIterator = new SplunkResultIterator(this.currentJob, chunkSize, numRecs);
                    while (srIterator.hasNext()) {
                        SearchResult sr = (SearchResult)srIterator.next();
                        if (firstSR) {
                            srKeys = this.getHeaderFields(sr);
                            if (srKeys == null) continue;
                            firstSR = false;
                        }
                        ++numberOfResults;
                        toSendSRChunk.add(sr);
                        if (toSendSRChunk.size() < FSHSearchResultShuffler.this.DEFAULT_MAX_SEARCH_RESULTS) continue;
                        this.sendToDispatchQueue(toSendSRChunk, srKeys, false);
                        toSendSRChunk.clear();
                    }
                }
                catch (InterruptedException ie) {
                    this.currentJob.cancel();
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, ie);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("FSH Non-Partitioned job=%s failed due to=%s", this.currentSid, t.toString()));
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                    FSHSplunkConnectionHandler.cleanupConnection(conId);
                    return;
                }
                this.sendToDispatchQueue(toSendSRChunk, srKeys, true);
                try {
                    logger.debug((Object)"Going to collect FSH metrics.");
                    this.scanCount = job.getScanCount();
                    this.eventCount = job.getEventCount();
                    this.resultCount = job.getResultCount();
                    this.duration = job.getRunDuration();
                    this.status = true;
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("Metrics collection for remote search=%s failed.", this.currentSid));
                }
                FSHMetricsInfo fshMetricsInfo = new FSHMetricsInfo(this.currentSid, "", "", this.remoteSearchInfo.getUser(), this.remoteSearchInfo.getProvider(), queryToFire, this.eventCount, this.resultCount, this.scanCount, this.duration, this.status);
                NIOSearchResultsReceiverManager.getInstance().setFSHMetrics(this.currentSid, fshMetricsInfo);
                logger.info((Object)("Setting FSH Details for sid" + this.currentSid + " info-->" + fshMetricsInfo.toJson()));
                FSHSplunkConnectionHandler.cleanupConnection(conId);
            }

            private void sendToDispatchQueue(ArrayList<SearchResult> toSendSRChunk, SearchResult.FieldMeta[] srkeys, boolean queryFinish) throws IOException, InterruptedException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedWriter chunkWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                CSVPrinter csvPrinter = CSVFormat.DEFAULT.withHeader(this.convert(srkeys)).print((Appendable)chunkWriter);
                for (int i = 0; i < toSendSRChunk.size(); ++i) {
                    csvPrinter.printRecord(toSendSRChunk.get(i).getDataMap().values());
                }
                csvPrinter.flush();
                String srsPayload = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                DFSChunkToDispatch chunkToDispatch = new DFSChunkToDispatch(this.currentSid, srsPayload, queryFinish);
                while (!this.handleToCache.offer(chunkToDispatch, 1L, TimeUnit.SECONDS)) {
                }
            }

            private String[] convert(SearchResult.FieldMeta[] fields) {
                if (fields == null) {
                    logger.warn((Object)"FieldMeta is null, falling back to dummy");
                    String[] dummy = new String[]{""};
                    return dummy;
                }
                String[] strFields = new String[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    if (fields[i] == null) continue;
                    strFields[i] = fields[i].fieldName();
                }
                return strFields;
            }

            private SearchResult.FieldMeta[] getHeaderFields(SearchResult sr) {
                SearchResult.SRHashMap<SearchResult.FieldMeta, Object> srdata = sr.getDataMap();
                if (srdata.isEmpty()) {
                    return null;
                }
                Object[] srKeysObj = srdata.keySet().toArray();
                SearchResult.FieldMeta[] srKeys = new SearchResult.FieldMeta[srKeysObj.length];
                System.arraycopy(srKeysObj, 0, srKeys, 0, srKeys.length);
                return srKeys;
            }
        });
        this.fshExecutionThreadList.add(receiver);
        receiver.start();
        Thread transmitter = new Thread(new DFCRunnable(){
            String currentSid;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runInternal() throws Exception {
                Object host;
                this.currentSid = remoteSidForRemote;
                ArrayList<Pair<SocketChannel, SSLEngine>> secureSockets = new ArrayList<Pair<SocketChannel, SSLEngine>>();
                block8: for (HostPort element : hp) {
                    host = element.getHost();
                    int port = element.getPort();
                    Pair<SocketChannel, SSLEngine> pairSoc = null;
                    while (true) {
                        try {
                            pairSoc = NIOTls.connect((String)host, port);
                            secureSockets.add(pairSoc);
                            continue block8;
                        }
                        catch (IOException ioe) {
                            logger.error((Object)String.format("Could not connect to receiver reason: %s, will retry to connect", ioe.getMessage()));
                            continue;
                        }
                        break;
                    }
                }
                LinkedBlockingDeque handleToCache = null;
                while (true) {
                    host = FSHSearchResultShuffler.this.cachePerSR;
                    synchronized (host) {
                        handleToCache = (LinkedBlockingDeque)FSHSearchResultShuffler.this.cachePerSR.get(this.currentSid);
                        if (handleToCache != null) {
                            break;
                        }
                        Thread.sleep(100L);
                    }
                }
                boolean done = false;
                try {
                    block11: do {
                        for (int i = 0; i < secureSockets.size(); ++i) {
                            DFSChunkToDispatch dfsChunkToDispatch = (DFSChunkToDispatch)handleToCache.poll(250L, TimeUnit.MILLISECONDS);
                            if (dfsChunkToDispatch == null) continue;
                            String payload = String.format("%s\n%s", dfsChunkToDispatch.getHeader(), dfsChunkToDispatch.getSrSet());
                            byte[] encodedPayload = payload.getBytes(StandardCharsets.UTF_8);
                            int sizeOfPayload = encodedPayload.length;
                            ByteBuffer bb = ByteBuffer.allocate(4);
                            bb.putInt(sizeOfPayload);
                            Pair<SocketChannel, SSLEngine> pairSoc = secureSockets.get(i);
                            NIOTls.write(pairSoc.first(), pairSoc.second(), bb);
                            NIOTls.write(pairSoc.first(), pairSoc.second(), ByteBuffer.wrap(encodedPayload));
                            logger.info((Object)("Sent data to NIO for worker= " + i + " --->" + pairSoc.first().toString()));
                            if (!dfsChunkToDispatch.isLastChunk()) continue;
                            logger.debug((Object)"This is the last chunk");
                            String finalPayload = DFSChunkToDispatch.getLastChunk(this.currentSid);
                            this.sendQFToRemaningDFSWorkers(secureSockets, i, finalPayload);
                            done = true;
                            continue block11;
                        }
                    } while (!done);
                }
                catch (InterruptedException ie) {
                    logger.error((Object)String.format("Transmitter for FSH remote search %s has been interrupted", this.currentSid));
                }
                catch (Throwable t) {
                    NIOSearchResultsReceiverManager.getInstance().setErrorDetailsForSearch(this.currentSid, t);
                }
                this.close(secureSockets);
            }

            private void close(ArrayList<Pair<SocketChannel, SSLEngine>> secureSockets) throws IOException {
                for (int i = 0; i < secureSockets.size(); ++i) {
                    Pair<SocketChannel, SSLEngine> pairSoc = secureSockets.get(i);
                    try {
                        NIOTls.disconnect(pairSoc.first(), pairSoc.second());
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Exception during disconnect " + ex.getMessage()));
                    }
                }
            }

            private void sendQFToRemaningDFSWorkers(ArrayList<Pair<SocketChannel, SSLEngine>> secureSockets, int doNotSend, String payload) throws IOException {
                byte[] encodedPayload = payload.getBytes(StandardCharsets.UTF_8);
                int sizeOfPayload = encodedPayload.length;
                ByteBuffer bb = ByteBuffer.allocate(4);
                bb.putInt(sizeOfPayload);
                for (int i = 0; i < secureSockets.size(); ++i) {
                    if (i == doNotSend) continue;
                    Pair<SocketChannel, SSLEngine> pairSoc = secureSockets.get(i);
                    try {
                        NIOTls.write(pairSoc.first(), pairSoc.second(), bb);
                        NIOTls.write(pairSoc.first(), pairSoc.second(), ByteBuffer.wrap(encodedPayload));
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error((Object)("Error writing securely " + ex.getMessage()));
                    }
                }
            }
        });
        this.fshExecutionThreadList.add(transmitter);
        transmitter.start();
    }

    static {
        logger.info((Object)String.format("Created the FSH Shuffle Manager", new Object[0]));
    }

    private static class SplunkResultIterator
    implements Iterator<SearchResult> {
        private int eventsOffset;
        private Job job;
        Iterator<Event> currentChunk;
        CollectionArgs collectArgs;
        private long numRecs;
        private String sid;

        SplunkResultIterator(Job job, int chunkSize, long numRecs) {
            this.numRecs = numRecs;
            this.job = job;
            this.sid = job.getSid();
            this.eventsOffset = 0;
            this.collectArgs = new CollectionArgs();
            this.collectArgs.setCount(chunkSize);
            this.currentChunk = this.getNextChunk(job, this.collectArgs);
        }

        @Override
        public boolean hasNext() {
            if ((long)this.eventsOffset > this.numRecs) {
                logger.info((Object)String.format("SRS: stopping reading search results since num recs: %d is exceeded: %d", this.numRecs, this.eventsOffset));
                return false;
            }
            if (this.currentChunk.hasNext()) {
                return true;
            }
            long waitMillis = 100L;
            boolean jobFinished = false;
            while (true) {
                this.collectArgs.setOffset(this.eventsOffset);
                this.currentChunk = this.getNextChunk(this.job, this.collectArgs);
                if (this.currentChunk.hasNext()) {
                    return true;
                }
                if (jobFinished) {
                    logger.info((Object)"Job is finished, tried to fetch another chunk but did not get any results");
                    return false;
                }
                if (!this.job.isDone()) {
                    try {
                        Thread.sleep(waitMillis);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                jobFinished = true;
                logger.info((Object)"Job is finished, will keep reading the chunks till the end");
            }
        }

        @Override
        public SearchResult next() {
            ++this.eventsOffset;
            return FSHSearchResultShuffler.toSearchResult(this.currentChunk.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Iterator<Event> getNextChunk(Job job, CollectionArgs collectArgs) {
            try {
                return new ResultsReaderXml(job.getResults((Map)collectArgs)).iterator();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("error while reading from splunk rest endpoint: sid: %s", this.sid), e);
            }
        }
    }
}

