/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import java.io.Serializable;
import org.json.JSONObject;

public class FSHMetricsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String remoteSid;
    private int scanCount;
    private int eventCount;
    private int resultCount;
    private float duration;
    private String query;
    private String dataSetName;
    private String deploymentName;
    private String serviceAccount;
    private String serviceAccountProvider;
    private boolean success;

    public FSHMetricsInfo(String sid, String dataSetName, String deploymentName, String serviceAccount, String serviceAccountProvider, String query, int eventCount, int resultCount, int scanCount, float duration, boolean success) {
        this.remoteSid = sid;
        this.scanCount = scanCount;
        this.eventCount = eventCount;
        this.resultCount = resultCount;
        this.duration = duration;
        this.dataSetName = dataSetName;
        this.deploymentName = deploymentName;
        this.serviceAccount = serviceAccount;
        this.serviceAccountProvider = serviceAccountProvider;
        this.query = query;
        this.success = success;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getQuery() {
        return this.query;
    }

    public int getScanCount() {
        return this.scanCount;
    }

    public int getEventCount() {
        return this.eventCount;
    }

    public float getDuration() {
        return this.duration;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    public String getRemoteSid() {
        return this.remoteSid;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getServiceAccountProvider() {
        return this.serviceAccountProvider;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public JSONObject toJson() {
        JSONObject fshMetric = new JSONObject();
        fshMetric.put("remoteSid", (Object)this.remoteSid);
        fshMetric.put("datasetName", (Object)this.dataSetName);
        fshMetric.put("deploymentName", (Object)this.deploymentName);
        fshMetric.put("serviceAccount", (Object)this.serviceAccount);
        fshMetric.put("serviceAccountProvider", (Object)this.serviceAccountProvider);
        fshMetric.put("remoteFSHSearch", (Object)this.query);
        fshMetric.put("remoteEventCount", this.eventCount);
        fshMetric.put("remoteResultCount", this.resultCount);
        fshMetric.put("remoteScanCount", this.scanCount);
        fshMetric.put("remoteDuration", this.duration);
        fshMetric.put("executionSuccess", this.success);
        return fshMetric;
    }

    public String toString() {
        return String.format("Remote Deployment Info: deploymentName=%s datasetName=%s remoteSearch=%s %s.serviceAccount=%s remoteSid=%s remoteEvent=%d remoteScanCount=%d remoteResultCount=%d duration=%f", this.deploymentName, this.dataSetName, this.query, this.serviceAccountProvider, this.serviceAccount, this.remoteSid, this.eventCount, this.scanCount, this.resultCount, Float.valueOf(this.duration));
    }
}

