/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFExecutionType;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSResourceManager;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSearchDispatcher;
import com.splunk.df.search.ShutdownType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.apache.log4j.Logger;

public class DFSeachCanceler
extends DFCRunnable
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFSearchDispatcher.class);
    private final DFExecutionType executionType;
    private final DFSResourceManager dfsResourceManager;
    private StringBuilder input;
    private BufferedWriter writeToSplunk = null;
    private BufferedReader br;
    String sid;

    public DFSeachCanceler(StringBuilder input, BufferedReader br, BufferedWriter bw, DFSResourceManager resourceMgr) {
        this.dfsResourceManager = resourceMgr;
        this.br = br;
        this.writeToSplunk = bw;
        this.input = input;
        this.executionType = DFExecutionType.BATCH;
    }

    @Override
    protected void runInternal() throws Exception {
        this.cancelOneSearch(this.input);
        this.ackDfcCancelToSplunkd();
        this.br.close();
        this.writeToSplunk.close();
    }

    private void cancelOneSearch(StringBuilder input) {
        if (input == null || input.length() == 0) {
            logger.warn((Object)"Argument expected sid, but input was empty");
            return;
        }
        int pos = input.toString().indexOf("\":\"");
        if (pos < 0) {
            logger.warn((Object)"Argument expected comma before sid, but input was none");
            return;
        }
        String sidStr = input.substring(pos + 3);
        pos = sidStr.indexOf("\"");
        this.sid = sidStr.substring(0, pos);
        DFSResourceManager.DFSResourceInfo info = this.dfsResourceManager.getResourceInfo(this.sid, this.executionType);
        if (info == null) {
            logger.warn((Object)("DFSResourceInfo not found for sid: " + this.sid));
            return;
        }
        int port = info.getDfcPort();
        try {
            logger.debug((Object)("Sending shutdown msg to port: " + port));
            Socket socket = new Socket("127.0.0.1", port);
            OutputStream os = socket.getOutputStream();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
            bw.write(DFSProtocolConstants.PROTO_DFS_SHUTDOWN.toString() + "," + ShutdownType.REGULAR.getValue() + "\n");
            bw.flush();
            bw.close();
            socket.close();
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage());
        }
    }

    private void ackDfcCancelToSplunkd() {
        try {
            String payload = String.format("%s,%s,%s\n", DFSProtocolConstants.PROTO_DFS_ACK.toString(), DFSProtocolConstants.PROTO_DFS_CANCEL_SEARCH.toString(), this.sid);
            this.writeToSplunk.write(payload);
            this.writeToSplunk.flush();
            logger.info((Object)String.format("Acknowledged to splunk about cancelling the coordinator: for sid: %s", this.sid));
        }
        catch (IOException io) {
            logger.error((Object)("IO exception while trying to send ack to DFC Cancel request" + io.getMessage()));
            throw new RuntimeException(io);
        }
    }
}

