/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.commands.EvalCommand;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.StatsCommand;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.ReferencedFieldsVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;

public class ProjectionEliminatingVisitor
extends NodeVisitor<Node> {
    private final Stack<HashSet<String>> requiredFields = new Stack();

    public ProjectionEliminatingVisitor() {
        this.requiredFields.push(new HashSet<String>(){
            {
                this.add("*");
            }
        });
    }

    @Override
    public Node visit(Node node) {
        return node;
    }

    @Override
    public Node visit(CommandNode node) {
        if (node.isGenerating()) {
            return node;
        }
        if (node.isSingleSourced()) {
            HashSet<String> requiredFromSource = this.computeRequiredFromSource(node);
            return node.setSource(this.visitSource(node.getSource(), requiredFromSource));
        }
        throw new UnsupportedOperationException("Need special handling for Generating or Multi-Sourced commands.");
    }

    @Override
    public Node visit(EvalCommand node) {
        final Collection requiredByNext = this.requiredFields.peek();
        HashSet<String> reallyRequired = new HashSet<String>(){
            {
                this.addAll(requiredByNext);
            }
        };
        ReferencedFieldsVisitor referencedFieldsVisitor = new ReferencedFieldsVisitor();
        LinkedList<AssignmentNode> requiredAssignments = new LinkedList<AssignmentNode>();
        for (int i = node.getAssignments().length - 1; i > -1; --i) {
            AssignmentNode assignment = node.getAssignments()[i];
            String fieldName = assignment.getFieldName();
            if (!ProjectionEliminatingVisitor.isRequired(fieldName, (Set<String>)reallyRequired)) continue;
            if (reallyRequired.contains(fieldName)) {
                reallyRequired.remove(fieldName);
            }
            requiredAssignments.push(assignment);
            Set<String> referenced = assignment.getExpression().accept(referencedFieldsVisitor);
            reallyRequired.addAll(referenced);
        }
        AssignmentNode[] assignments = requiredAssignments.toArray(new AssignmentNode[0]);
        CommandNode source = this.visitSource(node.getSource(), reallyRequired);
        if (assignments.length == 0) {
            return source;
        }
        return source.eval(assignments);
    }

    @Override
    public Node visit(FieldsCommand node) {
        if (node.getSource() instanceof FieldsCommand) {
            ConsecutiveFieldsCommandsCollapseResult result = this.collapse(node);
            if (result.collapsed) {
                return result.result.accept(this);
            }
            node = (FieldsCommand)result.result;
        }
        HashSet<String> requiredByNext = this.requiredFields.peek();
        HashSet<String> requiredFromPrevious = new HashSet<String>();
        ArrayList<FieldNode> projections = new ArrayList<FieldNode>();
        if (node.isInKeepMentionedFieldsMode()) {
            for (FieldNode field : node.getFields()) {
                if (!ProjectionEliminatingVisitor.isRequired(field.getFieldName(), requiredByNext)) continue;
                projections.add(field);
            }
        } else {
            projections.addAll(Arrays.asList(node.getFields()));
        }
        if (node.isInKeepMentionedFieldsMode()) {
            if (requiredByNext.contains("*") || requiredByNext.contains("_*")) {
                requiredFromPrevious.add("_*");
            }
            for (FieldNode field : projections) {
                if (!ProjectionEliminatingVisitor.isRequired(field.getFieldName(), requiredByNext)) continue;
                requiredFromPrevious.add(field.getFieldName());
            }
        } else {
            requiredFromPrevious.addAll(requiredByNext);
            for (FieldNode field : projections) {
                requiredFromPrevious.add('-' + field.getFieldName());
                if (!ProjectionEliminatingVisitor.isRequired(field.getFieldName(), requiredByNext)) continue;
                requiredByNext.remove(field.getFieldName());
            }
        }
        CommandNode sourceVisited = this.visitSource(node.getSource(), requiredFromPrevious);
        return new FieldsCommand(sourceVisited, projections.toArray(new FieldNode[0]), node.isRemoveFields(), node.isKeepColumnOrder());
    }

    @Override
    public Node visit(StatsCommand node) {
        HashSet<String> requiredByNext = this.requiredFields.peek();
        HashSet<String> requiredFromPrevious = new HashSet<String>();
        boolean requireSomething = false;
        for (IGroupBy iGroupBy : node.getByFields()) {
            if (!ProjectionEliminatingVisitor.isRequired(iGroupBy.getByName(), requiredByNext)) continue;
            requireSomething = true;
            requiredFromPrevious.add(iGroupBy.getByName());
        }
        ArrayList<AggregateNode> requiredAggregates = new ArrayList<AggregateNode>();
        for (AggregateNode agg : node.getAggregates()) {
            if (!ProjectionEliminatingVisitor.isRequired(agg.getAsName(), requiredByNext)) continue;
            requireSomething = true;
            requiredAggregates.add(agg);
            requiredFromPrevious.addAll((Collection<String>)agg.accept(new ReferencedFieldsVisitor()));
        }
        if (!requireSomething) {
            return new UnknownCommand("noop", "", CommandType.SP_STREAM, new FieldsAndProperties().array());
        }
        if (requiredAggregates.isEmpty()) {
            requiredAggregates.add(new AggregateNode(AggregateFunction.COUNT, "_raw"));
        }
        CommandNode commandNode = this.visitSource(node.getSource(), requiredFromPrevious);
        return new StatsCommand(commandNode, requiredAggregates, node.getByFields(), node.getPartitions(), node.getAllnum(), node.getDelim(), node.isPrestatsMode());
    }

    private CommandNode visitSource(CommandNode source, HashSet<String> requiredFromSource) {
        this.requiredFields.push(requiredFromSource);
        CommandNode sourceVisited = (CommandNode)source.accept(this);
        this.requiredFields.pop();
        return sourceVisited;
    }

    private static boolean isRequired(String fieldName, Set<String> requiredFields) {
        if (requiredFields.contains(fieldName)) {
            return true;
        }
        if (requiredFields.contains('-' + fieldName)) {
            return false;
        }
        if (requiredFields.contains("*")) {
            return true;
        }
        return requiredFields.contains("_*") && fieldName.startsWith("_");
    }

    private HashSet<String> computeRequiredFromSource(CommandNode generator) {
        Set requiredFromGenerator = this.requiredFields.peek();
        Set<String> referenced = generator.getFieldsAndProperties().getReferenced();
        if (requiredFromGenerator.contains("*") || referenced.contains("*")) {
            return new HashSet<String>(){
                {
                    this.add("*");
                }
            };
        }
        HashSet<String> all = new HashSet<String>();
        all.addAll(referenced);
        all.addAll(requiredFromGenerator);
        return all;
    }

    private ConsecutiveFieldsCommandsCollapseResult collapse(FieldsCommand right) {
        if (!(right.getSource() instanceof FieldsCommand)) {
            throw new RuntimeException("Expected source to be another FieldsCommand, it is not, therefore Collapsing is impossible");
        }
        FieldsCommand left = (FieldsCommand)right.getSource();
        CommandNode source = left.getSource();
        if (left.isInKeepMentionedFieldsMode() && right.isInKeepMentionedFieldsMode()) {
            LinkedHashSet<String> mfields = new LinkedHashSet<String>();
            block0: for (FieldNode r : right.getFields()) {
                for (FieldNode l : left.getFields()) {
                    if (!l.getFieldName().equals(r.getFieldName())) continue;
                    mfields.add(r.getFieldName());
                    continue block0;
                }
            }
            return new ConsecutiveFieldsCommandsCollapseResult(new FieldsCommand(source, ProjectionEliminatingVisitor.getFields(mfields)), true);
        }
        if (left.isRemoveFields() && right.isRemoveFields()) {
            Set<String> mfields = ProjectionEliminatingVisitor.getFieldNames(left.getFields());
            for (FieldNode n : right.getFields()) {
                mfields.add(n.getFieldName());
            }
            return new ConsecutiveFieldsCommandsCollapseResult(new FieldsCommand(source, ProjectionEliminatingVisitor.getFields(mfields), true), true);
        }
        if (left.isInKeepMentionedFieldsMode()) {
            Set<String> lfields = ProjectionEliminatingVisitor.getFieldNames(left.getFields());
            Set<String> rfields = ProjectionEliminatingVisitor.getFieldNames(right.getFields());
            LinkedHashSet<String> allFields = new LinkedHashSet<String>();
            allFields.addAll(lfields);
            allFields.addAll(rfields);
            for (String f : allFields) {
                boolean leftContains = lfields.contains(f);
                boolean rightContains = rfields.contains(f);
                if (leftContains && rightContains) {
                    lfields.remove(f);
                    rfields.remove(f);
                    continue;
                }
                if (leftContains || !rightContains || f.startsWith("_")) continue;
                rfields.remove(f);
            }
            int renameCount = 1;
            source = new FieldsCommand(source, ProjectionEliminatingVisitor.getFields(lfields));
            if (!rfields.isEmpty()) {
                source = new FieldsCommand(source, ProjectionEliminatingVisitor.getFields(rfields), true);
                ++renameCount;
            }
            return new ConsecutiveFieldsCommandsCollapseResult(source, renameCount != 2);
        }
        if (right.isInKeepMentionedFieldsMode()) {
            Set<String> rfields = ProjectionEliminatingVisitor.getFieldNames(right.getFields());
            for (FieldNode r : right.getFields()) {
                for (FieldNode l : left.getFields()) {
                    if (!l.getFieldName().equals(r.getFieldName())) continue;
                    rfields.remove(r.getFieldName());
                }
            }
            return new ConsecutiveFieldsCommandsCollapseResult(new FieldsCommand(left, ProjectionEliminatingVisitor.getFields(rfields)), false);
        }
        throw new RuntimeException("The collapse(FieldCommand) ran into an theoretically impossible situation.");
    }

    private static Set<String> getFieldNames(FieldNode[] array) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (FieldNode n : array) {
            ret.add(n.getFieldName());
        }
        return ret;
    }

    private static FieldNode[] getFields(Set<String> set) {
        String[] fieldNames = set.toArray(new String[0]);
        FieldNode[] fields = new FieldNode[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fields[i] = new FieldNode(fieldNames[i]);
        }
        return fields;
    }

    private class ConsecutiveFieldsCommandsCollapseResult {
        private final CommandNode result;
        private final boolean collapsed;

        private ConsecutiveFieldsCommandsCollapseResult(CommandNode result, boolean collapsed) {
            this.result = result;
            this.collapsed = collapsed;
        }
    }
}

