/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.RepresentativeRow;
import com.splunk.commons.Row;
import com.splunk.commons.Unknown;
import com.splunk.commons.ast.matchers.CidrMatcher;
import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.matchers.NumberMatcher;
import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AndNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.ComparisonNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.NullNode;
import com.splunk.commons.ast.nodes.expressions.Number;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.OrNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.expressions.XorNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchQuotableNode;
import com.splunk.commons.ast.nodes.search.SearchSubSearchPredicateNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.util.SubnetUtils;

public class ExpressionEvaluator
extends NodeVisitor<Object>
implements Serializable {
    private Row currentRow;
    private boolean fillNull = false;

    public Object evaluate(Node node) {
        return this.evaluate(node, null);
    }

    public Object evaluate(Node node, Row row) {
        this.currentRow = row;
        return this.evaluate(node, row, this.fillNull);
    }

    public Object evaluate(Node node, Row row, boolean fillNull) {
        this.currentRow = row;
        this.fillNull = fillNull;
        return node.accept(this);
    }

    public Row getRow() {
        return this.currentRow;
    }

    @Override
    public Object visit(Node node) {
        throw new UnsupportedOperationException(String.format("Node of type %1$s not supported in evaluator", node.getClass().toString()));
    }

    @Override
    public Object visit(AndNode node) {
        for (TypeNode typeNode : node.getArguments()) {
            boolean result = (Boolean)typeNode.accept(this);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visit(OrNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result = (Boolean)node.getArguments().get(i).accept(this);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(XorNode node) {
        boolean preResult = (Boolean)node.getArguments().get(0).accept(this);
        for (int i = 1; i < node.getArguments().size(); ++i) {
            boolean result = (Boolean)node.getArguments().get(i).accept(this);
            preResult = result != preResult;
        }
        return preResult;
    }

    @Override
    public Object visit(FunctionNode node) {
        Object[] args = new Object[node.getArguments().size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = node.getArguments().get(i).accept(this);
        }
        switch (FunctionNode.FunctionName.lookup(node.getFunctionName())) {
            case add: {
                if (args[0] instanceof String || args[1] instanceof String) {
                    return new StringBuffer(args[0].toString()).append(args[1].toString()).toString();
                }
                try {
                    return Number.add(args[0], args[1]);
                }
                catch (IllegalArgumentException e) {
                    return new StringBuffer(args[0].toString()).append(args[1].toString()).toString();
                }
            }
            case subtract: {
                return Number.subtract(args[0], args[1]);
            }
            case multiply: {
                return Number.multiply(args[0], args[1]);
            }
            case divide: {
                Object divresult;
                try {
                    divresult = Number.divide(args[0], args[1]);
                }
                catch (ArithmeticException e) {
                    return Double.NaN;
                }
                return divresult;
            }
            case modulo: {
                Object moduloresult;
                try {
                    moduloresult = Number.modulo(args[0], args[1]);
                }
                catch (ArithmeticException e) {
                    return Double.NaN;
                }
                return moduloresult;
            }
            case caseF: {
                for (int i = 0; i < node.getArguments().size(); i += 2) {
                    boolean caseResult = (Boolean)node.getArguments().get(i).accept(this);
                    if (!caseResult) continue;
                    return node.getArguments().get(i + 1).accept(this);
                }
                return null;
            }
            case concat: {
                return args[0].toString() + args[1].toString();
            }
            case ifF: {
                boolean result = (Boolean)node.getArguments().get(0).accept(this);
                return result ? node.getArguments().get(1).accept(this) : node.getArguments().get(2).accept(this);
            }
            case len: {
                if (args[0] == null) {
                    return null;
                }
                return args[0].toString().length();
            }
            case nullF: {
                return null;
            }
            case eval: {
                return node.getArguments().get(0).accept(this);
            }
            case nullif: {
                Object left = node.getArguments().get(0).accept(this);
                Object right = node.getArguments().get(1).accept(this);
                if (left.equals(right)) {
                    return null;
                }
                return left;
            }
            case substr: {
                Integer end;
                if (args[0] == null) {
                    return null;
                }
                String value = args[0].toString();
                Integer start = new Integer(args[1].toString());
                if (start < 0) {
                    end = value.length();
                    start = value.length() + start;
                } else {
                    start = start == 0 ? start : start - 1;
                    if (node.getArguments().size() == 3 && node.getArguments().get(2) != null) {
                        Integer len = new Integer(node.getArguments().get(2).accept(this).toString());
                        end = start + len;
                        if (end > value.length()) {
                            end = value.length();
                        }
                    } else {
                        end = value.length();
                    }
                }
                if (value != null && !value.isEmpty() && start <= end) {
                    return value.substring(start, end);
                }
                return "";
            }
            case upper: {
                if (args[0] == null) {
                    return null;
                }
                String value = args[0].toString();
                return value.toUpperCase();
            }
            case lower: {
                if (args[0] == null) {
                    return null;
                }
                String value = args[0].toString();
                return value.toLowerCase();
            }
            case urldecode: {
                if (args[0] == null) {
                    return null;
                }
                String value = args[0].toString();
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            case coalesce: {
                List<TypeNode> argsList = node.getArguments();
                for (int i = 0; i < argsList.size(); ++i) {
                    Object obValue = argsList.get(i).accept(this);
                    if (obValue == null) continue;
                    return obValue.toString();
                }
                return null;
            }
            case split: {
                if (args[0] == null) {
                    return null;
                }
                String value = args[0].toString();
                return value.split(StringUtils.escapeMetaCharacters(args[1].toString()), 0);
            }
            case round: {
                if (args[0] == null) {
                    return null;
                }
                int decimalPlaces = 0;
                if (node.getArguments().size() == 2) {
                    decimalPlaces = Integer.parseInt(node.getArguments().get(1).accept(this).toString());
                    BigDecimal bdValue = new BigDecimal(args[0].toString());
                    return bdValue.setScale(decimalPlaces, 4);
                }
                return Math.round(Double.parseDouble(args[0].toString()));
            }
        }
        throw new UnsupportedOperationException(String.format("Function %1$s not implemented.", node.getFunctionName()));
    }

    @Override
    public Object visit(BooleanFunctionNode node) {
        switch (FunctionNode.FunctionName.lookup(node.getFunctionName())) {
            case cidrmatch: {
                return ExpressionEvaluator.cidrMatch((String)node.getArguments().get(0).accept(this), node.getArguments().get(1).accept(this));
            }
            case falseF: {
                return false;
            }
            case isbool: {
                Object arg1 = node.getArguments().get(0).accept(this);
                return arg1 == null ? false : arg1.getClass() == Boolean.class;
            }
            case isint: {
                Object arg1 = node.getArguments().get(0).accept(this);
                return arg1 == null ? false : arg1.getClass() == Integer.class;
            }
            case isnum: {
                return Number.isNumeric(node.getArguments().get(0).accept(this));
            }
            case isstr: {
                Object arg1 = node.getArguments().get(0).accept(this);
                return arg1 == null ? false : arg1.getClass() == String.class;
            }
            case isnotnull: {
                return node.getArguments().get(0).accept(this) != null;
            }
            case isnull: {
                return node.getArguments().get(0).accept(this) == null;
            }
            case like: {
                Object arg1 = node.getArguments().get(0).accept(this);
                return ExpressionEvaluator.like(arg1, node.getArguments().get(1).accept(this));
            }
            case searchmatch: {
                return node.getArguments().get(0).accept(this);
            }
            case trueF: {
                return true;
            }
            case match: {
                Object valueOb = node.getArguments().get(0).accept(this);
                Object regexOb = node.getArguments().get(1).accept(this);
                if (valueOb == null || regexOb == null) {
                    return null;
                }
                String value = valueOb.toString();
                String regex = regexOb.toString();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(value);
                return matcher.matches();
            }
        }
        throw new UnsupportedOperationException(String.format("Function %1$s not implemented.", node.getFunctionName()));
    }

    @Override
    public Object visit(ComparisonNode node) {
        Object lhs = node.getLhs().accept(this);
        Object rhs = node.getRhs().accept(this);
        return ExpressionEvaluator.compare(node.getOperator(), lhs, rhs, this.fillNull);
    }

    @Override
    public Object visit(FieldNode node) {
        this.assertHasRow();
        if (this.currentRow.containsKey(node.getFieldName())) {
            return this.currentRow.get(node.getFieldName());
        }
        if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
            return Unknown.VALUE;
        }
        return null;
    }

    @Override
    public Object visit(StringNode node) {
        return node.getValue();
    }

    @Override
    public Object visit(SearchQuotableNode node) {
        this.assertHasRow();
        boolean match = false;
        if (this.currentRow.containsKey("_raw")) {
            if (this.currentRow instanceof RepresentativeRow && this.currentRow.get("_raw") == Unknown.VALUE) {
                match = true;
            } else {
                String raw = (String)this.currentRow.get("_raw");
                match = ((TermMatcher)node.getMatcher()).match(raw);
            }
        } else if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
            match = true;
        }
        if (node.is_negated()) {
            return !match;
        }
        return match;
    }

    @Override
    public Object visit(SearchAndNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result = (Boolean)node.getArguments().get(i).accept(this);
            if (result) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object visit(SearchOrNode node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            boolean result = (Boolean)node.getArguments().get(i).accept(this);
            if (!result) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object visit(SearchXorNode node) {
        boolean preResult = (Boolean)node.getArguments().get(0).accept(this);
        for (int i = 1; i < node.getArguments().size(); ++i) {
            boolean result = (Boolean)node.getArguments().get(i).accept(this);
            preResult = result != preResult;
        }
        return preResult;
    }

    @Override
    public Object visit(SearchComparisonNode node) {
        boolean match;
        block8: {
            block6: {
                TypeNode rhs;
                Object value;
                block10: {
                    block9: {
                        block7: {
                            this.assertHasRow();
                            match = false;
                            String fieldName = node.getLhs().getFieldName();
                            if (!this.currentRow.containsKey(fieldName)) break block6;
                            value = this.currentRow.get(fieldName);
                            rhs = node.getRhs();
                            if (value != Unknown.VALUE || !(this.currentRow instanceof RepresentativeRow)) break block7;
                            match = true;
                            break block8;
                        }
                        if (value != null) break block9;
                        match = false;
                        break block8;
                    }
                    if (!(rhs instanceof StringNode)) break block10;
                    String source = value.toString();
                    IMatcher matcher = node.getMatcher();
                    switch (node.getOperator()) {
                        case EQUAL: 
                        case NOT_EQUAL: 
                        case EQUAL_EQUAL: {
                            boolean bl = match = matcher instanceof CidrMatcher ? ((CidrMatcher)matcher).match(source) : ((TermMatcher)matcher).match(source);
                            if (node.getOperator() == Operator.NOT_EQUAL) {
                                match = !match;
                                break;
                            }
                            break block8;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Operator %1$s not supported", node.getOperator().toSplOperator()));
                        }
                    }
                    break block8;
                }
                match = rhs instanceof NumberNode && Number.isNumeric(value) ? ((NumberMatcher)node.getMatcher()).match(value) : (rhs instanceof NumberNode ? ExpressionEvaluator.compareNumbers(node.getOperator(), value, ((NumberNode)rhs).getValue()) : (rhs instanceof BooleanNode && value instanceof Boolean ? ExpressionEvaluator.compareBooleans(node.getOperator(), (Boolean)value, ((BooleanNode)rhs).getValue()) : node.getOperator() == Operator.NOT_EQUAL));
                break block8;
            }
            if (this.currentRow instanceof RepresentativeRow && this.currentRow.containsKey("*")) {
                match = true;
            }
        }
        if (node.is_negated()) {
            return !match;
        }
        return match;
    }

    @Override
    public Object visit(SearchSubSearchPredicateNode node) {
        throw new UnsupportedOperationException("Evaluating Subsearch predicate expressions it not supported.");
    }

    @Override
    public Object visit(BooleanNode node) {
        return node.getValue();
    }

    @Override
    public Object visit(NullNode node) {
        return NullNode.getValue();
    }

    @Override
    public Object visit(NumberNode node) {
        return node.getValue();
    }

    private static boolean compare(Operator operator, Object lhs, Object rhs, boolean fillNull) {
        if (lhs == null || rhs == null) {
            return fillNull;
        }
        if (lhs == Unknown.VALUE || rhs == Unknown.VALUE) {
            return true;
        }
        if (Number.isNumeric(lhs) || Number.isNumeric(rhs)) {
            return ExpressionEvaluator.compareNumbers(operator, lhs, rhs);
        }
        if (lhs instanceof String || rhs instanceof String) {
            return ExpressionEvaluator.compareStrings(operator, lhs.toString(), rhs.toString());
        }
        if (lhs instanceof Boolean && rhs instanceof Boolean) {
            return ExpressionEvaluator.compareBooleans(operator, (Boolean)lhs, (Boolean)rhs);
        }
        return false;
    }

    private static boolean compareBooleans(Operator operator, Boolean lhs, Boolean rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return lhs.equals(rhs);
            }
            case NOT_EQUAL: {
                return !lhs.equals(rhs);
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for boolean comparisons.", operator.toSplOperator()));
    }

    private static boolean compareStrings(Operator operator, String lhs, String rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return lhs.equals(rhs);
            }
            case NOT_EQUAL: {
                return !lhs.equals(rhs);
            }
            case GREATER_THAN: {
                return lhs.compareTo(rhs) > 0;
            }
            case GREATER_THAN_OR_EQUAL: {
                return lhs.compareTo(rhs) >= 0;
            }
            case LESS_THAN: {
                return lhs.compareTo(rhs) < 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return lhs.compareTo(rhs) <= 0;
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for string comparisons.", operator.toSplOperator()));
    }

    private static boolean compareNumbers(Operator operator, Object lhs, Object rhs) {
        switch (operator) {
            case EQUAL: 
            case EQUAL_EQUAL: {
                return Number.equal(lhs, rhs);
            }
            case NOT_EQUAL: {
                return Number.notEqual(lhs, rhs);
            }
            case GREATER_THAN: {
                return Number.greaterThan(lhs, rhs);
            }
            case GREATER_THAN_OR_EQUAL: {
                return Number.greaterThanEqual(lhs, rhs);
            }
            case LESS_THAN: {
                return Number.lessThan(lhs, rhs);
            }
            case LESS_THAN_OR_EQUAL: {
                return Number.lessThanEqual(lhs, rhs);
            }
        }
        throw new UnsupportedOperationException(String.format("Operator %1$s not supported for numeric comparisons.", operator.toSplOperator()));
    }

    private void assertHasRow() {
        if (this.currentRow == null) {
            throw new IllegalStateException("Need a row to evaluate.");
        }
    }

    private static boolean cidrMatch(String cidr, Object ipaddress) {
        boolean retValue;
        SubnetUtils utils = new SubnetUtils(cidr);
        utils.setInclusiveHostCount(true);
        if (ipaddress == null) {
            return false;
        }
        try {
            retValue = utils.getInfo().isInRange(ipaddress.toString());
        }
        catch (IllegalArgumentException e) {
            retValue = false;
        }
        return retValue;
    }

    private static boolean like(Object value, Object pattern) {
        if (value == null) {
            return false;
        }
        if (pattern == null || !(pattern instanceof String)) {
            return false;
        }
        TermMatcher matcher = new TermMatcher(pattern.toString(), FunctionNode.FunctionName.like);
        return matcher.match(value.toString());
    }
}

