/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.providers;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.commands.FieldsCommand;
import com.splunk.commons.ast.nodes.commands.McatalogCommand;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.search.IGroupBy;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.providers.IPlanProvider;
import com.splunk.commons.providers.handlers.IGroupByHandler;
import com.splunk.commons.providers.handlers.ISelectHandler;
import com.splunk.commons.providers.handlers.IWhereHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

public class MetricsCatalogPlanProvider
implements IPlanProvider,
IWhereHandler,
IGroupByHandler,
ISelectHandler {
    private IWherePredicate wherePredicate;
    private IGroupBy[] gbFields;
    private AggregateNode[] aggregates;
    private HashSet<String> selectedFields = new HashSet();

    @Override
    public void initialize(Dataset dataset) throws IOException {
        if (!dataset.getKind().equals("catalog")) {
            throw new IOException("MetricsCatalogPlanProvider only supports catalog datasets.");
        }
    }

    @Override
    public CommandNode getCommand() {
        McatalogCommand mcatalogCommand = new McatalogCommand(this.aggregates, this.wherePredicate, this.gbFields, false, false);
        FieldNode[] excludedFields = this.getFieldExclusions();
        if (excludedFields == null) {
            return mcatalogCommand;
        }
        return new FieldsCommand(mcatalogCommand, excludedFields, true);
    }

    @Override
    public void where(IWherePredicate where) {
        this.wherePredicate = where;
    }

    @Override
    public void groupBy(IGroupBy[] fields) {
        this.gbFields = fields;
    }

    @Override
    public void select(ISelection[] projections) {
        ArrayList<AggregateNode> aggList = new ArrayList<AggregateNode>();
        for (ISelection projection : projections) {
            if (projection instanceof AggregateNode && ((AggregateNode)projection).getFunction().equals((Object)AggregateFunction.VALUES)) {
                aggList.add((AggregateNode)projection);
                continue;
            }
            if (projection instanceof FieldNode) {
                this.selectedFields.add(((FieldNode)projection).getFieldName());
                continue;
            }
            throw new IllegalArgumentException("Invalid aggregate provided for catalog dataset in SELECT clause.");
        }
        if (!aggList.isEmpty()) {
            this.aggregates = new AggregateNode[aggList.size()];
            aggList.toArray(this.aggregates);
        }
    }

    private FieldNode[] getFieldExclusions() {
        if (this.gbFields == null || this.gbFields.length == 0) {
            return null;
        }
        ArrayList<FieldNode> fieldNodeList = new ArrayList<FieldNode>();
        for (IGroupBy groupBy : this.gbFields) {
            FieldNode gbField = null;
            if (groupBy instanceof FieldNode) {
                gbField = (FieldNode)groupBy;
            } else if (groupBy instanceof BinNode) {
                gbField = ((BinNode)groupBy).getField();
            }
            if (gbField == null || this.selectedFields.contains(gbField.getFieldName())) continue;
            fieldNodeList.add(gbField);
        }
        if (fieldNodeList.isEmpty()) {
            return null;
        }
        FieldNode[] fieldArr = new FieldNode[fieldNodeList.size()];
        return fieldNodeList.toArray(fieldArr);
    }
}

