/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.datasets;

import com.splunk.commons.ast.nodes.Command;
import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.UnknownCommand;
import com.splunk.commons.datasets.BaseDataset;
import com.splunk.commons.datasets.ConstantField;
import com.splunk.commons.datasets.IField;
import com.splunk.commons.datasets.Partition;
import com.splunk.commons.datasets.Partitions;
import com.splunk.commons.datasets.Properties;
import com.splunk.commons.datasets.StaticPartitions;
import org.bson.types.ObjectId;
import org.json.JSONObject;

public class PartitionedDataset
extends BaseDataset {
    private final boolean resolved = false;
    private final Partitions partitions;

    public PartitionedDataset(ObjectId id, String module, String name, String owner, Properties properties, Partitions partitions) {
        super(id, module, name, "partitioned", owner, properties);
        this.partitions = partitions;
    }

    public CommandNode expand() {
        Partition[] partitions = this.partitions.toArray();
        CommandNode[] sources = new CommandNode[partitions.length];
        for (int i = 0; i < sources.length; ++i) {
            Partition p = partitions[i];
            CommandNode source = Command.from(p.getDataset());
            if (p.getConstraints() != null) {
                for (IField field : p.getConstraints()) {
                    if (field instanceof ConstantField) {
                        ConstantField cf = (ConstantField)field;
                        Object value = cf.getValue();
                        if (value instanceof String) {
                            source = source.eval(cf.getName(), Expression.string((String)value));
                            continue;
                        }
                        if (value instanceof Integer) {
                            source = source.eval(cf.getName(), Expression.number((int)((Integer)value)));
                            continue;
                        }
                        throw new UnsupportedOperationException("Unsupported constant value.");
                    }
                    throw new UnsupportedOperationException("Can't handle non ConstantColumns.");
                }
            }
            sources[i] = source;
        }
        if (sources.length == 0) {
            return new UnknownCommand("NULL", "", CommandType.UNKNOWN, new FieldsAndProperties().array());
        }
        if (sources.length == 1) {
            return sources[0];
        }
        return Command.union(sources);
    }

    public Partitions getPartitions() {
        return this.partitions;
    }

    @Override
    public JSONObject getJSON() {
        JSONObject jsonObject = super.getJSON();
        JSONObject jsonProps = jsonObject.getJSONObject("properties");
        if (!(this.partitions instanceof StaticPartitions)) {
            throw new RuntimeException("Serialization of Partitioning is not supported.");
        }
        jsonProps.put("partitions", (Object)((StaticPartitions)this.partitions).getJSONArray());
        return jsonObject;
    }

    private PartitionedDataset(JSONObject jsonObject, Partitions partitions) {
        super(jsonObject);
        this.partitions = partitions;
    }

    public static PartitionedDataset load(JSONObject jsonObject) {
        Partitions partitions = Partitions.load(jsonObject.getJSONObject("properties"));
        return new PartitionedDataset(jsonObject, partitions);
    }
}

