/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.ISelection;
import com.splunk.commons.ast.nodes.IWherePredicate;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanFunctionNode;
import com.splunk.commons.ast.nodes.expressions.Cardinality;
import com.splunk.commons.ast.nodes.expressions.CaseNode;
import com.splunk.commons.ast.nodes.expressions.ErrorCaseNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NavigationNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.visitors.AssertingVisitor;
import com.splunk.commons.visitors.NodeVisitor;
import com.splunk.commons.visitors.SplFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FunctionNode
extends TypeNode
implements ISelection {
    private final String functionName;
    private final List<TypeNode> args;

    FunctionNode(String functionName) {
        this(functionName, Collections.emptyList());
    }

    public FunctionNode(String functionName, TypeNode ... args) {
        this(functionName, Arrays.asList(args));
    }

    FunctionNode(String functionName, List<TypeNode> args) {
        super("function");
        this.functionName = functionName;
        this.args = args.isEmpty() ? args : Collections.unmodifiableList(args);
    }

    public static BooleanFunctionNode any(NavigationNode source, IWherePredicate predicate) {
        FunctionNode.assertParamNotNull(source, "source");
        FunctionNode.assertParamNotNull(predicate, "predicate");
        if (source.getCardinality() == Cardinality.MANY || source.getCardinality() == Cardinality.UNKNOWN) {
            return new BooleanFunctionNode(FunctionName.any.getName(), source, predicate.getTypeNode());
        }
        throw new IllegalArgumentException("The any() function can only be bound to a MANY or UNKNOWN cardinality navigation.");
    }

    public static BooleanFunctionNode all(NavigationNode source, IWherePredicate predicate) {
        FunctionNode.assertParamNotNull(source, "source");
        FunctionNode.assertParamNotNull(predicate, "predicate");
        if (source.getCardinality() == Cardinality.MANY || source.getCardinality() == Cardinality.UNKNOWN) {
            return new BooleanFunctionNode(FunctionName.all.getName(), source, predicate.getTypeNode());
        }
        throw new IllegalArgumentException("The all() function can only be bound to a MANY or UNKNOWN cardinality navigation.");
    }

    public static BooleanFunctionNode searchmatch(ISearchPredicate predicate) {
        FunctionNode.assertParamNotNull(predicate, "predicate");
        AssertingVisitor.assertOnlySearchTermsPhrasesAndGroups(predicate, "Only SearchTermNodes and SearchPhraseNodes are allowed inside a call to searchmatch.Convert SearchComparisonNodes to ComparisonNodes and make peers of the searchmatch function.");
        return new BooleanFunctionNode(FunctionName.searchmatch.getName(), predicate.getSearchNode());
    }

    public static BooleanFunctionNode xor(IWherePredicate lhs, IWherePredicate rhs) {
        FunctionNode.assertParamNotNull(lhs, "lhs");
        FunctionNode.assertParamNotNull(rhs, "rhs");
        return new BooleanFunctionNode(FunctionName.XOR.getName(), lhs.getTypeNode(), rhs.getTypeNode());
    }

    public static FunctionNode create(FunctionName functionName, TypeNode ... args) {
        FunctionNode.assertParamMembersNotNull(args, "args");
        switch (functionName) {
            case any: 
            case all: 
            case XOR: {
                return new BooleanFunctionNode(functionName.getName(), args);
            }
            case span: {
                FunctionNode.assertTrue(args.length == 2);
                return new BinNode((FieldNode)args[0], new BinOptionsNode((SpanNode)args[1]));
            }
            case searchmatch: 
            case cidrmatch: 
            case like: 
            case match: 
            case isbool: 
            case isint: 
            case isnotnull: 
            case isnull: 
            case isnum: 
            case isstr: {
                return new BooleanFunctionNode(functionName.getName(), args);
            }
            case __stats__: {
                throw new UnsupportedOperationException("Please use StatsFunctionNode constructor to create stats function.");
            }
        }
        return new FunctionNode(functionName.getName(), args);
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<TypeNode> getArguments() {
        return this.args;
    }

    protected boolean isStatsFunction() {
        return false;
    }

    public String toString() {
        return this.accept(new SplFormatter());
    }

    public boolean isShorthand() {
        if (this.isStatsFunction()) {
            return false;
        }
        return FunctionName.lookup(this.functionName).isShorthand();
    }

    @Override
    public TypeNode getTypeNode() {
        return this;
    }

    public static FunctionNode add(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.add, lhs, rhs);
    }

    public static FunctionNode concat(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.concat, lhs, rhs);
    }

    public static FunctionNode divide(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.divide, lhs, rhs);
    }

    public static FunctionNode modulo(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.modulo, lhs, rhs);
    }

    public static FunctionNode multiply(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.multiply, lhs, rhs);
    }

    public static FunctionNode subtract(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.subtract, lhs, rhs);
    }

    public static FunctionNode span(TypeNode lhs, TypeNode rhs) {
        return FunctionNode.create(FunctionName.span, lhs, rhs);
    }

    public static FunctionNode abs(TypeNode node) {
        return FunctionNode.create(FunctionName.abs, node);
    }

    public static FunctionNode acos(TypeNode node) {
        return FunctionNode.create(FunctionName.acos, node);
    }

    public static FunctionNode acosh(TypeNode node) {
        return FunctionNode.create(FunctionName.acosh, node);
    }

    public static FunctionNode asin(TypeNode node) {
        return FunctionNode.create(FunctionName.asin, node);
    }

    public static FunctionNode asinh(TypeNode node) {
        return FunctionNode.create(FunctionName.asinh, node);
    }

    public static FunctionNode atan(TypeNode node) {
        return FunctionNode.create(FunctionName.atan, node);
    }

    public static FunctionNode atan2(TypeNode x, TypeNode y) {
        return FunctionNode.create(FunctionName.atan2, x, y);
    }

    public static FunctionNode atanh(TypeNode node) {
        return FunctionNode.create(FunctionName.atanh, node);
    }

    public static FunctionNode caseFunction(CaseNode[] cases) {
        return FunctionNode.create(FunctionName.caseF, FunctionNode.convertAsTypeNodeArray(cases));
    }

    public static FunctionNode ceiling(TypeNode node) {
        return FunctionNode.create(FunctionName.ceiling, node);
    }

    public static BooleanFunctionNode cidrmatch(String cidr, String fieldName) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.cidrmatch, new StringNode(cidr), new FieldNode(fieldName));
    }

    public static FunctionNode coalesce(TypeNode first, TypeNode second) {
        return FunctionNode.create(FunctionName.coalesce, first, second);
    }

    public static FunctionNode coalesce(TypeNode[] args) {
        FunctionNode.assertTrue("Coalesce needs at least two arguments.", args.length > 1);
        return FunctionNode.create(FunctionName.coalesce, args);
    }

    public static FunctionNode cos(TypeNode node) {
        return FunctionNode.create(FunctionName.cos, node);
    }

    public static FunctionNode cosh(TypeNode node) {
        return FunctionNode.create(FunctionName.cosh, node);
    }

    public static FunctionNode exact(TypeNode expression) {
        return FunctionNode.create(FunctionName.exact, expression);
    }

    public static FunctionNode exp(TypeNode node) {
        return FunctionNode.create(FunctionName.exp, node);
    }

    public static FunctionNode floor(TypeNode node) {
        return FunctionNode.create(FunctionName.floor, node);
    }

    public static FunctionNode hypot(TypeNode x, TypeNode y) {
        return FunctionNode.create(FunctionName.hypot, x, y);
    }

    public static FunctionNode ifFunction(IWherePredicate predicate, TypeNode trueValue, TypeNode falseValue) {
        return FunctionNode.create(FunctionName.ifF, predicate.getTypeNode(), trueValue, falseValue);
    }

    public static BooleanFunctionNode isbool(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isbool, candidate);
    }

    public static BooleanFunctionNode isint(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isint, candidate);
    }

    public static BooleanFunctionNode isnotnull(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isnotnull, candidate);
    }

    public static BooleanFunctionNode isnull(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isnull, candidate);
    }

    public static BooleanFunctionNode isnum(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isnum, candidate);
    }

    public static BooleanFunctionNode isstr(TypeNode candidate) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.isstr, candidate);
    }

    public static FunctionNode len(TypeNode node) {
        return FunctionNode.create(FunctionName.len, node);
    }

    public static BooleanFunctionNode like(String fieldName, String pattern) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.like, new FieldNode(fieldName), new StringNode(pattern));
    }

    public static BooleanFunctionNode like(FieldNode field, StringNode pattern) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.like, field, pattern);
    }

    public static FunctionNode ln(TypeNode node) {
        return FunctionNode.create(FunctionName.ln, node);
    }

    public static FunctionNode log(TypeNode node) {
        return FunctionNode.create(FunctionName.log, node);
    }

    public static FunctionNode log(TypeNode node, int number) {
        return FunctionNode.create(FunctionName.log, node, new NumberNode(number));
    }

    public static FunctionNode lower(TypeNode node) {
        return FunctionNode.create(FunctionName.lower, node);
    }

    public static FunctionNode ltrim(TypeNode node) {
        return FunctionNode.create(FunctionName.ltrim, node);
    }

    public static FunctionNode ltrim(TypeNode node, TypeNode trimCharacters) {
        return FunctionNode.create(FunctionName.ltrim, node, trimCharacters);
    }

    public static BooleanFunctionNode match(String fieldName, String regex) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.match, new FieldNode(fieldName), new StringNode(regex));
    }

    public static BooleanFunctionNode match(StringNode value, String regex) {
        return (BooleanFunctionNode)FunctionNode.create(FunctionName.match, value, new StringNode(regex));
    }

    public static FunctionNode max(TypeNode[] args) {
        return FunctionNode.create(FunctionName.max, args);
    }

    public static FunctionNode md5(TypeNode node) {
        return FunctionNode.create(FunctionName.md5, node);
    }

    public static FunctionNode min(TypeNode[] args) {
        return FunctionNode.create(FunctionName.min, args);
    }

    public static FunctionNode mvindex(TypeNode mvfield, int startIndex, int endIndex) {
        FunctionNode.assertTrue("EndIndex must be greater than or equal to StartIndex.", endIndex >= startIndex);
        return FunctionNode.create(FunctionName.mvindex, mvfield, new NumberNode(startIndex), new NumberNode(endIndex));
    }

    public static FunctionNode mvindex(TypeNode mvfield, int startIndex) {
        return FunctionNode.create(FunctionName.mvindex, mvfield, new NumberNode(startIndex));
    }

    public static FunctionNode mvjoin(TypeNode mvfield, String separator) {
        return FunctionNode.create(FunctionName.mvjoin, mvfield, new StringNode(separator));
    }

    public static FunctionNode mvrange(int start, int end, int increment) {
        FunctionNode.assertTrue("The start of the range must be less than the array of the range.", end > start);
        return FunctionNode.mvrange(new NumberNode(start), new NumberNode(end), new NumberNode(increment));
    }

    private static FunctionNode mvrange(TypeNode start, TypeNode end, TypeNode increment) {
        return FunctionNode.create(FunctionName.mvrange, start, end, increment);
    }

    public static FunctionNode mvzip(TypeNode mvleft, TypeNode mvright, TypeNode separator) {
        return FunctionNode.create(FunctionName.mvzip, mvleft, mvright, separator);
    }

    public static FunctionNode now() {
        return FunctionNode.create(FunctionName.now, new TypeNode[0]);
    }

    public static FunctionNode nullIf(TypeNode first, TypeNode second) {
        return FunctionNode.create(FunctionName.nullif, first, second);
    }

    public static FunctionNode pi() {
        return FunctionNode.create(FunctionName.pi, new TypeNode[0]);
    }

    public static FunctionNode pow(TypeNode x, TypeNode y) {
        return FunctionNode.create(FunctionName.pow, x, y);
    }

    public static FunctionNode random() {
        return FunctionNode.create(FunctionName.random, new TypeNode[0]);
    }

    public static FunctionNode relative_time(TypeNode time, String timespan) {
        return FunctionNode.create(FunctionName.relative_time, time, new StringNode(timespan));
    }

    public static FunctionNode replace(TypeNode target, TypeNode lookFor, TypeNode replaceWith) {
        return FunctionNode.create(FunctionName.replace, target, lookFor, replaceWith);
    }

    public static FunctionNode round(TypeNode x, TypeNode y) {
        return FunctionNode.create(FunctionName.round, x, y);
    }

    public static FunctionNode round(TypeNode x) {
        return FunctionNode.create(FunctionName.round, x);
    }

    public static FunctionNode rtrim(TypeNode node) {
        return FunctionNode.create(FunctionName.rtrim, node);
    }

    public static FunctionNode rtrim(TypeNode node, TypeNode trimCharacters) {
        return FunctionNode.create(FunctionName.rtrim, node, trimCharacters);
    }

    public static FunctionNode sha1(TypeNode node) {
        return FunctionNode.create(FunctionName.sha1, node);
    }

    public static FunctionNode sha256(TypeNode node) {
        return FunctionNode.create(FunctionName.sha256, node);
    }

    public static FunctionNode sha512(TypeNode node) {
        return FunctionNode.create(FunctionName.sha512, node);
    }

    public static FunctionNode sigfig(TypeNode node) {
        return FunctionNode.create(FunctionName.sigfig, node);
    }

    public static FunctionNode sin(TypeNode node) {
        return FunctionNode.create(FunctionName.sin, node);
    }

    public static FunctionNode sinh(TypeNode node) {
        return FunctionNode.create(FunctionName.sinh, node);
    }

    public static FunctionNode spath(String fieldName, String spathExpression) {
        return FunctionNode.create(FunctionName.spath, Expression.field(fieldName), Expression.string(spathExpression));
    }

    public static FunctionNode split(String fieldName, String delimiter) {
        FunctionNode.assertTrue("Delimiter must be a single character long.", delimiter.length() == 1);
        return FunctionNode.create(FunctionName.split, Expression.field(fieldName), Expression.string(delimiter));
    }

    public static FunctionNode strptime(TypeNode timestamp, String timeformat) {
        return FunctionNode.create(FunctionName.strptime, timestamp, new StringNode(timeformat));
    }

    public static FunctionNode substr(TypeNode node, NumberNode start, NumberNode end) {
        return FunctionNode.create(FunctionName.substr, node, start, end);
    }

    public static FunctionNode substr(TypeNode node, NumberNode start) {
        return FunctionNode.create(FunctionName.substr, node, start);
    }

    public static FunctionNode tan(TypeNode node) {
        return FunctionNode.create(FunctionName.tan, node);
    }

    public static FunctionNode tanh(TypeNode node) {
        return FunctionNode.create(FunctionName.tanh, node);
    }

    public static FunctionNode time() {
        return FunctionNode.create(FunctionName.time, new TypeNode[0]);
    }

    public static FunctionNode tonumber(StringNode number, int base) {
        FunctionNode.assertTrue("The base must between 2 and 36", base > 1 && base < 37);
        return FunctionNode.create(FunctionName.tonumber, number, new NumberNode(base));
    }

    public static FunctionNode tostring(NumberNode number) {
        return FunctionNode.create(FunctionName.tostring, number);
    }

    public static FunctionNode tostring(NumberNode number, String format) {
        FunctionNode.assertTrue("Valid formats are 'hex', 'commas' or 'duration'.", format.equals("hex") || format.equals("commas") || format.equals("duration"));
        return FunctionNode.create(FunctionName.tostring, number, new StringNode(format));
    }

    public static FunctionNode tostring(IWherePredicate predicate) {
        return FunctionNode.create(FunctionName.tostring, predicate.getTypeNode());
    }

    public static FunctionNode trim(TypeNode node) {
        return FunctionNode.create(FunctionName.trim, node);
    }

    public static FunctionNode trim(TypeNode node, TypeNode trimCharacters) {
        return FunctionNode.create(FunctionName.trim, node, trimCharacters);
    }

    public static FunctionNode typeof(TypeNode candidate) {
        return FunctionNode.create(FunctionName.typeof, candidate);
    }

    public static FunctionNode upper(TypeNode node) {
        return FunctionNode.create(FunctionName.upper, node);
    }

    public static FunctionNode urldecode(TypeNode node) {
        return FunctionNode.create(FunctionName.urldecode, node);
    }

    public static FunctionNode validate(ErrorCaseNode[] checks) {
        FunctionNode.assertTrue("There must be at least one thing to validate.", checks.length > 0);
        return FunctionNode.create(FunctionName.validate, FunctionNode.convertAsTypeNodeArray(checks));
    }

    private static TypeNode[] convertAsTypeNodeArray(CaseNode[] cases) {
        FunctionNode.assertParamNotNull(cases, "cases");
        TypeNode[] args = new TypeNode[cases.length * 2];
        for (int i = 0; i < cases.length; ++i) {
            args[i * 2] = cases[i].getCondition().getTypeNode();
            args[i * 2 + 1] = cases[i].getValue();
        }
        return args;
    }

    public static class StatsFunctionNode
    extends FunctionNode {
        public StatsFunctionNode(AggregateFunction functionName, TypeNode ... args) {
            super(functionName.toString(), args);
        }

        @Override
        public boolean isStatsFunction() {
            return true;
        }
    }

    public static enum FunctionName {
        caseF,
        cidrmatch,
        coalesce,
        ifF,
        in,
        like,
        match,
        nullif,
        searchmatch,
        validate,
        nullF,
        trueF,
        falseF,
        printf,
        tonumber,
        tostring,
        md5,
        sha1,
        sha256,
        sha512,
        now,
        relative_time,
        strftime,
        strptime,
        time,
        isbool,
        isint,
        isnotnull,
        isnull,
        isnum,
        isstr,
        typeof,
        abs,
        ceiling,
        exact,
        exp,
        floor,
        ln,
        log,
        pi,
        pow,
        round,
        sigfig,
        sqrt,
        commands,
        mvappend,
        mvcount,
        mvdedup,
        mvfilter,
        mvfind,
        mvindex,
        mvjoin,
        mvrange,
        mvsort,
        mvzip,
        split,
        max,
        min,
        random,
        len,
        lower,
        ltrim,
        replace,
        rtrim,
        spath,
        substr,
        trim,
        upper,
        urldecode,
        acos,
        acosh,
        asin,
        asinh,
        atan,
        atan2,
        atanh,
        cos,
        cosh,
        hypot,
        sin,
        sinh,
        tan,
        tanh,
        any,
        all,
        XOR,
        span,
        add,
        concat,
        divide,
        modulo,
        multiply,
        subtract,
        eval,
        __stats__;


        public String getName() {
            switch (this) {
                case caseF: {
                    return "case";
                }
                case ifF: {
                    return "if";
                }
                case concat: {
                    return ".";
                }
                case divide: {
                    return "/";
                }
                case modulo: {
                    return "%";
                }
                case multiply: {
                    return "*";
                }
                case add: {
                    return "+";
                }
                case subtract: {
                    return "-";
                }
                case nullF: {
                    return "null";
                }
                case trueF: {
                    return "true";
                }
                case falseF: {
                    return "false";
                }
            }
            return this.name();
        }

        public static FunctionName lookup(String name) throws SPLParseException {
            switch (name) {
                case "case": {
                    return caseF;
                }
                case "if": {
                    return ifF;
                }
                case ".": {
                    return concat;
                }
                case "/": {
                    return divide;
                }
                case "%": {
                    return modulo;
                }
                case "*": {
                    return multiply;
                }
                case "+": {
                    return add;
                }
                case "-": {
                    return subtract;
                }
                case "null": {
                    return nullF;
                }
                case "true": {
                    return trueF;
                }
                case "false": {
                    return falseF;
                }
            }
            try {
                return FunctionName.valueOf(name);
            }
            catch (IllegalArgumentException e) {
                if (AggregateFunction.isStatsFunction(name)) {
                    return __stats__;
                }
                throw new SPLParseException("The function is not supported: " + name);
            }
        }

        public boolean isUnsupportedBySPLV2() {
            switch (this) {
                case nullF: 
                case trueF: 
                case falseF: {
                    return true;
                }
            }
            return false;
        }

        private boolean isShorthand() {
            switch (this) {
                case concat: 
                case divide: 
                case modulo: 
                case multiply: 
                case add: 
                case subtract: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }
}

