/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.Expression;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.ArrayList;

public class RenameNode
extends Node {
    private final FieldNode field;
    private final FieldNode newField;

    private RenameNode(FieldNode field, FieldNode newField) {
        this.field = field;
        this.newField = newField;
    }

    public RenameNode(String field, String newField) {
        this(new FieldNode(field), new FieldNode(newField));
    }

    public FieldNode getField() {
        return this.field;
    }

    public FieldNode getNewField() {
        return this.newField;
    }

    public String getFieldName() {
        return this.field.getFieldName();
    }

    public String getNewFieldName() {
        return this.newField.getFieldName();
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RenameNodeArray and(String fieldName, String newFieldName) {
        return this.and(Expression.rename(fieldName, newFieldName));
    }

    private RenameNodeArray and(RenameNode rename) {
        return new RenameNodeArray().and(this).and(rename);
    }

    public RenameNode[] array() {
        return new RenameNode[]{this};
    }

    public String toString() {
        return String.format("%s as %s", this.field, this.newField);
    }

    public class RenameNodeArray {
        private final ArrayList<RenameNode> renames = new ArrayList();

        public RenameNodeArray and(String fieldName, String newFieldName) {
            return this.and(Expression.rename(fieldName, newFieldName));
        }

        private RenameNodeArray and(RenameNode rename) {
            RenameNode.assertNotNull("rename", rename);
            this.renames.add(rename);
            return this;
        }

        public RenameNode[] array() {
            return this.renames.toArray(new RenameNode[this.renames.size()]);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("rename ");
            for (RenameNode renameNode : this.renames) {
                sb.append(renameNode.toString() + ',');
            }
            return sb.substring(0, sb.length() - 1);
        }
    }
}

