/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.commands.SearchCommand;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.visitors.NodeVisitor;

public class MvexpandCommand
extends CommandNode {
    public static final int DEFAULT_LIMIT = 0;
    private final NumberNode limitNode;
    private final FieldNode fieldNode;

    public MvexpandCommand(CommandNode source, FieldNode fieldNode, NumberNode limitNode) {
        super(source, "mvexpand", CommandType.SP_STATEFUL, new FieldsAndProperties().field(fieldNode.getFieldName()).array());
        this.fieldNode = fieldNode;
        this.limitNode = limitNode;
    }

    public MvexpandCommand(CommandNode source, FieldNode fieldNode, int limit) {
        this(source, fieldNode, new NumberNode(limit));
    }

    public MvexpandCommand(CommandNode source, FieldNode fieldNode) {
        this(source, fieldNode, 0);
    }

    private MvexpandCommand(FieldNode fieldNode) {
        this((CommandNode)new SearchCommand(), fieldNode, null);
    }

    public MvexpandCommand(String fieldName, int limit) {
        this((CommandNode)new SearchCommand(), new FieldNode(fieldName), limit);
    }

    public MvexpandCommand(String fieldName) {
        this(new FieldNode(fieldName));
    }

    public NumberNode getLimit() {
        return this.limitNode;
    }

    public FieldNode getFieldNode() {
        return this.fieldNode;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        return new MvexpandCommand(source, this.fieldNode, this.limitNode);
    }
}

