/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.ast.nodes.expressions.AssignmentNode;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.Set;

public class EvalCommand
extends CommandNode {
    private final AssignmentNode[] assignments;

    public EvalCommand(CommandNode source, AssignmentNode[] assignments) throws IllegalArgumentException {
        super(source, "eval", CommandType.SP_STREAM, new FieldsAndProperties().eval(assignments).array());
        if (assignments == null || assignments.length == 0) {
            throw new IllegalArgumentException("One or more assignments required");
        }
        this.assignments = assignments;
    }

    public AssignmentNode[] getAssignments() {
        return this.assignments;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CommandNode setSource(CommandNode source) {
        EvalCommand.assertNotNull(source);
        return new EvalCommand(source, this.assignments);
    }

    @Override
    public void setRequiredFields(Set<String> requiredFields) {
    }
}

