/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes;

import com.splunk.commons.visitors.NodeVisitor;
import java.io.Serializable;

public class Node
implements Serializable {
    protected static void assertTrue(boolean b) {
        if (!b) {
            throw new IllegalArgumentException();
        }
    }

    protected static void assertTrue(String errorMsg, boolean b) {
        if (!b) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    protected static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
    }

    protected static void assertNotNull(String errorMsg, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    protected static void assertParamNotNull(Object o, String parameterName) {
        if (o == null) {
            throw new IllegalArgumentException('\'' + parameterName + "' must not be null.");
        }
    }

    protected static void assertParamMembersNotNull(Object[] objects, String parameterName) {
        Node.assertParamNotNull(objects, parameterName);
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != null) continue;
            throw new IllegalArgumentException(String.format("One or more of the members of the %1$s parameter array are null, all must be non-null.", parameterName));
        }
    }

    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    static void assertEquals(Object a, Object b) {
        if (a == null && b != null || !a.equals(b)) {
            throw new IllegalArgumentException();
        }
    }
}

