/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.antlr;

import com.splunk.commons.ast.SPLParseException;
import com.splunk.commons.ast.antlr.ExpressionVisitor;
import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.AggregateFunction;
import com.splunk.commons.ast.nodes.expressions.AggregateNode;
import com.splunk.commons.ast.nodes.expressions.BinNode;
import com.splunk.commons.ast.nodes.expressions.BinOptionsNode;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.EvalAggregateNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.FunctionNode;
import com.splunk.commons.ast.nodes.expressions.LogSpanNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.PercentageAggregateNode;
import com.splunk.commons.ast.nodes.expressions.SpanNode;
import com.splunk.commons.ast.nodes.expressions.SparklineAggregateNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TableColumnOptionsNode;
import com.splunk.commons.ast.nodes.expressions.TimeSpanNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.util.VisitorUtil;
import com.splunk.spl.parser.SplunkCommandParser;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;

public class StatsAndChartVisitor
extends ExpressionVisitor {
    private final boolean wildcardFieldWithStatsAggregation;

    public StatsAndChartVisitor(boolean wildcardFieldWithStatsAggregation) {
        this.wildcardFieldWithStatsAggregation = wildcardFieldWithStatsAggregation;
    }

    @Override
    public AggregateNode visitTimeAggregation(SplunkCommandParser.TimeAggregationContext ctx) {
        AggregateFunction func = AggregateFunction.fromString(ctx.timeFunctionName().getText());
        FieldNode field = null;
        FunctionNode funcEval = null;
        if (ctx.genericfield() != null) {
            field = (FieldNode)this.visit((ParseTree)ctx.genericfield());
        } else {
            funcEval = (FunctionNode)this.visit((ParseTree)ctx.statsEvalFunction());
        }
        FieldNode asField = null;
        if (ctx.asClause() != null) {
            asField = (FieldNode)this.visit((ParseTree)ctx.asClause().genericfield());
        }
        return new AggregateNode(func, field, asField, null, funcEval);
    }

    @Override
    public Node visitSparklineAggregation(SplunkCommandParser.SparklineAggregationContext ctx) {
        SplunkCommandParser.SparklineAggregateFNContext statsFuncName = ctx.statsFunc;
        SplunkCommandParser.GenericfieldContext statsFuncField = ctx.statsFuncField;
        SplunkCommandParser.AsClauseContext asContext = ctx.asClause();
        AggregateFunction func = null;
        if (statsFuncName != null) {
            func = AggregateFunction.fromString(statsFuncName.getText());
        }
        FieldNode funcField = null;
        if (statsFuncField != null) {
            funcField = (FieldNode)this.visit((ParseTree)statsFuncField);
        }
        StringNode timeSpan = SparklineAggregateNode.DefaultTimeSpan;
        if (ctx.TIME_SPAN() != null) {
            timeSpan = new StringNode(ctx.TIME_SPAN().getText());
        }
        FieldNode asField = null;
        if (asContext != null) {
            asField = (FieldNode)this.visit((ParseTree)asContext.genericfield());
        }
        SparklineAggregateNode aNode = asField == null ? new SparklineAggregateNode(func, funcField, timeSpan) : new SparklineAggregateNode(func, funcField, timeSpan, asField);
        return aNode;
    }

    @Override
    public AggregateNode visitStatsAggregation(SplunkCommandParser.StatsAggregationContext ctx) {
        AggregateNode aNode;
        SplunkCommandParser.StatsFunctionNameContext statsFuncName = ctx.statsFunction().statsFunctionName();
        SplunkCommandParser.StatsEvalFunctionContext statsFuncEval = ctx.statsFunction().statsFuncEval;
        SplunkCommandParser.GenericfieldContext statsFuncField = ctx.statsFunction().statsFuncField;
        SplunkCommandParser.AsClauseContext asContext = ctx.asClause();
        String funcName = AggregateFunction.COUNT.toString();
        if (ctx.statsFunction().COUNT() == null) {
            funcName = statsFuncName.getText();
        }
        AggregateFunction func = AggregateFunction.fromString(funcName);
        FieldNode funcField = null;
        if (statsFuncField != null) {
            if (!this.wildcardFieldWithStatsAggregation && statsFuncField.WCQFIELD() != null) {
                throw new IllegalArgumentException("The wildcard field containing '*' cannot be used: " + statsFuncField.getText());
            }
            funcField = (FieldNode)this.visit((ParseTree)statsFuncField);
        }
        FunctionNode funcEval = null;
        if (statsFuncEval != null) {
            funcEval = (FunctionNode)this.visit((ParseTree)statsFuncEval);
        }
        FieldNode asField = null;
        if (asContext != null) {
            asField = (FieldNode)this.visit((ParseTree)asContext.genericfield());
        }
        if (func.equals((Object)AggregateFunction.PERC_X) || func.equals((Object)AggregateFunction.EXACTPERC_X) || func.equals((Object)AggregateFunction.UPPERPERC_X)) {
            int percentile = Integer.valueOf(funcName.replaceAll("\\D+", ""));
            aNode = new PercentageAggregateNode(func, funcField, asField, percentile);
        } else {
            aNode = new AggregateNode(func, funcField, asField, null, funcEval);
        }
        return aNode;
    }

    @Override
    public FunctionNode.StatsFunctionNode visitStatsFunction(SplunkCommandParser.StatsFunctionContext ctx) {
        if (ctx.statsFuncField != null) {
            FieldNode funcField = (FieldNode)this.visit((ParseTree)ctx.statsFuncField);
            return new FunctionNode.StatsFunctionNode(AggregateFunction.fromString(ctx.statsFunctionName().getText()), funcField);
        }
        if (ctx.statsFuncEval != null) {
            FunctionNode evalFunction = (FunctionNode)this.visit((ParseTree)ctx.statsFuncEval);
            return new FunctionNode.StatsFunctionNode(AggregateFunction.fromString(ctx.statsFunctionName().getText()), evalFunction);
        }
        throw new UnsupportedOperationException("Unsupported stats function: " + ctx.getText());
    }

    @Override
    public FunctionNode visitNonboolExpressionEvalFunc(SplunkCommandParser.NonboolExpressionEvalFuncContext ctx) {
        return this.visitStatsEvalFunction(ctx.statsEvalFunction());
    }

    @Override
    public FunctionNode visitNonboolExpressionStatsFunction(SplunkCommandParser.NonboolExpressionStatsFunctionContext ctx) {
        return this.visitStatsFunction(ctx.statsFunction());
    }

    @Override
    public EvalAggregateNode visitEvalAggregation(SplunkCommandParser.EvalAggregationContext ctx) {
        SplunkCommandParser.AsClauseContext asContext = ctx.asClause();
        FieldNode asField = null;
        if (asContext != null) {
            asField = (FieldNode)this.visit((ParseTree)asContext.genericfield());
        }
        FunctionNode funcEval = this.visitStatsEvalFunction(ctx.statsEvalFunction());
        return new EvalAggregateNode(asField, funcEval);
    }

    @Override
    public FunctionNode visitStatsEvalFunction(SplunkCommandParser.StatsEvalFunctionContext ctx) {
        String evalName = ctx.EVAL().getText();
        SplunkCommandParser.ExpressionContext evalExpr = ctx.expression();
        SplunkCommandParser.AssignExpressionContext evalAssign = ctx.assignExpression();
        if (evalExpr != null) {
            return new FunctionNode(evalName, (TypeNode)this.visit((ParseTree)evalExpr));
        }
        if (evalAssign != null) {
            return new FunctionNode(evalName, (TypeNode)this.visit((ParseTree)evalAssign));
        }
        return null;
    }

    @Override
    public Node visitTimeSpanFunc(SplunkCommandParser.TimeSpanFuncContext ctx) {
        return new BinNode(new FieldNode(ctx.field().getText()), new BinOptionsNode(new TimeSpanNode(ctx.TIME_SPAN().getText())));
    }

    @Override
    public Node visitTimeSpanField(SplunkCommandParser.TimeSpanFieldContext ctx) {
        return new BinNode(new FieldNode(ctx.field().getText()), new BinOptionsNode(new TimeSpanNode(ctx.TIME_SPAN().getText())));
    }

    @Override
    public Node visitBinStartOpt(SplunkCommandParser.BinStartOptContext ctx) {
        if (ctx.number().INTEGER() != null) {
            return new NumberNode(Integer.parseInt(ctx.number().getText()));
        }
        return new NumberNode(Double.parseDouble(ctx.number().getText()));
    }

    @Override
    public Node visitBinEndOpt(SplunkCommandParser.BinEndOptContext ctx) {
        if (ctx.number().INTEGER() != null) {
            return new NumberNode(Integer.parseInt(ctx.number().getText()));
        }
        return new NumberNode(Double.parseDouble(ctx.number().getText()));
    }

    @Override
    public Node visitBinBinsOpt(SplunkCommandParser.BinBinsOptContext ctx) {
        return new NumberNode(Integer.parseInt(ctx.INTEGER().getText()));
    }

    @Override
    public Node visitBinMinspanOpt(SplunkCommandParser.BinMinspanOptContext ctx) {
        return new TimeSpanNode(ctx.TIME_SPAN().getText());
    }

    @Override
    public Node visitBinSpanOpt(SplunkCommandParser.BinSpanOptContext ctx) {
        if (ctx.LOG_SPAN() != null) {
            return new LogSpanNode(ctx.LOG_SPAN().getText());
        }
        if (ctx.TIME_SPAN() != null) {
            return new TimeSpanNode(ctx.TIME_SPAN().getText());
        }
        if (ctx.TIME_SNAP() != null) {
            return new TimeSpanNode(ctx.TIME_SNAP().getText());
        }
        throw new SPLParseException("Failed to parse span option: either logspan or timespan or timesnap is required: ctx=" + ctx.getText());
    }

    @Override
    public TableColumnOptionsNode visitTableColumnOptions(SplunkCommandParser.TableColumnOptionsContext ctx) {
        BinOptionsNode binOptions = this.visitBinOptionsAtMostOnce(ctx.binOptions());
        BooleanNode useNull = (BooleanNode)VisitorUtil.visitAtMostOnce("usenull", ctx.tcUseNullOpt(), this);
        BooleanNode useOther = (BooleanNode)VisitorUtil.visitAtMostOnce("useother", ctx.tcUseOtherOpt(), this);
        StringNode nullStr = (StringNode)VisitorUtil.visitAtMostOnce("nullstr", ctx.tcNullStrOpt(), this);
        StringNode otherStr = (StringNode)VisitorUtil.visitAtMostOnce("otherstr", ctx.tcOtherStrOpt(), this);
        if (VisitorUtil.allNull(binOptions, useNull, useOther, nullStr, otherStr)) {
            return null;
        }
        if (binOptions == null) {
            return new TableColumnOptionsNode(useNull, useOther, nullStr, otherStr);
        }
        return new TableColumnOptionsNode(binOptions, useNull, useOther, nullStr, otherStr);
    }

    @Override
    public Node visitTableColumnSplitBy(SplunkCommandParser.TableColumnSplitByContext ctx) {
        FieldNode field = (FieldNode)this.visit((ParseTree)ctx.field());
        if (ctx.tableColumnOptions() == null) {
            return field;
        }
        TableColumnOptionsNode tcOptions = (TableColumnOptionsNode)this.visit((ParseTree)ctx.tableColumnOptions());
        return new BinNode(field, tcOptions);
    }

    public BinOptionsNode visitBinOptionsAtMostOnce(List<SplunkCommandParser.BinOptionsContext> ctx) {
        if (ctx.isEmpty()) {
            return null;
        }
        NumberNode bins = null;
        TimeSpanNode minspan = null;
        SpanNode span = null;
        NumberNode start = null;
        NumberNode end = null;
        for (SplunkCommandParser.BinOptionsContext binOpts : ctx) {
            bins = VisitorUtil.visitAtMostOnce("bins", (ParseTree)binOpts.binBinsOpt(), bins, this);
            minspan = VisitorUtil.visitAtMostOnce("minspan", (ParseTree)binOpts.binMinspanOpt(), minspan, this);
            span = VisitorUtil.visitAtMostOnce("span", (ParseTree)binOpts.binSpanOpt(), span, this);
            if (binOpts.binStartEndOpt() == null) continue;
            start = VisitorUtil.visitAtMostOnce("start", (ParseTree)binOpts.binStartEndOpt().binStartOpt(), start, this);
            end = VisitorUtil.visitAtMostOnce("end", (ParseTree)binOpts.binStartEndOpt().binEndOpt(), end, this);
        }
        if (VisitorUtil.allNull(span, minspan, bins, start, end)) {
            return null;
        }
        return new BinOptionsNode(span, minspan, bins, start, end);
    }
}

