#!/usr/bin/env python
# coding=utf-8
#
# Copyright © Splunk, Inc. All Rights Reserved.

""" print_manifest_documentation - Produces HTML documentation for the elements of a Splunk app manifest

Usage
-----

PYTHONPATH=$SPLUNK_SOURCE/python-site $SPLUNK_SOURCE/python-site/slim/print_manifest_documentation >[filename]

"""

from __future__ import absolute_import, division, print_function, unicode_literals

from lxml.html import tostring
import sys

from slim.app import AppManifest

print(tostring(AppManifest.schema.to_html(), pretty_print=True), file=sys.stdout)
