/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache.reporting;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Report {
    Map<String, Object> values = new HashMap<String, Object>();

    private synchronized void updateValue(String key, Object val, UpdatesValue puts) {
        Object old = this.values.get(key);
        if (old == null) {
            this.values.put(key, val);
        } else {
            puts.update(old);
        }
    }

    public void earlyTime(final String key, final long time) {
        this.updateValue(key, time, new UpdatesValue(){

            @Override
            public void update(Object old) {
                if (time < (Long)old) {
                    Report.this.values.put(key, time);
                }
            }
        });
    }

    public void lateTime(final String key, final long time) {
        this.updateValue(key, time, new UpdatesValue(){

            @Override
            public void update(Object old) {
                if (time > (Long)old) {
                    Report.this.values.put(key, time);
                }
            }
        });
    }

    public void increment(final String key, final long size) {
        this.updateValue(key, size, new UpdatesValue(){

            @Override
            public void update(Object old) {
                Report.this.values.put(key, size + (Long)old);
            }
        });
    }

    public void set(final String key, final Object val) {
        this.updateValue(key, val, new UpdatesValue(){

            @Override
            public void update(Object old) {
                Report.this.values.put(key, val);
            }
        });
    }

    public void allTrue(final String key, final boolean b) {
        this.updateValue(key, b, new UpdatesValue(){

            @Override
            public void update(Object old) {
                Report.this.values.put(key, b && (Boolean)old != false);
            }
        });
    }

    public void setRatio(final String key, String numerator, String denominator) {
        final Ratio ratio = new Ratio(numerator, denominator);
        this.updateValue(key, ratio, new UpdatesValue(){

            @Override
            public void update(Object old) {
                Report.this.values.put(key, ratio);
            }
        });
    }

    public Object get(String key) {
        Object value = this.values.get(key);
        if (value == null) {
            throw new RuntimeException("Report did not have key: " + key);
        }
        if (value instanceof Ratio) {
            return ((Ratio)value).getValue();
        }
        return value;
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (String k : this.keySet()) {
            sb.append(", :" + k + " " + this.get(k));
        }
        sb.append("}");
        return sb.toString();
    }

    public Map<String, String> toMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String key : this.keySet()) {
            m.put(key, this.get(key).toString());
        }
        return m;
    }

    private class Ratio {
        private String numerator;
        private String denominator;

        public Ratio(String numerator, String denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public double getValue() {
            if (!Report.this.values.containsKey(this.numerator) || !Report.this.values.containsKey(this.denominator)) {
                return Double.NaN;
            }
            return this.divLongs((Long)Report.this.get(this.numerator), (Long)Report.this.get(this.denominator));
        }

        private double divLongs(long l1, long l2) {
            if (l2 == 0L) {
                return Double.NaN;
            }
            double d1 = Double.longBitsToDouble(l1);
            double d2 = Double.longBitsToDouble(l2);
            return d1 / d2;
        }
    }

    private static interface UpdatesValue {
        public void update(Object var1);
    }
}

