/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datasource.hive;

import com.splunk.datasource.Field;
import com.splunk.datasource.Writer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;

public class OrcWriter
implements Writer {
    private org.apache.hadoop.hive.ql.io.orc.Writer writer;
    private List<Field> fields;
    private boolean errorIfFieldMissing;

    public OrcWriter(Path file, List<Field> fields, OrcFile.WriterOptions options) throws IOException {
        this(file, fields, options, false);
    }

    public OrcWriter(Path file, List<Field> fields, OrcFile.WriterOptions options, boolean errorIfFieldMissing) throws IOException {
        ArrayList<Object> ois = new ArrayList<Object>(fields.size());
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            if (field.getRepetition() == Field.Repetition.REPEATED) {
                ois.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getReflectionObjectInspector((Type)Field.toType(field.getFieldType()), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA)));
            } else {
                ois.add(ObjectInspectorFactory.getReflectionObjectInspector((Type)Field.toType(field.getFieldType()), (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA));
            }
            fieldNames.add(field.getFieldName());
        }
        StandardStructObjectInspector soi = ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, ois);
        options.inspector((ObjectInspector)soi);
        this.writer = OrcFile.createWriter((Path)file, (OrcFile.WriterOptions)options);
        this.fields = fields;
        this.errorIfFieldMissing = errorIfFieldMissing;
    }

    @Override
    public void write(Map<String, Object> keyValues) throws IOException {
        ArrayList<Object> row = new ArrayList<Object>();
        for (Field f : this.fields) {
            Object o = keyValues.get(f.getFieldName());
            if (o == null) {
                if (this.errorIfFieldMissing) {
                    throw new RuntimeException("Failed to find the field in keyValues map. field=" + f.getFieldName());
                }
                row.add(o);
                continue;
            }
            if (f.getFieldType() == Field.FieldType.LONG) {
                o = Long.parseLong((String)o);
            } else if (f.getFieldType() == Field.FieldType.INT) {
                o = Integer.parseInt((String)o);
            } else if (f.getFieldType() == Field.FieldType.DOUBLE) {
                o = Double.parseDouble((String)o);
            } else if (f.getFieldType() == Field.FieldType.FLOAT) {
                o = Float.valueOf(Float.parseFloat((String)o));
            } else if (f.getFieldType() == Field.FieldType.SHORT) {
                o = Short.parseShort((String)o);
            } else if (f.getFieldType() == Field.FieldType.BYTE) {
                o = Byte.parseByte((String)o);
            } else if (f.getFieldType() == Field.FieldType.BOOLEAN) {
                o = Boolean.parseBoolean((String)o);
            }
            row.add(o);
        }
        this.writer.addRow(row);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

