/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class IOUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long copyBytes(InputStream in, OutputStream out, long maxBytes, boolean close) throws IOException {
        return IOUtil.copyBytes(in, out, maxBytes, 8192, close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyBytes(InputStream in, OutputStream out, long maxBytes, int bufferSize, boolean close) throws IOException {
        byte[] buf = new byte[bufferSize];
        long totalBytesWrite = 0L;
        long bytesRemaining = maxBytes;
        try {
            while (bytesRemaining > 0L) {
                int bytesToRead = (int)(bytesRemaining < (long)buf.length ? bytesRemaining : (long)buf.length);
                int bytesRead = in.read(buf, 0, bytesToRead);
                if (bytesRead == -1) {
                    break;
                }
                out.write(buf, 0, bytesRead);
                bytesRemaining -= (long)bytesRead;
                totalBytesWrite += (long)bytesRead;
            }
        }
        finally {
            if (close) {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly((InputStream)in);
            }
        }
        return totalBytesWrite;
    }
}

