/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.GetsSplunkManifest;
import com.splunk.mr.packaging.SplunkManifestPackager;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class DeletesOldPackages {
    private static final Logger gLogger = Logger.getLogger(DeletesOldPackages.class);
    private final GetsSplunkManifest getsSplunkManifest;

    public DeletesOldPackages(GetsSplunkManifest getsSplunkManifest) {
        this.getsSplunkManifest = getsSplunkManifest;
    }

    public void delete() {
        List<File> manifestFiles = this.getsSplunkManifest.getSplunkManifestFiles();
        try {
            this.keepLatestModifiedManifestFile(manifestFiles);
        }
        catch (GetsSplunkManifest.ManifestFileNotExists e) {
            gLogger.debug((Object)("Exception when deleting old packages. Ignoring: " + e));
        }
    }

    private void keepLatestModifiedManifestFile(List<File> manifestFiles) {
        File lastModifiedManifestFile = this.getsSplunkManifest.getLastModifiedManifestFile();
        for (File manifestFile : manifestFiles) {
            if (this.isEqual(manifestFile, lastModifiedManifestFile)) continue;
            this.deletePackage(manifestFile);
        }
    }

    private void deletePackage(File manifestFile) {
        String packageName = SplunkManifestPackager.manifestFileNameToPackageName(manifestFile.getName());
        new File(manifestFile.getParentFile(), packageName).delete();
    }

    private boolean isEqual(File f1, File f2) {
        return f1.getAbsolutePath().equals(f2.getAbsolutePath());
    }
}

