/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonObject
extends JSONObject {
    private List<String> fieldsToMask;

    public JsonObject(JSONObject obj, String[] names, String[] fieldsToMask) {
        super(obj, names);
        this.fieldsToMask = Arrays.asList(fieldsToMask);
        if (!this.fieldsToMask.contains("password")) {
            this.fieldsToMask.add("password");
        }
    }

    public static JsonObject fromJSONObject(JSONObject obj, String[] fieldsToMask) {
        try {
            Iterator keysIter = obj.keys();
            ArrayList keys = new ArrayList();
            while (keysIter.hasNext()) {
                keys.add(keysIter.next());
            }
            return new JsonObject(obj, keys.toArray(new String[keys.size()]), fieldsToMask);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private JSONObject mask(JSONObject obj) {
        if (obj == null) {
            return null;
        }
        Iterator iterator = obj.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (obj.optJSONObject(key) != null) {
                this.mask(obj.getJSONObject(key));
                continue;
            }
            if (obj.optJSONArray(key) != null) {
                JSONArray jArray = obj.getJSONArray(key);
                for (int i = 0; i < jArray.length(); ++i) {
                    this.mask(jArray.getJSONObject(i));
                }
                continue;
            }
            if (!this.fieldsToMask.contains(key)) continue;
            obj.put(key, (Object)"********");
        }
        return obj;
    }

    public String toString() {
        try {
            JSONObject clone = new JSONObject(super.toString());
            JSONObject masked = this.mask(clone);
            return masked.toString();
        }
        catch (Exception ex) {
            return "";
        }
    }
}

