/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class SparklineAggregateValue
extends BaseAggregateValue {
    static final Logger logger = Logger.getLogger(SparklineAggregateValue.class);
    private Map<Long, String> sparklineMap = new TreeMap<Long, String>();

    @Override
    public AggregateValue accumulate(Object item) {
        assert (item instanceof HashMap);
        HashMap mapToBeCombined = (HashMap)item;
        this.combineWithCurrentMap(mapToBeCombined);
        return this;
    }

    private void combineWithCurrentMap(Map<Long, String> map1) {
        for (Map.Entry<Long, String> pair : map1.entrySet()) {
            String valueStr = this.sparklineMap.get(pair.getKey()) != null ? this.combineValueStrings(pair.getValue(), this.sparklineMap.get(pair.getKey())) : pair.getValue();
            this.sparklineMap.put(pair.getKey(), valueStr);
        }
    }

    private String combineValueStrings(String statsStr1, String statsStr2) {
        Map<String, String> map1 = this.convertValueStringToMap(statsStr1);
        Map<String, String> map2 = this.convertValueStringToMap(statsStr2);
        for (Map.Entry<String, String> pair : map1.entrySet()) {
            if (map2.get(pair.getKey()) != null) {
                Object updatedVal;
                BigDecimal val2;
                BigDecimal val1;
                if (pair.getKey().equals("max")) {
                    val1 = new BigDecimal(pair.getValue());
                    updatedVal = val1.compareTo(val2 = new BigDecimal(map2.get(pair.getKey()))) < 0 ? val2 : val1;
                } else if (pair.getKey().equals("min")) {
                    val1 = new BigDecimal(pair.getValue());
                    updatedVal = val1.compareTo(val2 = new BigDecimal(map2.get(pair.getKey()))) < 0 ? val1 : val2;
                } else if (pair.getKey().equals("v")) {
                    updatedVal = pair.getValue() + "," + map2.get(pair.getKey());
                } else {
                    val1 = new BigDecimal(pair.getValue());
                    val2 = new BigDecimal(map2.get(pair.getKey()));
                    updatedVal = val1.add(val2);
                }
                map2.put(pair.getKey(), updatedVal.toString());
                continue;
            }
            map2.put(pair.getKey(), pair.getValue());
        }
        return this.joinMap(map2);
    }

    public Map<String, String> convertValueStringToMap(String statsValuesStr) {
        String[] kvPair;
        HashMap<String, String> statsMap = new HashMap<String, String>();
        for (String keyVal : kvPair = statsValuesStr.split("&")) {
            String[] kvArray = keyVal.split("=");
            String val = kvArray[1];
            if (kvArray[0].equals("v") && statsMap.get("v") != null) {
                val = String.format("%s,%s", statsMap.get("v"), val);
            }
            statsMap.put(kvArray[0], val);
        }
        return statsMap;
    }

    public String joinMap(Map<String, String> map) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append("=");
            stringBuffer.append(entry.getValue());
            stringBuffer.append("&");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        assert (aggregateValue instanceof SparklineAggregateValue);
        Map mapToBeCombined = (Map)aggregateValue.getValue();
        this.combineWithCurrentMap(mapToBeCombined);
        return this;
    }

    @Override
    public Object getValue() {
        return this.sparklineMap;
    }
}

