/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import com.tdunning.math.stats.MergingDigest;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class QuantileValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    private final TDigest digestQuantile;

    public QuantileValue() {
        this.digestQuantile = TDigest.createMergingDigest((double)100.0);
    }

    private QuantileValue(TDigest digestQuantile) {
        this.digestQuantile = digestQuantile;
    }

    @Override
    public AggregateValue accumulate(Object qvalue) {
        this.digestQuantile.add((TDigest)qvalue);
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue value) {
        this.digestQuantile.add((TDigest)((QuantileValue)value).getValue());
        return this;
    }

    @Override
    public Object getValue() {
        return this.digestQuantile;
    }

    public Double getQuantile(Double quantile) {
        return this.digestQuantile.quantile(quantile.doubleValue());
    }

    public static void write(OutputStream os, QuantileValue val) throws IOException {
        int size = val.digestQuantile.smallByteSize();
        ByteBuffer digestBytes = ByteBuffer.allocate(size);
        val.digestQuantile.asSmallBytes(digestBytes);
        Utils.write(os, size);
        os.write(digestBytes.array());
    }

    public static QuantileValue read(InputStream is) throws IOException {
        int size = Utils.readInt(is);
        byte[] buff = new byte[size];
        is.read(buff);
        MergingDigest digest = MergingDigest.fromBytes((ByteBuffer)ByteBuffer.wrap(buff));
        return new QuantileValue((TDigest)digest);
    }
}

