/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.transformers.aggregatevalues;

import com.splunk.df.search.compute.transformers.aggregatevalues.AggregateValue;
import com.splunk.df.search.compute.transformers.aggregatevalues.BaseAggregateValue;
import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CountAggregateValue
extends BaseAggregateValue {
    private static final long serialVersionUID = 1L;
    private Long count = 0L;

    public CountAggregateValue(long count) {
        this.count = count;
    }

    public CountAggregateValue() {
        this.count = 0L;
    }

    @Override
    public Object getValue() {
        return this.count;
    }

    @Override
    public AggregateValue accumulate(Object value) {
        this.count = this.count + (Long)value;
        return this;
    }

    @Override
    public AggregateValue accumulate(AggregateValue aggregateValue) {
        this.count = this.count + (Long)aggregateValue.getValue();
        return this;
    }

    public static void write(OutputStream os, CountAggregateValue val) throws IOException {
        long count = (Long)val.getValue();
        Utils.write(os, count);
    }

    public static CountAggregateValue read(InputStream is) throws IOException {
        long count = Utils.readLong(is);
        return new CountAggregateValue(count);
    }
}

