/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search.compute.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.splunk.df.search.compute.SearchResult;
import com.splunk.df.search.compute.SearchResultFactory;
import com.splunk.df.search.compute.SearchResultImpl;
import com.splunk.df.search.compute.spark.KryoRegisteredClassHolder;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.spark.serializer.KryoRegistrator;

public class DFSKryoRegistrator
implements KryoRegistrator {
    static final Logger logger = Logger.getLogger(DFSKryoRegistrator.class);
    static String extraKryoClasses = "";

    public void registerClasses(Kryo kryo) {
        kryo.setReferences(false);
        kryo.setCopyReferences(false);
        kryo.setRegistrationRequired(true);
        Serializer s = new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                try {
                    SearchResultFactory.write((OutputStream)output, (SearchResult)object);
                }
                catch (Throwable t) {
                    logger.error((Object)String.format("error writing search result: %s to kryo output, reason: %s", object.toString(), t.getMessage()), t);
                    throw new RuntimeException(String.format("error writing object: %s to kryo output", object.toString()), t);
                }
            }

            public Object read(Kryo kryo, Input input, Class type) {
                if (!type.equals(SearchResultImpl.class)) {
                    throw new RuntimeException(String.format("cannot read class: %s", type.getName()));
                }
                return SearchResultFactory.readSr((InputStream)input);
            }
        };
        for (Class c : KryoRegisteredClassHolder.getClasses(extraKryoClasses)) {
            if (c.equals(SearchResultImpl.class)) {
                kryo.register(c, s);
                continue;
            }
            kryo.register(c);
        }
    }
}

