/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.commons.search.HostPort;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFSChunkToDispatch;
import com.splunk.df.search.compute.ComputeEngineContext;
import com.splunk.df.search.compute.SearchResult;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.log4j.Logger;

public class SearchResultDistributor {
    static final Logger logger = Logger.getLogger(SearchResultDistributor.class);
    private int DEFAULT_MAX_SEARCH_RESULTS = 100000;
    private Iterator<SearchResult> srIterator;
    private ArrayList<HostPort> dfsWorkerList;
    private ComputeEngineContext ctx;
    private String sid;
    private Thread SRReceiver;
    private Thread SRDistributor;
    final LinkedBlockingDeque<DFSChunkToDispatch> dfsChunkDispatchQueue = new LinkedBlockingDeque(1000);

    public SearchResultDistributor(String sid, Iterator<SearchResult> srItr, ArrayList<HostPort> hpList, ComputeEngineContext ctx) {
        this.srIterator = srItr;
        this.ctx = ctx;
        this.sid = sid;
        this.dfsWorkerList = hpList;
        this.SRReceiver = new Thread(new DFCRunnable(){

            @Override
            protected void runInternal() throws Exception {
                Object[] srKeys = null;
                boolean firstSR = true;
                ArrayList<SearchResult> toSendSRChunk = new ArrayList<SearchResult>(SearchResultDistributor.this.DEFAULT_MAX_SEARCH_RESULTS);
                while (SearchResultDistributor.this.srIterator.hasNext()) {
                    SearchResult sr = (SearchResult)SearchResultDistributor.this.srIterator.next();
                    if (firstSR) {
                        srKeys = SearchResultDistributor.getHeaderFields(sr);
                        if (srKeys == null) continue;
                        logger.debug((Object)("SR Header " + Arrays.toString(srKeys)));
                        firstSR = false;
                    }
                    toSendSRChunk.add(sr);
                    if (toSendSRChunk.size() < SearchResultDistributor.this.DEFAULT_MAX_SEARCH_RESULTS) continue;
                    SearchResultDistributor.this.sendToDispatchQueue(toSendSRChunk, (SearchResult.FieldMeta[])srKeys, false);
                    toSendSRChunk.clear();
                }
                SearchResultDistributor.this.sendToDispatchQueue(toSendSRChunk, srKeys, true);
            }
        });
        this.SRDistributor = new Thread(new DFCRunnable(){

            @Override
            protected void runInternal() throws Exception {
                int i;
                ArrayList<OutputStream> writeToDFSWorker = new ArrayList<OutputStream>();
                for (i = 0; i < SearchResultDistributor.this.dfsWorkerList.size(); ++i) {
                    String host = ((HostPort)SearchResultDistributor.this.dfsWorkerList.get(i)).getHost();
                    int port = ((HostPort)SearchResultDistributor.this.dfsWorkerList.get(i)).getPort();
                    Socket s = new Socket(host, port);
                    writeToDFSWorker.add(s.getOutputStream());
                }
                block1: while (true) {
                    i = 0;
                    while (true) {
                        if (i >= writeToDFSWorker.size()) continue block1;
                        DFSChunkToDispatch dfsChunkToDispatch = SearchResultDistributor.this.dfsChunkDispatchQueue.poll();
                        String payload = new String();
                        payload = String.format("%s\n%s", dfsChunkToDispatch.getHeader(), dfsChunkToDispatch.getSrSet());
                        ((OutputStream)writeToDFSWorker.get(i)).write(payload.getBytes());
                        if (dfsChunkToDispatch.isLastChunk()) {
                            SearchResultDistributor.this.sendQFToRemaningDFSWorkers(writeToDFSWorker, i, payload);
                            return;
                        }
                        ++i;
                    }
                    break;
                }
            }
        });
        this.SRReceiver.start();
        this.SRDistributor.start();
    }

    private void sendQFToRemaningDFSWorkers(ArrayList<OutputStream> workerList, int doNotSend, String payload) throws IOException {
        for (int i = 0; i < workerList.size(); ++i) {
            if (i == doNotSend) continue;
            workerList.get(i).write(payload.getBytes());
        }
    }

    private static SearchResult.FieldMeta[] getHeaderFields(SearchResult sr) {
        SearchResult.SRHashMap<SearchResult.FieldMeta, Object> srdata = sr.getDataMap();
        if (srdata.isEmpty()) {
            return null;
        }
        Object[] srKeysObj = srdata.keySet().toArray();
        SearchResult.FieldMeta[] srKeys = new SearchResult.FieldMeta[srKeysObj.length];
        System.arraycopy(srKeysObj, 0, srKeys, 0, srKeys.length);
        return srKeys;
    }

    private static String[] convert(SearchResult.FieldMeta[] fields) {
        String[] strFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            strFields[i] = fields[i].fieldName();
        }
        return strFields;
    }

    private void sendToDispatchQueue(ArrayList<SearchResult> toSendSRChunk, SearchResult.FieldMeta[] srkeys, boolean queryFinish) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter chunkWriter = new BufferedWriter(new OutputStreamWriter(baos));
        CSVPrinter csvPrinter = CSVFormat.DEFAULT.withHeader(SearchResultDistributor.convert(srkeys)).print((Appendable)chunkWriter);
        for (int i = 0; i < toSendSRChunk.size(); ++i) {
            csvPrinter.printRecord(toSendSRChunk.get(i).getDataMap().values());
        }
        csvPrinter.flush();
        String srsPayload = new String(baos.toByteArray());
        DFSChunkToDispatch chunkToDispatch = new DFSChunkToDispatch(this.sid, srsPayload, queryFinish);
        while (!this.dfsChunkDispatchQueue.offer(chunkToDispatch, 1L, TimeUnit.SECONDS)) {
        }
    }
}

