/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public enum FSHSplunkExecutionType implements Serializable
{
    UNDEFINED(0),
    SH(1),
    SH_SHUFFLE(2),
    SH_SHUFFLE_FROM_QUAKE(3),
    FABRIC(4);

    public final int finalId;
    private static Map<Integer, FSHSplunkExecutionType> lookupCache;
    private static boolean isCacheFilled;

    private FSHSplunkExecutionType(int id) {
        this.finalId = id;
    }

    private static void lazyFillCache() {
        HashMap<Integer, FSHSplunkExecutionType> localC = new HashMap<Integer, FSHSplunkExecutionType>();
        for (FSHSplunkExecutionType searchStatus : FSHSplunkExecutionType.values()) {
            localC.put(searchStatus.finalId, searchStatus);
        }
        lookupCache = localC;
        isCacheFilled = true;
    }

    public static FSHSplunkExecutionType getFSHExecutionState(int lookupVal) {
        if (!isCacheFilled) {
            FSHSplunkExecutionType.lazyFillCache();
        }
        return lookupCache.get(lookupVal);
    }

    public static FSHSplunkExecutionType read(InputStream is) throws IOException {
        int executionType = Utils.readInt(is);
        if (executionType == UNDEFINED.ordinal()) {
            return UNDEFINED;
        }
        if (executionType == SH.ordinal()) {
            return SH;
        }
        if (executionType == SH_SHUFFLE.ordinal()) {
            return SH_SHUFFLE;
        }
        if (executionType == SH_SHUFFLE_FROM_QUAKE.ordinal()) {
            return SH_SHUFFLE_FROM_QUAKE;
        }
        if (executionType == FABRIC.ordinal()) {
            return FABRIC;
        }
        throw new RuntimeException(String.format("executionType=%d not supported", executionType));
    }

    public static void write(OutputStream os, FSHSplunkExecutionType executionType) throws IOException {
        Utils.write(os, executionType.ordinal());
    }

    static {
        lookupCache = null;
        isCacheFilled = false;
    }
}

