/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.df.search;

import com.splunk.df.search.DFCLauncherEmbedded;
import com.splunk.df.search.DFCParams;
import com.splunk.df.search.DFCRunnable;
import com.splunk.df.search.DFExecutionType;
import com.splunk.df.search.DFSProtocolConstants;
import com.splunk.df.search.DFSResourceManager;
import com.splunk.df.search.DFSSearchConstants;
import com.splunk.df.search.DFSSearchCoordinatorState;
import com.splunk.df.search.compute.ComputeEngineClusterInfo;
import com.splunk.df.search.compute.ComputeEngineClusterManagerFactory;
import com.splunk.df.util.DFSException;
import com.splunk.df.util.DFSLicenseException;
import com.splunk.df.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DFSearchDispatcher
extends DFCRunnable
implements DFSSearchConstants {
    static final Logger logger = Logger.getLogger(DFSearchDispatcher.class);
    public static final int MAX_ALLOWED_PORT = 65535;
    private BufferedWriter writeToSplunk = null;
    private String dfcId;
    private String dfsSid;
    private String sparkHome;
    private int dfsMasterPort;
    private DFExecutionType executionType;
    private DFSResourceManager dfsResourceManager;
    private int coordinatorControlPort;
    private int coordinatorNumSlots;
    private int executorNumSlots;
    private boolean executorNumSlotsEnabled;
    private long maxReducePartitionSize;
    private int workerReceivingDataPort;
    private int workerReceivingDataPortCount;
    private static String sparkMasterWebUrl;
    private static int sparkMasterConnectTimeout;
    private boolean sparkWorkerCheckingEnabled;
    private String splunkVersion;
    private String extraKryoClasses;
    private String splunkConf;
    private String searchHeadName;
    private long maxSearchResultSize;
    private boolean pbsEnabled;
    private boolean isDfsInstrumentationEnabled;
    private int dfsInstrumentationMode;
    private String dfsInstrumentationHecEndpoint;
    private String dfsInstrumentationHecToken;
    private ArrayList<String> splunkAllSearchPeers;
    private boolean isSearchFederated;
    private static int headN;
    private long dfsRemoteSearchTimeoutSec;
    private boolean licenseCheckEnabled;
    private int dfsLicensedVcpu;
    private boolean exceededLicensedCores = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DFSearchDispatcher(StringBuilder input, int dfsPort, BufferedReader br, BufferedWriter bw, DFSResourceManager dfsResourceManager) {
        logger.info((Object)String.format("input string to DFM: \n%s\n", input.toString()));
        JSONObject obj = new JSONObject(input.toString());
        this.writeToSplunk = bw;
        this.dfsSid = obj.getString("sid");
        try {
            this.sparkHome = DFSearchDispatcher.getSparkHome(obj);
            this.coordinatorControlPort = DFSearchDispatcher.getCoordinatorControlPort(obj);
            this.coordinatorNumSlots = DFSearchDispatcher.getCoordinatorNumSlots(obj);
            this.executorNumSlotsEnabled = DFSearchDispatcher.isExecutorNumSlotsEnabled(obj);
            this.executorNumSlots = this.executorNumSlotsEnabled ? DFSearchDispatcher.getExecutorNumSlots(obj) : this.coordinatorNumSlots;
            this.maxReducePartitionSize = DFSearchDispatcher.getMaxReducePartitionSize(obj);
            this.workerReceivingDataPort = DFSearchDispatcher.getWorkerReceivingDataPort(obj);
            this.maxSearchResultSize = DFSearchDispatcher.getMaxSearchResultSize(obj);
            this.workerReceivingDataPortCount = DFSearchDispatcher.getWorkerReceivingDataPortCount(obj);
            this.dfcId = this.dfsSid;
            logger.debug((Object)String.format("will use sid as dfc id: %s, hence each search would run in a separate dfc instance", this.dfcId));
            this.dfsMasterPort = dfsPort;
            this.executionType = DFExecutionType.BATCH;
            this.dfsResourceManager = dfsResourceManager;
            this.splunkVersion = obj.getString("splunkVersion");
            this.licenseCheckEnabled = DFSearchDispatcher.isDFSLicenseCheckEnabled();
            this.dfsLicensedVcpu = DFSearchDispatcher.getDFSLicensedVcpu(obj);
            this.extraKryoClasses = obj.has("extraKryoRegisteredClasses") ? obj.getString("extraKryoRegisteredClasses") : null;
            this.splunkConf = obj.getJSONObject("splunkConf").toString();
            this.searchHeadName = obj.getString("SplunkServerName");
            sparkMasterWebUrl = DFSearchDispatcher.getSparkMasterWebURL(obj);
            sparkMasterConnectTimeout = DFSearchDispatcher.getSparkMasterTimeout(obj);
            this.sparkWorkerCheckingEnabled = DFSearchDispatcher.getSparkWorkerCheckingEnabled(obj);
            this.pbsEnabled = DFSearchDispatcher.getPBSEnabled(obj);
            this.splunkAllSearchPeers = DFSearchDispatcher.getPBSAllSearchPeers(obj);
            this.isSearchFederated = DFSearchDispatcher.getFSHEnabled(obj);
            this.isDfsInstrumentationEnabled = DFSearchDispatcher.isDFSInstrumentationEnabled(obj);
            if (this.isDfsInstrumentationEnabled) {
                this.dfsInstrumentationMode = DFSearchDispatcher.getDFSInstrumentationMode(obj);
                this.dfsInstrumentationHecEndpoint = DFSearchDispatcher.getDFSInstrumentationHecEndpoint(obj);
                this.dfsInstrumentationHecToken = DFSearchDispatcher.getDFSInstrumentationHecToken(obj);
            }
            this.dfsRemoteSearchTimeoutSec = DFSearchDispatcher.getDFSRemoteSearchTimeoutSec(obj);
            if (!Utils.isDfsElasticModeEnabled()) return;
        }
        catch (Exception t) {
            logger.error((Object)ExceptionUtils.getFullStackTrace((Throwable)t));
            DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, "Error while trying to process request to start Data Fabric Coordinator from splunk search process. Refer to Data Fabric Master logs(SPLUNK_HOME/var/log/splunk/dfs.log) for details.");
            throw new RuntimeException("Unable to process request");
        }
    }

    protected static int getCoordinatorControlPort(JSONObject obj) {
        int port = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfc_control_port");
        logger.debug((Object)String.format("DFC control port (dfc_control_port): %d", port));
        return port;
    }

    protected static int getCoordinatorNumSlots(JSONObject obj) {
        int numSlots = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfc_num_slots");
        logger.debug((Object)String.format("# of DFCs per Search Head (dfc_num_slots): %d", numSlots));
        return numSlots;
    }

    protected static int getExecutorNumSlots(JSONObject obj) {
        int numSlots = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_num_slots");
        logger.debug((Object)String.format("(dfw_num_slots) (or) # of DFCs across Search Head Cluster : %d", numSlots));
        return numSlots;
    }

    protected static boolean isExecutorNumSlotsEnabled(JSONObject obj) {
        boolean isExecutorNumSlotsEnabled = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getBoolean("dfw_num_slots_enabled");
        logger.debug((Object)String.format("executor num slots enabled:" + isExecutorNumSlotsEnabled, new Object[0]));
        return isExecutorNumSlotsEnabled;
    }

    protected static long getMaxReducePartitionSize(JSONObject obj) {
        long maxReducePartitionSize = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getLong("dfs_max_reduce_partition_size");
        logger.debug((Object)String.format("Maximum reduce partition size (dfs_max_reduce_partition_size): %d", maxReducePartitionSize));
        return maxReducePartitionSize;
    }

    protected static long getMaxSearchResultSize(JSONObject obj) {
        long maxSearchResultSize = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getLong("dfs_max_search_result_size");
        if (maxSearchResultSize == 0L) {
            maxSearchResultSize = Long.MAX_VALUE;
        }
        logger.debug((Object)String.format("Maximum search result size (dfs_max_search_result_size): %d", maxSearchResultSize));
        return maxSearchResultSize;
    }

    protected static int getWorkerReceivingDataPort(JSONObject obj) {
        int port = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_receiving_data_port");
        logger.debug((Object)String.format("DFW receiving data port (dfw_receiving_data_port): %d", port));
        return port;
    }

    protected static int getWorkerReceivingDataPortCount(JSONObject obj) {
        int count = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfw_receiving_data_port_count");
        logger.debug((Object)String.format("DFW receiving data port count (dfw_receiving_data_port_count): %d", count));
        return count;
    }

    protected static long getDFSRemoteSearchTimeoutSec(JSONObject obj) {
        long dfsRemoteSearchTimeoutSec = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getLong("dfs_remote_search_timeout");
        logger.debug((Object)String.format("dfs_remote_search_timeout: %d", dfsRemoteSearchTimeoutSec));
        return dfsRemoteSearchTimeoutSec;
    }

    protected static boolean getPBSEnabled(JSONObject obj) {
        return obj.getJSONObject("splunk_dfs_manager").getBoolean("pbsEnabled");
    }

    protected static ArrayList<String> getPBSAllSearchPeers(JSONObject obj) {
        JSONArray peers = obj.getJSONObject("splunk_dfs_manager").getJSONArray("splunkAllSearchPeers");
        ArrayList<String> splunkAllSearchPeers = new ArrayList<String>();
        for (int i = 0; i < peers.length(); ++i) {
            splunkAllSearchPeers.add(peers.getString(i));
        }
        return splunkAllSearchPeers;
    }

    protected static JSONObject getDFSExecutionFromThePayload(JSONObject obj) {
        return obj.getJSONObject("splunkConf").getJSONObject("limits").getJSONObject("dfs");
    }

    protected static String getSparkHome(JSONObject obj) {
        String host = obj.getJSONObject("splunkConf").getJSONObject("server").getString("spark_home");
        logger.debug((Object)String.format("Spark Home (spark_home): %s", host));
        return host;
    }

    protected static boolean getSparkWorkerCheckingEnabled(JSONObject obj) {
        return obj.getJSONObject("splunk_dfs_manager").getBoolean("spark_worker_checking_enabled");
    }

    protected static boolean getFSHEnabled(JSONObject obj) {
        return obj.getJSONObject("splunkConf").getJSONObject("limits").getJSONObject("dfs").getBoolean("isFshExecution");
    }

    protected static String getSparkMasterHost(JSONObject obj) {
        String host = obj.getJSONObject("splunkConf").getJSONObject("server").getString("spark_master_host");
        logger.debug((Object)String.format("Spark Master Host (spark_master_host): %s", host));
        return host;
    }

    protected static int getSparkMasterTimeout(JSONObject obj) {
        int sparkMasterTimeout = obj.getJSONObject("splunkConf").getJSONObject("server").getInt("spark_master_connect_timeout");
        logger.debug((Object)String.format("Spark Master Timeout (spark_master_host): %s", sparkMasterTimeout));
        return sparkMasterTimeout;
    }

    protected static int getSparkMasterWebUIPort(JSONObject obj) {
        int port = obj.getJSONObject("splunkConf").getJSONObject("server").getInt("spark_master_webui_port");
        logger.debug((Object)String.format("Spark Master WebUI Port (spark_master_webui_port): %d", port));
        return port;
    }

    protected static String getSparkMasterWebURL(JSONObject obj) {
        String url;
        String protocol = "http";
        String auth = null;
        String host = DFSearchDispatcher.getSparkMasterHost(obj);
        int port = DFSearchDispatcher.getSparkMasterWebUIPort(obj);
        String path = null;
        String query = null;
        String fragment = null;
        try {
            URI uri = new URI("http", auth, host, port, path, query, fragment);
            url = uri.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        logger.info((Object)String.format("Spark Master Web URL: %s", url));
        return url;
    }

    protected static boolean isDFSInstrumentationEnabled(JSONObject obj) {
        boolean isDfsInstrumentionEnabled = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).optBoolean("dfs_instrumentation_enabled", false);
        logger.debug((Object)String.format("DFS instrumentation enabled " + isDfsInstrumentionEnabled, new Object[0]));
        return isDfsInstrumentionEnabled;
    }

    protected static int getDFSInstrumentationMode(JSONObject obj) {
        int dfsInstrumentationMode = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getInt("dfs_instrumentation_mode");
        logger.debug((Object)String.format("DFS Instrumentation mode : %d", dfsInstrumentationMode));
        return dfsInstrumentationMode;
    }

    protected static String getDFSInstrumentationHecEndpoint(JSONObject obj) {
        String dfsInstrumentationHecEndpoint = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getString("dfs_instrumentation_hec_endpoint");
        logger.debug((Object)String.format("DFS instrumentation endpoint: %s", dfsInstrumentationHecEndpoint));
        return dfsInstrumentationHecEndpoint;
    }

    protected static String getDFSInstrumentationHecToken(JSONObject obj) {
        String dfsInstrumentationHecToken = DFSearchDispatcher.getDFSExecutionFromThePayload(obj).getString("dfs_instrumentation_hec_token");
        logger.debug((Object)String.format("DFS instrumentation HEC token: %s", dfsInstrumentationHecToken));
        return dfsInstrumentationHecToken;
    }

    private void sendDfcMessageToSplunkd(BufferedWriter writeToSplunk, DFSResourceManager.DFSResourceInfo dri, String sid) {
        try {
            String payload = "";
            if (this.exceededLicensedCores) {
                String warnMsg = "Your DFS search exceeds the allocated vCPU limit at this point in time.Please contact your account representative for options regarding additional vCPUs for DFS.";
                payload = String.format("%s,127.0.0.1:%d,%s\n", DFSProtocolConstants.PROTO_DFS_WARN.toString(), dri.getDfcPort(), warnMsg);
            } else {
                payload = String.format("%s,127.0.0.1:%d\n", DFSProtocolConstants.PROTO_DFS_ACK.toString(), dri.getDfcPort());
            }
            writeToSplunk.write(payload);
            writeToSplunk.flush();
            logger.info((Object)String.format("Informed splunk about the state of the coordinator: %s, for sid: %s", payload, sid));
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static void sendDfcFailureToSplunkd(BufferedWriter writeToSplunk, String sid, String errMsg) {
        try {
            logger.error((Object)String.format("Informing splunk that Data Fabric Coordinator could not be started for sid=%s .%s", sid, errMsg));
            String payload = String.format("%s,%s\n", DFSProtocolConstants.PROTO_DFS_FAILED.toString(), errMsg);
            writeToSplunk.write(payload);
            writeToSplunk.flush();
        }
        catch (IOException io) {
            throw new RuntimeException(io);
        }
    }

    private static int totalMemoryMbs() {
        try {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            if (Class.forName("com.sun.management.OperatingSystemMXBean").isInstance(os)) {
                Method memorySize = os.getClass().getDeclaredMethod("getTotalPhysicalMemorySize", new Class[0]);
                memorySize.setAccessible(true);
                return (int)((Long)memorySize.invoke((Object)os, new Object[0]) / 0x100000L);
            }
            throw new RuntimeException(String.format("could not get the total physical memory of the search head member", new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error getting the total ram size of the search head member: %s", e.getMessage()));
        }
    }

    private static double getMaxDfcExecutorMemoryMbs() {
        double maxMemMbs = 24576.0;
        String maxMemMbsStr = System.getenv("DFC_MAX_EXECUTOR_MEMORY_MBS");
        if (maxMemMbsStr != null && !maxMemMbsStr.trim().isEmpty()) {
            maxMemMbs = Double.valueOf(maxMemMbsStr);
        }
        return maxMemMbs;
    }

    private static boolean isDFSLicenseCheckEnabled() {
        boolean enabled = true;
        String licensingEnabled = System.getenv("DFS_LICENSING_ENABLED");
        if (licensingEnabled != null && !licensingEnabled.trim().isEmpty()) {
            enabled = Boolean.parseBoolean(licensingEnabled);
        }
        return enabled;
    }

    private static int getDFSLicensedVcpu(JSONObject obj) {
        return obj.getJSONObject("splunkConf").getJSONObject("license").getInt("vcpu");
    }

    private static double getMaxDfcDriverMemoryMbs() {
        double maxMemMbs = 102400.0;
        String maxMemMbsStr = System.getenv("DFC_MAX_DRIVER_MEMORY_MBS");
        if (maxMemMbsStr != null && !maxMemMbsStr.trim().isEmpty()) {
            maxMemMbs = Double.valueOf(maxMemMbsStr);
            logger.debug((Object)String.format("dfc max driver memory has been set through envvar: %d", (int)maxMemMbs));
        }
        return maxMemMbs;
    }

    private static double getWorkerMemRatio() {
        double ratio = 0.8;
        String ratioStr = System.getenv("DFC_WORKER_MEM_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("cluster memory breather ratio per dfs worker node: %.2f overridden by envvar", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse cluster memory breather ratio: %s into double", ratioStr));
            }
        }
        logger.info((Object)String.format("cluster memory breather ratio per dfs worker node: %.2f", ratio));
        return ratio;
    }

    private static double getShDfcMemRatio() {
        double ratio = 0.75;
        String ratioStr = System.getenv("DFC_SH_MEM_RATIO");
        if (ratioStr != null) {
            try {
                ratio = Double.valueOf(ratioStr);
                logger.info((Object)String.format("ratio of search head memory to be used for all DFC instances overriden by envvar: %s, value: %.2f", "DFC_SH_MEM_RATIO", ratio));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse search head mmeory ratio for DFC set through (%s): %s to double", "DFC_SH_MEM_RATIO", ratioStr));
            }
        }
        logger.info((Object)String.format("ratio of total DFC memory to the search head memory: %.2f", ratio));
        return ratio;
    }

    private static boolean isLowLatencyEnabled() {
        boolean enabled = false;
        String enabledStr = System.getenv("DFS_LOW_LATENCY_ENABLED");
        if (enabledStr != null && !enabledStr.trim().isEmpty()) {
            try {
                enabled = Boolean.valueOf(enabledStr);
                logger.info((Object)String.format("low latency enabled set to %b by envvar", enabled));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse low latency enabled boolean from: %s", enabledStr));
            }
        }
        logger.info((Object)String.format("low latency enabled set to %b", enabled));
        return enabled;
    }

    private static int getUsableShMemoryMbs() {
        int totalMemoryInSHMbs = DFSearchDispatcher.totalMemoryMbs();
        logger.info((Object)String.format("Total available memory in the search head: %d mb", totalMemoryInSHMbs));
        int usableMemoryMbs = (int)((double)totalMemoryInSHMbs * DFSearchDispatcher.getShDfcMemRatio());
        logger.info((Object)String.format("Total usable memory in the search head: %d mb", usableMemoryMbs));
        return usableMemoryMbs;
    }

    private static boolean getAlwaysExecuteLowLatency() {
        boolean always = false;
        String alwaysStr = System.getenv("DFS_ALWAYS_EXECUTE_LOW_LATENCY");
        if (alwaysStr != null && !alwaysStr.trim().isEmpty()) {
            try {
                always = Boolean.valueOf(alwaysStr);
                logger.info((Object)String.format("always execute in low latency mode set through envvar: %b", always));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse always low latency envvar to boolean: %s", alwaysStr));
            }
        }
        logger.info((Object)String.format("always execute in low latency mode: %b", always));
        return always;
    }

    private static int getDfwToDfcAuthRetryTimes() {
        int dfwToDfcAuthRetryTimes = 3;
        String dfwToDfcAuthRetryTimesStr = System.getenv("DFW_TO_DFC_AUTH_RETRY_TIMES");
        if (dfwToDfcAuthRetryTimesStr != null) {
            try {
                dfwToDfcAuthRetryTimes = Integer.valueOf(dfwToDfcAuthRetryTimesStr);
                logger.info((Object)String.format("DFW to DFC authentication retry times to be used for all DFW instances overriden by envvar: %s, value: %d", "DFW_TO_DFC_AUTH_RETRY_TIMES", dfwToDfcAuthRetryTimes));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse DFW to DFC authentication retry times set through (%s): %s to int", "DFW_TO_DFC_AUTH_RETRY_TIMES", dfwToDfcAuthRetryTimesStr));
            }
        }
        return dfwToDfcAuthRetryTimes;
    }

    private static int getSSLConfigServerSocketBacklogSize() {
        int sslConfigServerSocketBacklogSize = 0;
        String sslConfigServerSocketBacklogSizeStr = System.getenv("SSLCONFIG_SERVER_SOCKET_BACKLOG_SIZE");
        if (sslConfigServerSocketBacklogSizeStr != null) {
            try {
                sslConfigServerSocketBacklogSize = Integer.valueOf(sslConfigServerSocketBacklogSizeStr);
                logger.info((Object)String.format("SSLConfig server socket backlog size to be used for all DFC instances overriden by envvar: %s, value: %d", "SSLCONFIG_SERVER_SOCKET_BACKLOG_SIZE", sslConfigServerSocketBacklogSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse SSLConfig server socket backlog size set through (%s): %s to int", "SSLCONFIG_SERVER_SOCKET_BACKLOG_SIZE", sslConfigServerSocketBacklogSizeStr));
            }
        }
        return sslConfigServerSocketBacklogSize;
    }

    private static int getRdinServerSocketBacklogSize() {
        int rdinServerSocketBacklogSize = 0;
        String rdinServerSocketBacklogSizeStr = System.getenv("RDIN_SERVER_SOCKET_BACKLOG_SIZE");
        if (rdinServerSocketBacklogSizeStr != null) {
            try {
                rdinServerSocketBacklogSize = Integer.valueOf(rdinServerSocketBacklogSizeStr);
                logger.info((Object)String.format("Rdin server socket backlog size to be used for all DFW instances overriden by envvar: %s, value: %d", "RDIN_SERVER_SOCKET_BACKLOG_SIZE", rdinServerSocketBacklogSize));
            }
            catch (Throwable t) {
                logger.warn((Object)String.format("could not parse Rdin server socket backlog size set through (%s): %s to int", "RDIN_SERVER_SOCKET_BACKLOG_SIZE", rdinServerSocketBacklogSizeStr));
            }
        }
        return rdinServerSocketBacklogSize;
    }

    private void startDfc(String sparkHome, final String dfcId, int dfsMasterPort, String dfsSid, DFSResourceManager.DFSResourceInfo dri, final DFSResourceManager resourceMgr, final DFExecutionType executionType, long maxSearchResultSize, int maxNumberOfDFCperSH, int coordinatorControlPort, long maxReducePartitionSize, int workerReceivingDataPort, int workerReceivingDataPortCount, String splunkVersion, String extraKryoClasses, String splunkConf, String searchHeadName, boolean isDfsInstrumentationEnabled, int dfsInstrumentationMode, String dfsInstrumentationHecEndpoint, String dfsInstrumentationHecToken, boolean pbsEnabled, ArrayList<String> splunkAllSearchPeers, boolean isSearchFederated, boolean sparkWorkerCheckingEnabled, long dfsRemoteSearchTimeoutSec, boolean licenseCheckEnabled, int licensedVcpu) throws DFSLicenseException {
        boolean alwaysExecuteLowLatency;
        logger.info((Object)String.format("Starting new dfc instance with id: %s", dfcId));
        if (logger.isDebugEnabled()) {
            logger.info((Object)String.format("Splunk_conf: %s", splunkConf));
        }
        ComputeEngineClusterInfo clusterInfo = ComputeEngineClusterManagerFactory.getInstance().getClusterManager(sparkMasterWebUrl, sparkMasterConnectTimeout).getClusterInfo();
        if (sparkWorkerCheckingEnabled && pbsEnabled) {
            ArrayList<String> workerHosts = clusterInfo.workerHosts();
            HashSet<String> resolvedSplunkSearchPeers = new HashSet<String>();
            for (String host : splunkAllSearchPeers) {
                resolvedSplunkSearchPeers.add(host);
                try {
                    String resolvedHost = InetAddress.getByName(host).getHostAddress();
                    if (resolvedHost.equals(host)) continue;
                    resolvedSplunkSearchPeers.add(resolvedHost);
                }
                catch (UnknownHostException e) {
                    logger.debug((Object)("Could not resolve splunk peer host: " + host));
                }
            }
            if (!resolvedSplunkSearchPeers.containsAll(workerHosts)) {
                throw new DFSException(String.format("splunk_dfs_manager: Spark workers that are not resolvable and registered as indexers are not allowed when Splunk is managing Spark.", new Object[0]));
            }
        }
        int usableShMemoryMbs = DFSearchDispatcher.getUsableShMemoryMbs();
        double minWorkerCores = clusterInfo.minWorkerCores();
        int coresPerWorker = Utils.getCoresPerWorker((int)minWorkerCores);
        logger.info((Object)String.format("Cores assigned to each dfc worker: %d", coresPerWorker));
        int numWorkersPerHost = (int)minWorkerCores / coresPerWorker;
        numWorkersPerHost = Math.max(1, numWorkersPerHost);
        logger.info((Object)String.format("number of worker instances per worker host: %d", numWorkersPerHost));
        int numDfcs = maxNumberOfDFCperSH;
        logger.info((Object)String.format("number of DFCs for the search head: %d based on dfc_num_slots", numDfcs));
        int dfcDriverMemMbs = Math.max(1024, usableShMemoryMbs / numDfcs);
        dfcDriverMemMbs = Math.min(dfcDriverMemMbs, (int)DFSearchDispatcher.getMaxDfcDriverMemoryMbs());
        logger.info((Object)String.format("Memory assigned to the dfc driver is: %d mb", dfcDriverMemMbs));
        int totalCoresInSH = Runtime.getRuntime().availableProcessors();
        int dfcDriverCores = Math.max(1, totalCoresInSH);
        dfcDriverCores = Math.min(16, dfcDriverCores);
        logger.info((Object)String.format("Cores assigned to the dfc driver is: %d", dfcDriverCores));
        int coresAvailable = clusterInfo.totalCores() - clusterInfo.coresUsed();
        int usableWorkerMemMbs = (int)((double)clusterInfo.minWorkerMemMbs() * DFSearchDispatcher.getWorkerMemRatio());
        logger.info((Object)String.format("Total usable memory on a dfc worker: %d mb", usableWorkerMemMbs));
        int workerMemMbs = Math.max(1024, usableWorkerMemMbs / numWorkersPerHost);
        workerMemMbs = Math.min((int)DFSearchDispatcher.getMaxDfcExecutorMemoryMbs(), workerMemMbs);
        logger.info((Object)String.format("Memory assigned to a dfc worker: %d mb", workerMemMbs));
        int memoryAvailableMbs = clusterInfo.totalMemoryMbs() - clusterInfo.usedMemoryMbs();
        long estimatedEventCount = Utils.getEstimatedEventCount(splunkConf).second();
        int coresToUse = Utils.fractionOfRemainingCores(coresAvailable);
        int startupWorkers = 0;
        boolean[] lowLatencyMode = new boolean[1];
        if (isSearchFederated) {
            startupWorkers = Math.max(1, coresToUse / maxNumberOfDFCperSH);
            logger.info((Object)String.format("Search being executed involves federated dataset and we leverage coresavailble=%d and maxNumberOfDFCperSH=%d to calculate the number of startup workers= %d", coresAvailable, maxNumberOfDFCperSH, startupWorkers));
        } else {
            startupWorkers = Utils.getStartupWorkers(estimatedEventCount, workerMemMbs, dfcDriverMemMbs, coresToUse, coresPerWorker, maxReducePartitionSize, totalCoresInSH, lowLatencyMode);
        }
        logger.info((Object)String.format("Number of dfc workers to be used: %d, total available cluster worker hosts: %d", startupWorkers, clusterInfo.numWorkers()));
        boolean lowLatencyEnabled = DFSearchDispatcher.isLowLatencyEnabled();
        if (!lowLatencyEnabled) {
            lowLatencyMode[0] = false;
        }
        if (alwaysExecuteLowLatency = DFSearchDispatcher.getAlwaysExecuteLowLatency()) {
            lowLatencyMode[0] = true;
            logger.info((Object)String.format("will force execute in low latency mode due to setting", new Object[0]));
        }
        int totalCoresRequired = coresPerWorker * startupWorkers;
        logger.info((Object)String.format("licensing enabled=%s, cores licensed=%d , cores available=%d , cores required by the dfc=%d ", new Boolean(licenseCheckEnabled).toString(), licensedVcpu, coresAvailable, totalCoresRequired));
        if (coresAvailable < totalCoresRequired) {
            String errorMsg = "The DFS search cannot run as the allocated vCPU's are currently in use. You can schedule this search at a later time.";
            throw new DFSLicenseException(errorMsg);
        }
        this.exceededLicensedCores = licenseCheckEnabled ? totalCoresRequired + clusterInfo.coresUsed() > licensedVcpu : false;
        int dfcNumCores = totalCoresRequired;
        if (lowLatencyMode[0]) {
            dfcNumCores = totalCoresInSH;
            logger.info((Object)String.format("dfc num cores set to: %d [total cores on search head] since execution in low latency mode", dfcNumCores));
        }
        int requiredTotalMemMbs = workerMemMbs * startupWorkers;
        logger.info((Object)String.format("Total memory required by dfc: %d mb", requiredTotalMemMbs));
        if (memoryAvailableMbs < requiredTotalMemMbs) {
            throw new RuntimeException(String.format("Cannot start dfc since no more memory available: required: %d mb, available: %d mb", requiredTotalMemMbs, memoryAvailableMbs));
        }
        if (coordinatorControlPort > 65535) {
            throw new DFSException(logger, String.format("Invalid dfc_control_port: %d specified in limits.conf.", coordinatorControlPort));
        }
        int dfwToDfcAuthRetryTimes = DFSearchDispatcher.getDfwToDfcAuthRetryTimes();
        int sslConfigServerSocketBacklogSize = DFSearchDispatcher.getSSLConfigServerSocketBacklogSize();
        int rdinServerSocketBacklogSize = DFSearchDispatcher.getRdinServerSocketBacklogSize();
        String masterUrl = clusterInfo.masterUrl();
        DFCParams dfcParams = new DFCParams(DFSearchDispatcher.getDfcTitle(searchHeadName, dfsSid), dfcId, coordinatorControlPort, maxSearchResultSize, maxReducePartitionSize, workerReceivingDataPort, workerReceivingDataPortCount, dfsMasterPort, dfsSid, dfcNumCores, startupWorkers, workerMemMbs, dfcDriverMemMbs, coresPerWorker, numDfcs, splunkVersion, extraKryoClasses, splunkConf, isDfsInstrumentationEnabled, dfsInstrumentationMode, dfsInstrumentationHecEndpoint, dfsInstrumentationHecToken, System.currentTimeMillis(), lowLatencyMode[0], dfcDriverCores, dfwToDfcAuthRetryTimes, sslConfigServerSocketBacklogSize, rdinServerSocketBacklogSize, dfsRemoteSearchTimeoutSec);
        final boolean[] abort = new boolean[1];
        DFCLauncherEmbedded dfcLauncher = new DFCLauncherEmbedded(sparkHome, coresPerWorker, startupWorkers, workerMemMbs, dfcDriverMemMbs, dfcDriverCores, masterUrl, "com.splunk.df.search.DFSSearchCoordinator", "dfs-0.0.1.jar", dfcParams, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                abort[0] = true;
                logger.warn((Object)String.format("DFC launch search completed or failed due to spark context shutdown: dfc id: %s", dfcId));
                DFSResourceManager dFSResourceManager = resourceMgr;
                synchronized (dFSResourceManager) {
                    resourceMgr.removeResourceInfo(dfcId, executionType);
                }
            }
        }, maxNumberOfDFCperSH);
        dri.setLauncher(dfcLauncher);
        long start = System.currentTimeMillis();
        while (!dri.getState().equals(DFSSearchCoordinatorState.RUNNING)) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (abort[0]) {
                throw new RuntimeException(String.format("DFC failed to start: dfs id: %s", dfcId));
            }
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed <= 60000L) continue;
            throw new RuntimeException(String.format("DFC start timeout exceeded: %d millis", elapsed));
        }
        logger.info((Object)String.format("DFC instance started on port: %d, dfs d: %s", dri.getDfcPort(), dfcId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal() throws Exception {
        logger.info((Object)String.format("Dispatching search execution: sid: %s, dfs id: %s", this.dfsSid, this.dfcId));
        if (this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType) == null) {
            logger.info((Object)String.format("DFC id not yet registered: %s", this.dfcId));
            DFSResourceManager dFSResourceManager = this.dfsResourceManager;
            synchronized (dFSResourceManager) {
                if (this.dfsResourceManager.numDfcs() >= this.coordinatorNumSlots) {
                    String errMsg = "Cannot start any more DFCs, since number of active data fabric searches have exceeded limit for search head. limit=" + this.coordinatorNumSlots;
                    DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, errMsg);
                    return;
                }
                try {
                    int activeDataFabricAppls = ComputeEngineClusterManagerFactory.getInstance().getActiveDataFabricApps(sparkMasterWebUrl, sparkMasterConnectTimeout);
                    if (this.executorNumSlotsEnabled && activeDataFabricAppls >= this.executorNumSlots) {
                        String errMsg = "Cannot start any more DFCs, since number of active data fabric searches have exceeded maximum number for cluster (or) searchhead. limit=" + this.executorNumSlots;
                        DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, errMsg);
                        return;
                    }
                }
                catch (Throwable t) {
                    DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, String.format("Error Communicating with DFM : %s ", t.getMessage()));
                }
            }
        }
        while (true) {
            DFSResourceManager.DFSResourceInfo dri;
            if ((dri = this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType)) != null && dri.getState().equals(DFSSearchCoordinatorState.RUNNING)) {
                this.sendDfcMessageToSplunkd(this.writeToSplunk, dri, this.dfsSid);
                logger.info((Object)String.format("DFC running and ready to receive search request from splunkd: sid: %s", this.dfsSid));
                return;
            }
            DFSResourceManager t = this.dfsResourceManager;
            synchronized (t) {
                dri = this.dfsResourceManager.getResourceInfo(this.dfcId, this.executionType);
                if (dri != null) {
                    continue;
                }
                dri = new DFSResourceManager.DFSResourceInfo(this.dfsSid, this.executionType, -1);
                this.dfsResourceManager.addDri(this.dfcId, this.executionType, dri);
                logger.info((Object)String.format("Added dfs id: %s to resource manager", this.dfcId));
            }
            try {
                this.startDfc(this.sparkHome, this.dfcId, this.dfsMasterPort, this.dfsSid, dri, this.dfsResourceManager, this.executionType, this.maxSearchResultSize, this.coordinatorNumSlots, this.coordinatorControlPort, this.maxReducePartitionSize, this.workerReceivingDataPort, this.workerReceivingDataPortCount, this.splunkVersion, this.extraKryoClasses, this.splunkConf, this.searchHeadName, this.isDfsInstrumentationEnabled, this.dfsInstrumentationMode, this.dfsInstrumentationHecEndpoint, this.dfsInstrumentationHecToken, this.pbsEnabled, this.splunkAllSearchPeers, this.isSearchFederated, this.sparkWorkerCheckingEnabled, this.dfsRemoteSearchTimeoutSec, this.licenseCheckEnabled, this.dfsLicensedVcpu);
                continue;
            }
            catch (DFSException | DFSLicenseException e) {
                DFSResourceManager errMsg = this.dfsResourceManager;
                synchronized (errMsg) {
                    this.dfsResourceManager.removeResourceInfo(this.dfcId, this.executionType);
                }
                logger.error((Object)String.format("Error starting dfc: %s", ExceptionUtils.getFullStackTrace((Throwable)e)), (Throwable)e);
                String errorMsg = e instanceof DFSLicenseException ? ((DFSLicenseException)e).getMessage() : "Error occurred while trying to start Data Fabric Coordinator: " + e.getMessage();
                DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, errorMsg);
                continue;
            }
            catch (Throwable t2) {
                DFSResourceManager dFSResourceManager = this.dfsResourceManager;
                synchronized (dFSResourceManager) {
                    this.dfsResourceManager.removeResourceInfo(this.dfcId, this.executionType);
                }
                logger.error((Object)String.format("Error starting dfc: %s", ExceptionUtils.getFullStackTrace((Throwable)t2)), t2);
                DFSearchDispatcher.sendDfcFailureToSplunkd(this.writeToSplunk, this.dfsSid, "Error occurred while trying to start Data Fabric Coordinator. Refer to Data Fabric Master logs(SPLUNK_HOME/var/log/splunk/dfs.log) for details.");
                continue;
            }
            break;
        }
    }

    private static String getDfcTitle(String serverName, String dfsSid) {
        String AppName = "DATA_FABRIC_1.1.1_" + serverName + "_" + dfsSid;
        return AppName;
    }
}

