/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ExecutorResourceRequest$;
import org.apache.spark.resource.ResourceProfile$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0004\b\u0001!YAQ\u0001\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004@\u0001\u0001\u0006Ia\n\u0005\u0006\u0001\u0002!\t!\u0011\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u0015\u0002!\ta\u0013\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006!\u0002!\t!\u0015\u0005\u0006\u001f\u0001!\tA\u0016\u0005\bC\u0002\t\n\u0011\"\u0001c\u0011\u001di\u0007!%A\u0005\u0002\tDQA\u001c\u0001\u0005B=\u0014\u0001$\u0012=fGV$xN\u001d*fg>,(oY3SKF,Xm\u001d;t\u0015\ty\u0001#\u0001\u0005sKN|WO]2f\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u00039\t!cX3yK\u000e,Ho\u001c:SKN|WO]2fgV\tq\u0005\u0005\u0003)_EbT\"A\u0015\u000b\u0005)Z\u0013AC2p]\u000e,(O]3oi*\u0011A&L\u0001\u0005kRLGNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AJ#!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011!'\u000f\b\u0003g]\u0002\"\u0001N\r\u000e\u0003UR!AN\u0011\u0002\rq\u0012xn\u001c;?\u0013\tA\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003um\u0012aa\u0015;sS:<'B\u0001\u001d\u001a!\t!S(\u0003\u0002?\u001d\t9R\t_3dkR|'OU3t_V\u00148-\u001a*fcV,7\u000f^\u0001\u0014?\u0016DXmY;u_J\u0014Vm]8ve\u000e,7\u000fI\u0001\te\u0016\fX/Z:ugV\t!\t\u0005\u00033\u0007Fb\u0014B\u0001#<\u0005\ri\u0015\r]\u0001\u0007[\u0016lwN]=\u0015\u0005\u001dCU\"\u0001\u0001\t\u000b%+\u0001\u0019A\u0019\u0002\r\u0005lw.\u001e8u\u00039iW-\\8ss>3XM\u001d5fC\u0012$\"a\u0012'\t\u000b%3\u0001\u0019A\u0019\u0002\u001bAL8\u000f]1sW6+Wn\u001c:z)\t9u\nC\u0003J\u000f\u0001\u0007\u0011'A\u0003d_J,7\u000f\u0006\u0002H%\")\u0011\n\u0003a\u0001'B\u0011\u0001\u0004V\u0005\u0003+f\u00111!\u00138u)\u00159u+W/`\u0011\u0015A\u0016\u00021\u00012\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u0015I\u0015\u00021\u0001[!\tA2,\u0003\u0002]3\t!Aj\u001c8h\u0011\u001dq\u0016\u0002%AA\u0002E\nq\u0002Z5tG>4XM]=TGJL\u0007\u000f\u001e\u0005\bA&\u0001\n\u00111\u00012\u0003\u00191XM\u001c3pe\u0006\u0011\"/Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005\u0019'FA\u0019eW\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003%)hn\u00195fG.,GM\u0003\u0002k3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00051<'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011\"/Z:pkJ\u001cW\r\n3fM\u0006,H\u000e\u001e\u00135\u0003!!xn\u0015;sS:<G#A\u0019")
public class ExecutorResourceRequests
implements Serializable {
    private final ConcurrentHashMap<String, ExecutorResourceRequest> _executorResources = new ConcurrentHashMap();

    private ConcurrentHashMap<String, ExecutorResourceRequest> _executorResources() {
        return this._executorResources;
    }

    public Map<String, ExecutorResourceRequest> requests() {
        return ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this._executorResources()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public ExecutorResourceRequests memory(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.MEMORY(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.MEMORY(), req);
        return this;
    }

    public ExecutorResourceRequests memoryOverhead(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.OVERHEAD_MEM(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.OVERHEAD_MEM(), req);
        return this;
    }

    public ExecutorResourceRequests pysparkMemory(String amount) {
        long amountMiB = JavaUtils.byteStringAsMb((String)amount);
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.PYSPARK_MEM(), amountMiB, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.PYSPARK_MEM(), req);
        return this;
    }

    public ExecutorResourceRequests cores(int amount) {
        ExecutorResourceRequest req = new ExecutorResourceRequest(ResourceProfile$.MODULE$.CORES(), amount, ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$3(), ExecutorResourceRequest$.MODULE$.$lessinit$greater$default$4());
        this._executorResources().put(ResourceProfile$.MODULE$.CORES(), req);
        return this;
    }

    public ExecutorResourceRequests resource(String resourceName, long amount, String discoveryScript, String vendor) {
        ExecutorResourceRequest req = new ExecutorResourceRequest(resourceName, amount, discoveryScript, vendor);
        this._executorResources().put(resourceName, req);
        return this;
    }

    public String resource$default$3() {
        return "";
    }

    public String resource$default$4() {
        return "";
    }

    public String toString() {
        return new StringBuilder(28).append("Executor resource requests: ").append(this._executorResources()).toString();
    }
}

