/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.visitors;

import com.splunk.commons.ast.nodes.Node;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.search.SearchAndNode;
import com.splunk.commons.ast.nodes.search.SearchComparisonNode;
import com.splunk.commons.ast.nodes.search.SearchFunctionNode;
import com.splunk.commons.ast.nodes.search.SearchNode;
import com.splunk.commons.ast.nodes.search.SearchOrNode;
import com.splunk.commons.ast.nodes.search.SearchXorNode;
import com.splunk.commons.util.StringUtils;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.List;

public class SqlFormatter
extends NodeVisitor<String> {
    @Override
    public String visit(Node node) {
        throw new RuntimeException("Unexpected Node Encountered.");
    }

    @Override
    public String visit(FieldNode node) {
        return node.getFieldName();
    }

    @Override
    public String visit(NumberNode node) {
        return node.toString();
    }

    @Override
    public String visit(StringNode node) {
        return String.format("\"%1$s\"", node.getValue());
    }

    @Override
    public String visit(SearchAndNode node) {
        return StringUtils.join(" AND ", this.visitArgs(node));
    }

    @Override
    public String visit(SearchOrNode node) {
        return StringUtils.join(" OR ", this.visitArgs(node));
    }

    @Override
    public String visit(SearchXorNode node) {
        return StringUtils.join(" XOR ", this.visitArgs(node));
    }

    @Override
    public String visit(SearchComparisonNode node) {
        return String.format("%1$s%2$s%3$s", node.getLhs().accept(this), node.getOperator().toSplOperator(), node.getRhs().accept(this));
    }

    private String[] visitArgs(SearchFunctionNode node) {
        List<SearchNode> nodes = node.getArguments();
        String[] values = new String[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            values[i] = nodes.get(i).accept(this);
        }
        return values;
    }
}

