/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.search;

import com.splunk.commons.ast.matchers.CidrMatcher;
import com.splunk.commons.ast.matchers.IMatcher;
import com.splunk.commons.ast.matchers.NumberMatcher;
import com.splunk.commons.ast.matchers.TermMatcher;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.expressions.BooleanNode;
import com.splunk.commons.ast.nodes.expressions.FieldNode;
import com.splunk.commons.ast.nodes.expressions.NumberNode;
import com.splunk.commons.ast.nodes.expressions.Operator;
import com.splunk.commons.ast.nodes.expressions.StringNode;
import com.splunk.commons.ast.nodes.expressions.TypeNode;
import com.splunk.commons.ast.nodes.search.SearchLeafNode;
import com.splunk.commons.ast.nodes.search.SearchModifier;
import com.splunk.commons.visitors.NodeVisitor;
import java.util.regex.Pattern;

public class SearchComparisonNode
extends SearchLeafNode
implements ISearchPredicate {
    private static final Pattern cidrRegex = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\/(\\d|[1-2]\\d|3[0-2]))$");
    private final Operator operator;
    private final FieldNode lhs;
    private final TypeNode rhs;
    private final boolean isLhsQuoted;
    private final boolean isRhsQuoted;
    private final boolean isIndexed;
    private final IMatcher matcher;

    public SearchComparisonNode(Operator operator, FieldNode lhs, TypeNode rhs) {
        this(operator, lhs, rhs, false, false, false, false, SearchModifier.NONE);
    }

    public SearchComparisonNode(Operator operator, FieldNode lhs, TypeNode rhs, boolean isNegated, boolean isLhsQuoted, boolean isRhsQuoted, boolean isIndexed, SearchModifier modifier) {
        super("function", isNegated, modifier);
        if (isRhsQuoted && rhs instanceof NumberNode) {
            throw new IllegalArgumentException("Invalid state detected. SearchComparisons must not have quoted numeric rhs.");
        }
        this.operator = operator;
        this.lhs = SearchComparisonNode.verifyLhs(lhs);
        this.rhs = SearchComparisonNode.verifyRhs(rhs);
        this.isLhsQuoted = isLhsQuoted;
        this.isRhsQuoted = isRhsQuoted;
        this.isIndexed = isIndexed;
        this.matcher = SearchComparisonNode.buildMatcher(operator, rhs, modifier == SearchModifier.CASE);
    }

    private static FieldNode verifyLhs(FieldNode lhs) {
        SearchComparisonNode.assertNotNull("LHS field must not be null", lhs);
        return lhs;
    }

    private static TypeNode verifyRhs(TypeNode rhs) {
        SearchComparisonNode.assertNotNull("RHS value must not be null", rhs);
        if (rhs instanceof StringNode || rhs instanceof NumberNode || rhs instanceof BooleanNode) {
            return rhs;
        }
        throw new IllegalArgumentException("Expected rhs to be a StringNode, NumberNode, or BooleanNode.");
    }

    private static IMatcher buildMatcher(Operator operator, TypeNode rhs, boolean caseSensitive) {
        if (rhs instanceof StringNode && (operator == Operator.EQUAL || operator == Operator.NOT_EQUAL || operator == Operator.EQUAL_EQUAL)) {
            String value = ((StringNode)rhs).getValue();
            if (CidrMatcher.isCidr(value)) {
                return new CidrMatcher(value);
            }
            return new TermMatcher(value, caseSensitive);
        }
        if (rhs instanceof NumberNode) {
            return new NumberMatcher(((NumberNode)rhs).getValue(), operator);
        }
        return null;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public FieldNode getLhs() {
        return this.lhs;
    }

    public TypeNode getRhs() {
        return this.rhs;
    }

    public boolean is_lhs_quoted() {
        return this.isLhsQuoted;
    }

    public boolean is_rhs_quoted() {
        return this.isRhsQuoted;
    }

    public boolean is_numeric() {
        return this.rhs instanceof NumberNode;
    }

    public boolean is_indexed() {
        return this.isIndexed;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public IMatcher getMatcher() {
        return this.matcher;
    }
}

