/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.expressions;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Number {
    private Number() {
    }

    public static boolean isNumeric(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Double || object instanceof Float || object instanceof Long || object instanceof Integer || object instanceof BigDecimal;
    }

    public static Type targetNumericType(Object lhs, Object rhs) {
        if (lhs == null || rhs == null) {
            return null;
        }
        if (Number.isNumeric(lhs) && Number.isNumeric(rhs)) {
            Class<?> rhsClass;
            Class<?> lhsClass = lhs.getClass();
            if (lhsClass == (rhsClass = rhs.getClass())) {
                return lhsClass;
            }
            if (lhsClass == BigDecimal.class || rhsClass == BigDecimal.class) {
                return BigDecimal.class;
            }
            if (lhsClass == Double.class || rhsClass == Double.class || lhsClass == Float.class && rhsClass == Long.class || lhsClass == Float.TYPE && rhsClass == Float.class) {
                return Double.class;
            }
            if (lhsClass == Float.class || rhsClass == Float.class) {
                return Float.class;
            }
            if (lhsClass == Long.class || rhsClass == Long.class) {
                return Long.class;
            }
            return Integer.class;
        }
        try {
            new BigDecimal(lhs.toString());
            new BigDecimal(rhs.toString());
            return BigDecimal.class;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("One or both of the arguments is not a supported Numeric type");
        }
    }

    private static Object[] getParsedArgs(Object lhs, Object rhs, Type targetClass) {
        Object[] args = new Object[2];
        try {
            if (targetClass == BigDecimal.class) {
                args[0] = lhs instanceof BigDecimal ? (BigDecimal)lhs : new BigDecimal(lhs.toString());
                Object object = args[1] = rhs instanceof BigDecimal ? (BigDecimal)rhs : new BigDecimal(rhs.toString());
            }
            if (targetClass == Double.class) {
                args[0] = lhs instanceof Double ? (Double)lhs : Double.parseDouble(lhs.toString());
                args[1] = rhs instanceof Double ? (Double)rhs : Double.parseDouble(rhs.toString());
            }
            if (targetClass == Float.class) {
                args[0] = Float.valueOf(lhs instanceof Float ? ((Float)lhs).floatValue() : Float.parseFloat(lhs.toString()));
                args[1] = Float.valueOf(rhs instanceof Float ? ((Float)rhs).floatValue() : Float.parseFloat(rhs.toString()));
            }
            if (targetClass == Long.class) {
                args[0] = lhs instanceof Long ? (Long)lhs : Long.parseLong(lhs.toString());
                args[1] = rhs instanceof Long ? (Long)rhs : Long.parseLong(rhs.toString());
            }
            if (targetClass == Integer.class) {
                args[0] = lhs instanceof Integer ? (Integer)lhs : Integer.parseInt(lhs.toString());
                args[1] = rhs instanceof Integer ? (Integer)rhs : Integer.parseInt(rhs.toString());
            }
            return args;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception detected while parsing arguments.");
        }
    }

    public static Object add(Object lhs, Object rhs) {
        Type targetClass = Number.targetNumericType(lhs, rhs);
        if (targetClass == null) {
            return null;
        }
        Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
        if (targetClass == BigDecimal.class) {
            return ((BigDecimal)args[0]).add((BigDecimal)args[1]);
        }
        if (targetClass == Double.class) {
            return (Double)args[0] + (Double)args[1];
        }
        if (targetClass == Float.class) {
            return Float.valueOf(((Float)args[0]).floatValue() + ((Float)args[1]).floatValue());
        }
        if (targetClass == Long.class) {
            try {
                return Math.addExact((Long)args[0], (Long)args[1]);
            }
            catch (ArithmeticException e) {
                return BigInteger.valueOf((Long)args[0]).add(BigInteger.valueOf((Long)args[1]));
            }
        }
        try {
            return Math.addExact((Integer)args[0], (Integer)args[1]);
        }
        catch (ArithmeticException e) {
            return Long.valueOf(((Integer)args[0]).intValue()) + Long.valueOf(((Integer)args[1]).intValue());
        }
    }

    public static Object subtract(Object lhs, Object rhs) {
        Type targetClass = Number.targetNumericType(lhs, rhs);
        if (targetClass == null) {
            return null;
        }
        Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
        if (targetClass == BigDecimal.class) {
            return ((BigDecimal)args[0]).subtract((BigDecimal)args[1]);
        }
        if (targetClass == Double.class) {
            return (Double)args[0] - (Double)args[1];
        }
        if (targetClass == Float.class) {
            return Float.valueOf(((Float)args[0]).floatValue() - ((Float)args[1]).floatValue());
        }
        if (targetClass == Long.class) {
            try {
                return Math.subtractExact((Long)args[0], (Long)args[1]);
            }
            catch (ArithmeticException e) {
                return BigInteger.valueOf((Long)args[0]).subtract(BigInteger.valueOf((Long)args[1]));
            }
        }
        try {
            return Math.subtractExact((Integer)args[0], (Integer)args[1]);
        }
        catch (ArithmeticException e) {
            return Long.valueOf(((Integer)args[0]).intValue()) - Long.valueOf(((Integer)args[1]).intValue());
        }
    }

    public static Object multiply(Object lhs, Object rhs) {
        Type targetClass = Number.targetNumericType(lhs, rhs);
        if (targetClass == null) {
            return null;
        }
        Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
        if (targetClass == BigDecimal.class) {
            return ((BigDecimal)args[0]).doubleValue() * ((BigDecimal)args[1]).doubleValue();
        }
        if (targetClass == Double.class) {
            return (Double)args[0] * (Double)args[1];
        }
        if (targetClass == Float.class) {
            return Float.valueOf(((Float)args[0]).floatValue() * ((Float)args[1]).floatValue());
        }
        if (targetClass == Long.class) {
            try {
                return Math.multiplyExact((long)((Long)args[0]), (Long)args[1]);
            }
            catch (ArithmeticException e) {
                return BigInteger.valueOf((Long)args[0]).multiply(BigInteger.valueOf((Long)args[1]));
            }
        }
        try {
            return Math.multiplyExact((Integer)args[0], (int)((Integer)args[1]));
        }
        catch (ArithmeticException e) {
            return Long.valueOf(((Integer)args[0]).intValue()) * Long.valueOf(((Integer)args[1]).intValue());
        }
    }

    public static Object divide(Object lhs, Object rhs) {
        Type targetClass = Number.targetNumericType(lhs, rhs);
        if (targetClass == null) {
            return null;
        }
        Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
        if (targetClass == BigDecimal.class) {
            double result = ((BigDecimal)args[0]).doubleValue() / ((BigDecimal)args[1]).doubleValue();
            return Number.tryLong(result);
        }
        if (targetClass == Double.class) {
            return (Double)args[0] / (Double)args[1];
        }
        if (targetClass == Float.class) {
            return Float.valueOf(((Float)args[0]).floatValue() / ((Float)args[1]).floatValue());
        }
        if (targetClass == Long.class) {
            double result = (double)((Long)args[0]).longValue() * 1.0 / (double)((Long)args[1]).longValue();
            return Number.tryLong(result);
        }
        double result = (double)((Integer)args[0]).intValue() * 1.0 / (double)((Integer)args[1]).intValue();
        if (result == (double)((int)result)) {
            return (int)result;
        }
        return result;
    }

    public static Object modulo(Object lhs, Object rhs) {
        Type targetClass = Number.targetNumericType(lhs, rhs);
        if (targetClass == null) {
            return null;
        }
        Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
        if (targetClass == BigDecimal.class) {
            return ((BigDecimal)args[0]).remainder((BigDecimal)args[1]);
        }
        if (targetClass == Double.class) {
            return (Double)args[0] % (Double)args[1];
        }
        if (targetClass == Float.class) {
            return Float.valueOf(((Float)args[0]).floatValue() % ((Float)args[1]).floatValue());
        }
        if (targetClass == Long.class) {
            return (Long)args[0] % (Long)args[1];
        }
        return (Integer)args[0] % (Integer)args[1];
    }

    public static Object equal(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() == ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return ((Double)args[0]).doubleValue() == ((Double)args[1]).doubleValue();
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() == ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return ((Long)args[0]).longValue() == ((Long)args[1]).longValue();
            }
            return ((Integer)args[0]).intValue() == ((Integer)args[1]).intValue();
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Object notEqual(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() != ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return ((Double)args[0]).doubleValue() != ((Double)args[1]).doubleValue();
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() != ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return ((Long)args[0]).longValue() != ((Long)args[1]).longValue();
            }
            return ((Integer)args[0]).intValue() != ((Integer)args[1]).intValue();
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Object greaterThan(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() > ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return (Double)args[0] > (Double)args[1];
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() > ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return (Long)args[0] > (Long)args[1];
            }
            return (Integer)args[0] > (Integer)args[1];
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Object greaterThanEqual(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() >= ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return (Double)args[0] >= (Double)args[1];
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() >= ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return (Long)args[0] >= (Long)args[1];
            }
            return (Integer)args[0] >= (Integer)args[1];
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Object lessThan(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() < ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return (Double)args[0] < (Double)args[1];
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() < ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return (Long)args[0] < (Long)args[1];
            }
            return (Integer)args[0] < (Integer)args[1];
        }
        catch (Exception nfe) {
            return null;
        }
    }

    public static Object lessThanEqual(Object lhs, Object rhs) {
        try {
            Type targetClass = Number.targetNumericType(lhs, rhs);
            if (targetClass == null) {
                return false;
            }
            Object[] args = Number.getParsedArgs(lhs, rhs, targetClass);
            if (targetClass == BigDecimal.class) {
                return ((BigDecimal)args[0]).doubleValue() <= ((BigDecimal)args[1]).doubleValue();
            }
            if (targetClass == Double.class) {
                return (Double)args[0] <= (Double)args[1];
            }
            if (targetClass == Float.class) {
                return ((Float)args[0]).floatValue() <= ((Float)args[1]).floatValue();
            }
            if (targetClass == Long.class) {
                return (Long)args[0] <= (Long)args[1];
            }
            return (Integer)args[0] <= (Integer)args[1];
        }
        catch (Exception nfe) {
            return null;
        }
    }

    private static Object tryLong(double result) {
        if (result == (double)((long)result)) {
            return (long)result;
        }
        return result;
    }
}

