/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.commons.ast.nodes.commands;

import com.splunk.commons.ast.nodes.CommandNode;
import com.splunk.commons.ast.nodes.CommandType;
import com.splunk.commons.ast.nodes.ISearchPredicate;
import com.splunk.commons.ast.nodes.commands.FieldsAndProperties;
import com.splunk.commons.datasets.Dataset;
import com.splunk.commons.visitors.AssertingVisitor;
import com.splunk.commons.visitors.NodeVisitor;

public class InputlookupCommand
extends CommandNode {
    public static final int DEFAULT_START = 0;
    public static final int DEFAULT_MAX = 0;
    private final Dataset dataset;
    private final ISearchPredicate where;
    private final int start;
    private final int max;
    private final boolean append;

    public InputlookupCommand(String lookupName) {
        this(lookupName, null, 0, 0);
    }

    public InputlookupCommand(String lookupName, ISearchPredicate where) {
        this(lookupName, where, 0, 0);
    }

    public InputlookupCommand(CommandNode source, String lookupName) {
        this(source, lookupName, null, 0, 0);
    }

    public InputlookupCommand(CommandNode source, String lookupName, ISearchPredicate predicate) {
        this(source, lookupName, predicate, 0, 0);
    }

    public InputlookupCommand(String lookupName, ISearchPredicate where, int start, int max) {
        super("inputlookup", CommandType.SP_REPORT, FieldsAndProperties.DEFAULT);
        AssertingVisitor.assertOnlySearchComparisonsAndGroups(where, "Inputlookup only allows for SearchComparisonNodes, SearchOrNodes, SearchXorNodes and SearchAndNodes. No SearchTermNodes or SearchPhraseNodes are allowed in the predicate.");
        this.dataset = new Dataset("lookup", lookupName);
        this.where = where;
        this.start = start;
        this.max = max;
        this.append = false;
    }

    public InputlookupCommand(CommandNode source, String lookupName, ISearchPredicate where, int start, int max) {
        super(source, "inputlookup", CommandType.SP_REPORT, FieldsAndProperties.DEFAULT);
        AssertingVisitor.assertOnlySearchComparisonsAndGroups(where, "Inputlookup only allows for SearchComparisonNodes, SearchOrNodes, SearchXorNodes and SearchAndNodes. No SearchTermNodes or SearchPhraseNodes are allowed in the predicate.");
        this.dataset = new Dataset("lookup", lookupName);
        this.where = where;
        this.start = start;
        this.max = max;
        this.append = true;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    public String getLookupName() {
        return this.dataset.getModuleQualifiedName();
    }

    public ISearchPredicate getWhere() {
        return this.where;
    }

    public int getStart() {
        return this.start;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isAppend() {
        return this.append;
    }

    @Override
    public <T> T accept(NodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

