/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.mr.SplunkMR;
import com.splunk.roll.Bucket;
import com.splunk.roll.RollTransfer;
import com.splunk.roll.ThrottledIO;
import com.splunk.roll.slices.BucketRawdataProvider;
import com.splunk.roll.slices.Slices;
import com.splunk.util.Lazy;
import com.splunk.util.TextUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class BucketExporter {
    public static final String SLICE_METADATA_SEQ_KEY = "slice-metadata.json";
    public static final String BUCKET_METADATA_FILES_SEQ = "bucket-metadata.seq";
    public static final Class<Text> DATA_SEQ_FILE_KEY_CLASS = Text.class;
    public static final Class<Text> DATA_SEQ_FILE_VAL_CLASS = Text.class;
    private static final Logger gLogger = Logger.getLogger(BucketExporter.class);
    public static final String JOURNAL_FILENAME = "journal.gz";
    private final Configuration conf;
    private final ThrottledIO throttledIO;
    private final BucketRawdataProvider journalStreamProvider;

    public BucketExporter(Configuration conf, ThrottledIO throttledIO, BucketRawdataProvider journalStreamProvider) {
        this.conf = conf;
        this.throttledIO = throttledIO;
        this.journalStreamProvider = journalStreamProvider;
    }

    public List<RollTransfer> export(Bucket.LocalBucket b, File prepareBucketDir, Path remotePrepareDir) throws IOException {
        ArrayList<RollTransfer> transfers = new ArrayList<RollTransfer>();
        BucketRawdataProvider.BucketRawdata rawdata = this.journalStreamProvider.getRawdata(BucketExporter.getRawDataDir(b.getDir()));
        RollTransfer transfer = this.exportBucketMetadata(b, remotePrepareDir, rawdata.sliceMetadata);
        transfers.add(this.exportJournal(b, rawdata.journalStream, remotePrepareDir));
        if (transfer != null) {
            transfers.add(transfer);
        }
        return transfers;
    }

    private RollTransfer exportJournal(Bucket.LocalBucket bucket, Lazy<InputStream> journalStream, Path remotePrepareDir) throws FileNotFoundException, IOException {
        File journal = BucketExporter.getBucketsJournal(bucket);
        if (!journal.exists()) {
            throw new RuntimeException("bucket: " + bucket + " does not have a journal.gz. Aborting export of this bucket!");
        }
        Path journalRemoteDst = new Path(remotePrepareDir, JOURNAL_FILENAME);
        long size = this.copyJournalToRemoteFsWithOneBlock(this.conf, this.throttledIO, bucket, journalRemoteDst, journalStream);
        FileSystem fs = journalRemoteDst.getFileSystem(this.conf);
        boolean exists = fs.exists(journalRemoteDst);
        long postSize = -1L;
        if (exists) {
            FileStatus status = fs.getFileStatus(journalRemoteDst);
            postSize = status.getLen();
        }
        gLogger.debug((Object)("[SPECIAL] Supposedly just copied journal to " + journalRemoteDst + ". Exists? " + exists + " Size? " + postSize));
        return new RollTransfer(journalRemoteDst, size);
    }

    private RollTransfer exportBucketMetadata(Bucket.LocalBucket bucket, Path remotePrepareDir, Slices sliceMetadata) throws IOException {
        RollTransfer rollTransfer;
        HashMap<Text, Lazy<Text>> seqKeyValues = new HashMap<Text, Lazy<Text>>();
        this.putDataFiles(seqKeyValues, bucket);
        this.putSliceMeta(seqKeyValues, sliceMetadata);
        SequenceFile.Writer writer = null;
        try {
            Path dataSeqFile = BucketExporter.getDataFile(remotePrepareDir);
            FileSystem fs = dataSeqFile.getFileSystem(this.conf);
            writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)dataSeqFile, DATA_SEQ_FILE_KEY_CLASS, DATA_SEQ_FILE_VAL_CLASS);
            for (Map.Entry e : seqKeyValues.entrySet()) {
                Text key = (Text)e.getKey();
                Text value = (Text)((Lazy)e.getValue()).get();
                this.throttledIO.requestBytes(key.getLength() + value.getLength());
                writer.append((Writable)key, (Writable)value);
            }
            rollTransfer = new RollTransfer(dataSeqFile, writer.getLength());
        }
        catch (InterruptedException e) {
            try {
                throw ThrottledIO.wrappedInterrupt(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer);
        return rollTransfer;
    }

    private void putDataFiles(Map<Text, Lazy<Text>> seqKeyValues, Bucket.LocalBucket bucket) {
        for (final File dataFile : this.listDataFiles(bucket)) {
            seqKeyValues.put(new Text(dataFile.getName()), new Lazy<Text>(){

                @Override
                public Text get() throws IOException {
                    return TextUtil.newText(BucketExporter.this.fileToBytes(dataFile));
                }
            });
        }
    }

    private void putSliceMeta(Map<Text, Lazy<Text>> seqKeyValues, final Slices sliceMetadata) {
        if (!sliceMetadata.isEmpty()) {
            seqKeyValues.put(new Text(SLICE_METADATA_SEQ_KEY), new Lazy<Text>(){

                @Override
                public Text get() throws IOException {
                    return TextUtil.newText(sliceMetadata.toJson());
                }
            });
        }
    }

    private List<File> listDataFiles(Bucket.LocalBucket b) {
        File[] localDataFiles = b.getDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".data");
            }
        });
        if (localDataFiles == null) {
            gLogger.warn((Object)("Could not find any .data files in bucket=" + b));
            return Collections.emptyList();
        }
        return Arrays.asList(localDataFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] fileToBytes(File localDataFile) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtils.openInputStream((File)localDataFile);
            byte[] byArray = IOUtils.toByteArray((InputStream)in, (long)localDataFile.length());
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyJournalToRemoteFsWithOneBlock(Configuration conf, ThrottledIO throttledIO, Bucket.LocalBucket bucket, Path journalRemoteDst, Lazy<InputStream> journalStream) throws FileNotFoundException, IOException {
        long l;
        File journal = BucketExporter.getBucketsJournal(bucket);
        long defaultBlockSize = conf.getLong("dfs.blocksize", 0x8000000L);
        long journalBlockSize = 0L;
        journalBlockSize = SplunkMR.checkBlockSize(conf) ? SplunkMR.getBlockSizeFromConf(conf) : Math.max(defaultBlockSize, journal.length());
        journalBlockSize = BucketExporter.roundUpToMultiple(journalBlockSize, 0x4000000L);
        gLogger.debug((Object)("Setting the block size to: " + journalBlockSize));
        boolean overwrite = true;
        InputStream fileIn = null;
        FSDataOutputStream journalOut = null;
        FileSystem fs = journalRemoteDst.getFileSystem(conf);
        try {
            fileIn = journalStream.get();
            journalOut = fs.create(journalRemoteDst, overwrite, fs.getConf().getInt("io.file.buffer.size", 4096), fs.getDefaultReplication(), journalBlockSize);
            l = throttledIO.copy(fileIn, (OutputStream)journalOut);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)fileIn);
            IOUtils.closeQuietly(journalOut);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileIn);
        IOUtils.closeQuietly((OutputStream)journalOut);
        return l;
    }

    public static long roundUpToMultiple(long value, long multiple) {
        if (value != 0L && value % multiple == 0L) {
            return value;
        }
        long div = value / multiple;
        return multiple * (div + 1L);
    }

    public static File getBucketsJournal(Bucket.LocalBucket b) {
        return BucketExporter.getBucketsJournal(b.getDir());
    }

    public static File getBucketsJournal(File bucketDir) {
        return new File(BucketExporter.getRawDataDir(bucketDir), JOURNAL_FILENAME);
    }

    public static File getRawDataDir(File bucketDir) {
        return new File(bucketDir, "rawdata");
    }

    public static BucketExporter create(Configuration conf, ThrottledIO throttledIO) {
        return new BucketExporter(conf, throttledIO, BucketRawdataProvider.create(conf));
    }

    public static Path getDataFile(Path remotePrepare) {
        return new Path(remotePrepare, BUCKET_METADATA_FILES_SEQ);
    }
}

