/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.cache;

import com.splunk.mr.cache.Cache;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class GetsReferenceFile {
    public static final int REFS_TO_KEEP = 5;
    private final FileSystem fs;
    private final Path referenceDir;

    public GetsReferenceFile(FileSystem fs, Path referenceDir) {
        this.fs = fs;
        this.referenceDir = referenceDir;
    }

    public Path getMostRecent() throws NoCacheRefsAvailable, IOException {
        FileStatus[] ls = this.fs.listStatus(this.referenceDir, new PathFilter(){

            public boolean accept(Path path) {
                String filename = path.getName();
                return filename.startsWith("cache") && filename.endsWith(".ref");
            }
        });
        if (ls.length == 0) {
            throw new NoCacheRefsAvailable();
        }
        return this.getPathWithLargestId(ls);
    }

    private Path getPathWithLargestId(FileStatus[] ls) {
        SortedMap<Integer, Path> pathsById = this.createSortedMapByLargeId();
        for (FileStatus f : ls) {
            Path p = f.getPath();
            pathsById.put(this.getIdFromPath(p), p);
        }
        this.garbageCollect(pathsById);
        return (Path)pathsById.get(pathsById.firstKey());
    }

    private SortedMap<Integer, Path> createSortedMapByLargeId() {
        return new TreeMap<Integer, Path>(new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return arg1.compareTo(arg0);
            }
        });
    }

    private void garbageCollect(SortedMap<Integer, Path> sortedPathsById) {
        int i = 1;
        for (Map.Entry<Integer, Path> e : sortedPathsById.entrySet()) {
            if (i++ <= 5) continue;
            try {
                this.fs.delete(e.getValue(), false);
            }
            catch (IOException iOException) {}
        }
    }

    private Integer getIdFromPath(Path path) {
        return Integer.parseInt(path.getName().replace("cache", "").replace(".ref", ""));
    }

    public Path getNewPath(Cache cache) {
        return new Path(this.referenceDir, "cache" + cache.getId() + ".ref");
    }

    public static class NoCacheRefsAvailable
    extends Exception {
    }
}

