/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.Bucket;
import com.splunk.roll.ClusterSlaveBucketsEndpoint;
import com.splunk.roll.util.ConfU;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.util.Lazy;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class ArchivableBucketsFilter {
    private static final Logger gLogger = Logger.getLogger(ArchivableBucketsFilter.class);
    private final Lazy.LazyOnce<ClusterSlaveBucketsEndpoint> cluster;

    public ArchivableBucketsFilter(Lazy.LazyOnce<ClusterSlaveBucketsEndpoint> cluster) {
        this.cluster = cluster;
    }

    public boolean isBucketArchivable(Bucket bucket) {
        if (bucket.isFrozen() || !bucket.isReplicated()) {
            return true;
        }
        return this.isReplicationComplete(bucket);
    }

    private boolean isReplicationComplete(Bucket bucket) {
        try {
            boolean replicationComplete = this.cluster.get().isReplicationComplete(bucket);
            if (!replicationComplete) {
                this.logIncompleteReplication(bucket);
            }
            return replicationComplete;
        }
        catch (IOException e) {
            gLogger.error((Object)("Exception when checking if bucket was fully replicated. Will not archive bucket: " + bucket + " exception=" + e + " message=" + e.getMessage()));
            return false;
        }
    }

    private void logIncompleteReplication(Bucket bucket) {
        gLogger.debug((Object)("Bucket's replication status was not complete. " + bucket));
    }

    public static ArchivableBucketsFilter create(final Configuration conf) {
        return new ArchivableBucketsFilter(new Lazy.LazyOnce<ClusterSlaveBucketsEndpoint>(){

            @Override
            protected ClusterSlaveBucketsEndpoint getOnce() {
                URI uri = ConfU.getSplunkServerURI(conf);
                String authToken = ConfU.getSplunkServerAuthToken(conf);
                return new ClusterSlaveBucketsEndpoint(new SplunkMiniSDK(uri, authToken));
            }
        });
    }
}

