/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.journal;

import com.splunk.journal.FieldDecoder;
import com.splunk.journal.PrimitiveLongList;
import java.util.Arrays;
import java.util.Map;

public class EventData {
    private byte[] rawContents;
    private byte[] estorage;
    private PrimitiveLongList metaInfo;
    private long indexTime;
    private long encodedSubseconds;
    private byte[] hash = new byte[20];
    private long streamId;
    private long streamOffset;
    private long streamSuboffset;
    private boolean includedPunctuation;
    private long fileOffset;
    private final FieldDecoder fieldDecoder;

    EventData(FieldDecoder fieldDecoder) {
        this.fieldDecoder = fieldDecoder;
    }

    void reset() {
        this.streamSuboffset = 0L;
        this.streamOffset = 0L;
        this.streamId = 0L;
        this.encodedSubseconds = 0L;
        this.indexTime = 0L;
        this.metaInfo = null;
        this.rawContents = null;
        Arrays.fill(this.hash, (byte)0);
        this.includedPunctuation = false;
        this.estorage = null;
    }

    public byte[] getRawContents() {
        return this.rawContents;
    }

    public long getEventTime() {
        return this.fieldDecoder.getTime();
    }

    public String getHost() {
        return this.fieldDecoder.getHost();
    }

    public String getSource() {
        return this.fieldDecoder.getSource();
    }

    public String getSourcetype() {
        return this.fieldDecoder.getSourcetype();
    }

    public Map<String, Object> getFields() {
        return this.fieldDecoder.convertMetainfo(this.metaInfo, this.rawContents, this.estorage);
    }

    public long getIndexTime() {
        return this.indexTime;
    }

    public long getEncodedSubseconds() {
        return this.encodedSubseconds;
    }

    public String getTimeString() {
        StringBuffer val = new StringBuffer();
        val.append(this.getEventTime());
        if (0L < this.encodedSubseconds) {
            val.append('.');
            while ((this.encodedSubseconds & 1L) == 0L) {
                val.append('0');
                this.encodedSubseconds >>= 1;
            }
            val.append(this.encodedSubseconds >> 1);
        }
        return val.toString();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public long getStreamOffset() {
        return this.streamOffset;
    }

    public long getStreamSuboffset() {
        return this.streamSuboffset;
    }

    public boolean isIncludedPunctuation() {
        return this.includedPunctuation;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public byte[] getEstorage() {
        return this.estorage;
    }

    void setRawContents(byte[] rawContents) {
        this.rawContents = rawContents;
    }

    void setMetaInfo(PrimitiveLongList metaInfo) {
        this.metaInfo = metaInfo;
    }

    void setIndexTime(long indexTime) {
        this.indexTime = indexTime;
    }

    void setEncodedSubseconds(long encodedSubseconds) {
        this.encodedSubseconds = encodedSubseconds;
    }

    void setHash(byte[] hash) {
        this.hash = hash;
    }

    void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    void setStreamOffset(long streamOffset) {
        this.streamOffset = streamOffset;
    }

    void setStreamSuboffset(long streamSuboffset) {
        this.streamSuboffset = streamSuboffset;
    }

    void setIncludedPunctuation(boolean includedPunctuation) {
        this.includedPunctuation = includedPunctuation;
    }

    void setFileOffset(long fileOffset) {
        this.fileOffset = fileOffset;
    }

    public void setEstorage(byte[] estorage) {
        this.estorage = estorage;
    }
}

