/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datamodel;

import com.splunk.datasource.Field;
import com.splunk.datasource.WriterFactory;
import com.splunk.mr.SplunkMR;
import com.splunk.mr.input.VirtualIndex;
import com.splunk.sdk.SplunkMiniSDK;
import com.splunk.util.StrUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class DataModelEvaluator {
    private static Logger gLogger = Logger.getLogger(DataModelEvaluator.class);
    private String appName;
    private String modelName;
    private SplunkMiniSDK sdk;
    private boolean parsed;
    private Configuration conf;

    public DataModelEvaluator(Configuration conf, String appName, String modelName) {
        this.conf = conf;
        this.appName = appName;
        this.modelName = modelName;
        this.sdk = SplunkMiniSDK.createForSearch(conf);
    }

    public void setSdk(SplunkMiniSDK sdk) {
        this.sdk = sdk;
    }

    public void parseModel(String provider) throws IOException {
        if (this.parsed) {
            return;
        }
        ObjectMapper om = new ObjectMapper();
        SplunkMiniSDK.SplunkResponse sr = this.sdk.get("/services/datamodel/model/" + this.modelName, new String[0]);
        if (sr.getStatusCode() != 200) {
            throw new IOException("Failed to call datamodel endpoint to get data model conf. statusCode=" + sr.getStatusCode() + "url=/services/datamodel/model/" + this.modelName);
        }
        JsonNode jn = sr.firstEntry();
        JsonNode content = jn.get("content");
        String description = content.get("description").getTextValue();
        String accelerationDetails = content.get("acceleration").getTextValue();
        JsonNode accelNode = om.readTree(accelerationDetails);
        String compressionCodec = null;
        Long blockSize = null;
        String accelerationFileFormat = "orc";
        if (accelNode.get("hunk.compression_codec") != null) {
            compressionCodec = accelNode.get("hunk.compression_codec").getTextValue();
        }
        if (accelNode.get("hunk.dfs_block_size") != null) {
            blockSize = accelNode.get("hunk.dfs_block_size").getLongValue();
        }
        if (accelNode.get("hunk.file_format") != null && !accelNode.get("hunk.file_format").getTextValue().isEmpty()) {
            accelerationFileFormat = accelNode.get("hunk.file_format").getTextValue();
        }
        gLogger.debug((Object)("description=" + description));
        Map dm = (Map)om.readValue(description.getBytes(StrUtil.UTF8), Map.class);
        gLogger.debug((Object)("dm=" + dm));
        WriterFactory.Format format = WriterFactory.Format.valueOf(accelerationFileFormat);
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        List<String> requiredFields = VirtualIndex.getFieldsFromSearchPipeline(this.conf);
        ArrayList<Field> fieldList = new ArrayList<Field>();
        List objects = (List)dm.get("objects");
        for (Iterator object : objects) {
            String objectName = object.get("objectName").toString();
            String parentName = object.get("parentName").toString();
            List fields = (List)object.get("fields");
            Object cal = object.get("calculations");
            if (cal != null) {
                for (Map c : (List)cal) {
                    if (!c.containsKey("outputFields")) continue;
                    for (Map of : (List)c.get("outputFields")) {
                        fields.add(of);
                    }
                }
            }
            if (parentName.equals("BaseEvent")) {
                prefixMap.put(objectName, objectName);
            } else if (prefixMap.containsKey(parentName)) {
                prefixMap.put(objectName, (String)prefixMap.get(parentName) + "." + objectName);
            } else {
                throw new IllegalStateException("Invalid data model");
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("add an entry to prefixMap, key=" + objectName + ", val=" + (String)prefixMap.get(objectName)));
            }
            for (Map field : fields) {
                String[] ownerFragments;
                String ownerLastFragment;
                String fieldName = field.get("fieldName").toString();
                String fieldType = field.get("type").toString();
                String owner = field.get("owner").toString();
                boolean hidden = StrUtil.parseBoolean(field.get("hidden").toString(), false);
                boolean required = StrUtil.parseBoolean(field.get("required").toString(), false);
                if (gLogger.isDebugEnabled()) {
                    gLogger.debug((Object)("objectName=" + objectName + ", parentName=" + parentName + ", fieldName=" + fieldName + ", fieldType=" + fieldType + ", owner=" + owner + ", hidden=" + hidden + ", required=" + required));
                }
                String string = ownerLastFragment = (ownerFragments = owner.split("\\.")).length > 1 ? ownerFragments[ownerFragments.length - 1] : owner;
                if (hidden || !ownerLastFragment.equals(objectName) || fieldType.equals("objectCount") || fieldType.equals("childCount")) {
                    if (!gLogger.isDebugEnabled()) continue;
                    gLogger.debug((Object)("Skipped a data model field, fieldName=" + fieldName + ", fieldType=" + fieldType + ", hidden=" + hidden + ", owner=" + owner));
                    continue;
                }
                Field.FieldType type = Field.FieldType.STRING;
                if (fieldType.equals("boolean")) {
                    type = Field.FieldType.BOOLEAN;
                }
                if (prefixMap.get(objectName) != null) {
                    fieldName = (String)prefixMap.get(objectName) + "." + fieldName;
                }
                requiredFields.remove(fieldName);
                Field.Repetition repetition = Field.Repetition.OPTIONAL;
                fieldList.add(new Field(fieldName, type, repetition));
            }
        }
        Object[] skipFieldsArray = new String[]{"_raw", "_cd", "_bkt", "index", "host", "source"};
        for (String fieldName : requiredFields) {
            if (ArrayUtils.contains((Object[])skipFieldsArray, (Object)fieldName)) continue;
            if (fieldName.equals("nodename")) {
                fieldList.add(new Field(fieldName, Field.FieldType.STRING, Field.Repetition.REPEATED));
                continue;
            }
            fieldList.add(new Field(fieldName, Field.FieldType.STRING, Field.Repetition.OPTIONAL));
        }
        for (Field f : fieldList) {
            columnNames.append(f.getFieldName()).append(",");
            if (f.getFieldType().equals((Object)Field.FieldType.BOOLEAN)) {
                columnTypes.append("boolean").append(":");
                continue;
            }
            if (f.getRepetition() == Field.Repetition.REPEATED) {
                columnTypes.append("array<string>:");
                continue;
            }
            columnTypes.append("string").append(":");
        }
        ObjectMapper mapper = new ObjectMapper();
        this.conf.set(SplunkMR.CONF_DATASOURCE_SCHEMA, mapper.writeValueAsString(fieldList));
        try {
            sr = this.sdk.get("/servicesNS/nobody/search/storage/collections/data/hunk_dma_metadata/" + this.appName + "_" + this.modelName, new String[0]);
        }
        catch (SplunkMiniSDK.SplunkResponseException sre) {
            sr = sre.getResponse();
        }
        if (sr.getStatusCode() == 404) {
            ObjectNode dmMetadataNode = mapper.createObjectNode();
            dmMetadataNode.put("_key", this.appName + "_" + this.modelName);
            if (compressionCodec != null) {
                dmMetadataNode.put("compressionCodec", compressionCodec);
            }
            if (blockSize != null) {
                dmMetadataNode.put("blockSize", blockSize.longValue());
            }
            if (accelerationFileFormat != null) {
                dmMetadataNode.put("accelerationFileFormat", accelerationFileFormat);
            }
            if (format == WriterFactory.Format.orc) {
                columnNames.deleteCharAt(columnNames.length() - 1);
                columnTypes.deleteCharAt(columnTypes.length() - 1);
                dmMetadataNode.put("tablename", SplunkMR.getDataModelSummaryId(this.conf));
                dmMetadataNode.put("columnnames", columnNames.toString());
                dmMetadataNode.put("columntypes", columnTypes.toString());
            }
            try {
                this.sdk.postJSON("/servicesNS/nobody/search/storage/collections/data/hunk_dma_metadata", dmMetadataNode.toString());
            }
            catch (IOException exc) {
                gLogger.error((Object)"Exception caught while trying to update dma metadata collection!!", (Throwable)exc);
                throw exc;
            }
        }
        this.updateConfWithDMProps(blockSize, compressionCodec, accelerationFileFormat);
    }

    public void setDataModelProperties(Configuration conf, String appAndDMName) throws IOException {
        String dmPrefix = "vix.splunk.search.datamodel." + appAndDMName;
        String compressionCodec = null;
        Long blockSize = 0L;
        String accelerationFileFormat = null;
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode queryNode = objectMapper.createObjectNode();
        queryNode.put("_key", appAndDMName);
        JsonNode dmMetadatNode = null;
        try {
            SplunkMiniSDK.SplunkResponse sr = this.sdk.get("/servicesNS/nobody/search/storage/collections/data/hunk_dma_metadata", "query", queryNode.toString());
            ArrayNode resultsNode = (ArrayNode)sr.raw();
            if (resultsNode.size() != 0) {
                dmMetadatNode = resultsNode.get(0);
                if (dmMetadatNode.get("blockSize") != null) {
                    blockSize = dmMetadatNode.get("blockSize").getValueAsLong();
                }
                if (dmMetadatNode.get("compressionCodec") != null) {
                    compressionCodec = dmMetadatNode.get("compressionCodec").getTextValue();
                }
                if (dmMetadatNode.get("accelerationFileFormat") != null) {
                    accelerationFileFormat = dmMetadatNode.get("accelerationFileFormat").getTextValue();
                }
                if (accelerationFileFormat.equals("orc")) {
                    String hivePrefix = "splunk.search.splitter.hive.";
                    String tableName = dmMetadatNode.get("tablename").getTextValue();
                    String columnNames = dmMetadatNode.get("columnnames").getTextValue();
                    String columnTypes = dmMetadatNode.get("columntypes").getTextValue();
                    if (tableName == null || columnNames == null || columnTypes == null) {
                        throw new RuntimeException("Invalid DMA Metadata found for " + appAndDMName + ". TableName, ColumnNames and ColumnTypes are required metadata for orc files.");
                    }
                    conf.set(hivePrefix + "tablename", tableName);
                    conf.set(hivePrefix + "columnnames", columnNames);
                    conf.set(hivePrefix + "columntypes", columnTypes);
                    conf.set(hivePrefix + "fileformat", "orc");
                }
                this.updateConfWithDMProps(blockSize, compressionCodec, accelerationFileFormat);
            }
        }
        catch (IOException exc) {
            gLogger.error((Object)"Exception caught while trying to get dma metadata from KV store!!", (Throwable)exc);
            throw exc;
        }
    }

    private void updateConfWithDMProps(Long blockSize, String compressionCodec, String accelerationFileFormat) {
        if (blockSize != null && blockSize >= 0x2000000L) {
            this.conf.setLong("dfs.block.size", blockSize.longValue());
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("set dfs.block.size=" + blockSize + " for data model " + this.appName + "_" + this.modelName));
            }
        } else {
            gLogger.warn((Object)("dfs.block.size is ignored. It must be at least 32MB. blockSize=" + blockSize));
        }
        if (compressionCodec != null) {
            this.conf.set(SplunkMR.CONF_DATAMODEL_COMPRESSION_CODEC, compressionCodec);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("set compression_codec=" + compressionCodec + " for data model " + this.appName + "_" + this.modelName));
            }
        }
        if (accelerationFileFormat != null) {
            this.conf.set(SplunkMR.CONF_DATASOURCE_FORMAT, accelerationFileFormat);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("set acceleration_file_format=" + accelerationFileFormat + " for data model " + this.appName + "_" + this.modelName));
            }
        } else {
            this.conf.setBoolean(SplunkMR.CONF_DATAMODEL_READ, false);
        }
    }
}

