/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.collect;

import com.splunk.collect.AbstractEventWriter;
import com.splunk.collect.EventWriterUtil;
import com.splunk.s2s.Channel;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class AvroEventWriter
extends AbstractEventWriter {
    private static Logger gLogger = Logger.getLogger(AvroEventWriter.class);
    public static final Schema schema;
    private DataFileWriter<GenericRecord> writer;
    private FSDataOutputStream out;
    private GenericRecord event;
    private Path currentFile;
    private Path outputDir;
    private Configuration conf;
    private CodecFactory codec;
    private String compressionCodec;
    private Map<String, String> others = new HashMap<String, String>();
    private boolean renameOnClose;

    public AvroEventWriter(Configuration conf, Path outputDir, String compressionCodec, boolean renameOnClose) throws IOException {
        super(false);
        this.outputDir = outputDir;
        this.conf = conf;
        this.compressionCodec = compressionCodec;
        this.renameOnClose = renameOnClose;
    }

    @Override
    public String getName() {
        return "avro";
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.writer);
        IOUtils.closeQuietly((OutputStream)this.out);
        EventWriterUtil.postCloseCleanup(this.conf, this.currentFile, this.getRawEventBytes(), this.getEventCount(), this.renameOnClose);
    }

    @Override
    protected void commitImpl() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.flush();
            this.out.sync();
            this.writer.flush();
            this.writer.sync();
        }
        catch (IOException e) {
            gLogger.error((Object)"Error while committing", (Throwable)e);
        }
    }

    private void init(Event e) throws IOException {
        if (this.writer != null) {
            return;
        }
        String codecFileExt = "";
        if ("snappy".equals(this.compressionCodec)) {
            this.codec = CodecFactory.snappyCodec();
            codecFileExt = ".snappy";
        } else if ("bzip2".equals(this.compressionCodec) || "bzip".equals(this.compressionCodec)) {
            this.codec = CodecFactory.bzip2Codec();
            codecFileExt = ".bz2";
        } else if ("deflate".equals(this.compressionCodec)) {
            this.codec = CodecFactory.deflateCodec((int)-1);
            codecFileExt = ".deflate";
        }
        StringBuilder name = new StringBuilder();
        name.append(e.isParsedEvent() ? "hunk_pv1" : "hunk_rv1");
        name.append('_').append(System.currentTimeMillis());
        name.append(codecFileExt);
        name.append(".avro");
        if (this.renameOnClose) {
            name.append(".tmp");
        }
        this.currentFile = new Path(this.outputDir, name.toString());
        this.out = this.outputDir.getFileSystem(this.conf).create(this.currentFile);
        this.event = new GenericData.Record(schema);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        this.writer = new DataFileWriter((DatumWriter)datumWriter);
        if (this.codec != null) {
            this.writer.setCodec(this.codec);
        }
        this.writer.create(schema, (OutputStream)this.out);
    }

    @Override
    protected void addEventImpl(Event e) throws IOException {
        this.init(e);
        this.event.put("_raw", (Object)e.getRaw().toString());
        this.event.put("_time", (Object)e.getNonNullTime().toString());
        Channel c = e.getChannel();
        this.event.put("host", (Object)(c.getHost() == null ? "" : c.getHost()));
        this.event.put("source", (Object)(c.getSource() == null ? "" : c.getSource()));
        this.event.put("sourcetype", (Object)(c.getSourcetype() == null ? "" : c.getSourcetype()));
        if (c.getExtra() != null) {
            this.event.put("extra", (Object)c.getExtra());
        } else {
            this.event.put("extra", null);
        }
        this.event.put("forwardhost", (Object)(c.getFwdSignature().getHostname() + ":" + c.getFwdSignature().getPort()));
        if (!e.getFields().isEmpty()) {
            this.others.clear();
            for (Event.KVPair kv : e.getFields()) {
                String k = kv._key.toString();
                if (k.charAt(0) == '_') continue;
                S2SValue v = kv._val;
                if (v.isNumber()) {
                    Number n = v.asNumber();
                    this.others.put(k, String.valueOf(n.longValue()));
                    continue;
                }
                this.others.put(k, v.toString());
            }
        }
        this.event.put("others", this.others);
        this.writer.append((Object)this.event);
    }

    static {
        String s = "{\"namespace\": \"com.splunk.collect\",\"type\": \"record\",\"name\": \"HunkEvent\",\"fields\":[{\"name\": \"_raw\", \"type\": \"string\"},{\"name\": \"host\", \"type\": \"string\"},{\"name\": \"source\", \"type\": \"string\"},{\"name\": \"sourcetype\", \"type\": \"string\"},{\"name\": \"extra\", \"type\": [\"string\", \"null\"]},{\"name\": \"_time\", \"type\": \"string\"},{\"name\": \"forwardhost\", \"type\": \"string\"},{\"name\": \"others\", \"type\": [{\"type\": \"map\", \"values\": \"string\"}, \"null\"]}]}";
        schema = new Schema.Parser().parse(s);
    }
}

