/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.datamodel;

import com.splunk.datamodel.DataModelBucket;
import com.splunk.sdk.SplunkMiniSDK;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class DataModelBuckets {
    private static Logger gLogger = Logger.getLogger(DataModelBuckets.class);
    private Map<String, DataModelBucket> buckets = new HashMap<String, DataModelBucket>();
    private String summaryId;
    private DMASummaryMetadata summaryMetadata = null;
    private SplunkMiniSDK sdk;

    public DataModelBuckets(String summaryId, Configuration conf) {
        this.summaryId = summaryId;
        this.sdk = SplunkMiniSDK.createForSearch(conf);
    }

    public static String getBucketKey(String indexName, String bucketId) {
        return indexName + "+" + bucketId;
    }

    public void initForBucket(FileSystem fs, Configuration conf, String indexName, String bucketId, boolean writeToDM) throws FileNotFoundException, IOException {
        String bucketKey = DataModelBuckets.getBucketKey(indexName, bucketId);
        if (this.buckets.containsKey(bucketKey)) {
            return;
        }
        gLogger.info((Object)String.format("Initializing bucket for bucketKey=%s", bucketKey));
        this.buckets.put(bucketKey, new DataModelBucket(fs, conf, indexName, bucketId, writeToDM, this));
    }

    public FileStatus retrieveFromCache(String bucketKey, Path originalFile, long earliestTime, long latestTime) {
        DataModelBucket b = this.buckets.get(bucketKey);
        if (b == null) {
            return null;
        }
        return b.retrieveFromCache(originalFile, earliestTime, latestTime);
    }

    public void updateOrigDataSizeMap(String bucketKey, FileStatus origFile, long et, long lt) {
        DataModelBucket b = this.buckets.get(bucketKey);
        b.updateOrigDataSizeMap(origFile, et, lt);
    }

    public void loadBucketMetadata(String bucketKey) throws IOException {
        if (this.summaryMetadata == null) {
            gLogger.info((Object)"Caching Summary Metadata");
            this.loadSummaryStatsFromKvstore();
        }
        DataModelBucket b = this.buckets.get(bucketKey);
        b.setBucketMetadata(this.summaryMetadata.getBucketMetadata(bucketKey));
    }

    public void loadSummaryStatsFromKvstore() throws IOException {
        try {
            SplunkMiniSDK.SplunkResponse sr = this.sdk.get("/servicesNS/nobody/search/storage/collections/data/HunkDMAStats/" + this.summaryId, new String[0]);
            this.summaryMetadata = new DMASummaryMetadata((ObjectNode)sr.raw());
            gLogger.info((Object)("Load DMA summary item from kvstore with summary_id=" + this.summaryId));
        }
        catch (SplunkMiniSDK.SplunkResponseException sre) {
            if (sre.getResponse().getStatusCode() == 404) {
                gLogger.debug((Object)("Creating new DMA summary item for summary_id=" + this.summaryId));
                this.summaryMetadata = new DMASummaryMetadata();
            }
            gLogger.error((Object)("Unable to get DMA summary item for summary_id=" + this.summaryId));
        }
    }

    public void updateKvstoreWithSummaryStats() {
        gLogger.info((Object)("Updating KV Store DMA Summary Stats collection for summaryId=" + this.summaryId));
        try {
            String data = this.summaryMetadata.getJson().toString();
            String endpoint = "/servicesNS/nobody/search/storage/collections/data/HunkDMAStats";
            SplunkMiniSDK.SplunkResponse sr = this.sdk.postJSON(endpoint, this.summaryMetadata.getJson().toString());
        }
        catch (Exception ex) {
            gLogger.error((Object)("Exception caught while trying to update DMA Summary Stats collection: " + ex.toString()), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void updateSummaryStats(String bucketKey, Map<String, String> bucketMetaMap) {
        this.summaryMetadata.setBucketMetadata(bucketKey, bucketMetaMap);
    }

    public void finalizeDataModelFiles() throws FileNotFoundException, IOException {
        gLogger.debug((Object)("buckets are:" + this.buckets.keySet().toString()));
        for (DataModelBucket b : this.buckets.values()) {
            b.finalizeDataModelFile();
        }
        if (this.summaryMetadata != null) {
            this.updateKvstoreWithSummaryStats();
        }
    }

    public static boolean deleteKVStoreEntry(Configuration conf, String appAndDMName) {
        SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(conf);
        try {
            sdk.delete("/servicesNS/nobody/search/storage/collections/config/hunk_dma_" + appAndDMName, new String[0]);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Successfully deleted KV Store collection /servicesNS/nobody/search/storage/collections/data/hunk_dma_" + appAndDMName));
            }
            return true;
        }
        catch (SplunkMiniSDK.SplunkResponseException sre) {
            gLogger.error((Object)("Exception caught while trying to delete dma collection!! " + sre.getResponse()));
            gLogger.error((Object)sre);
            return false;
        }
        catch (IOException ioe) {
            gLogger.error((Object)"IOException caught while trying to delete dma collection!!", (Throwable)ioe);
            return false;
        }
    }

    public static boolean deleteDMMetadata(Configuration conf, String appAndDMName) {
        SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(conf);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode queryNode = objectMapper.createObjectNode();
        queryNode.put("_key", appAndDMName);
        try {
            sdk.delete("/servicesNS/nobody/search/storage/collections/data/hunk_dma_metadata", "query", queryNode.toString());
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Successfully deleted Metadata entries in KV Store for DM " + appAndDMName));
            }
            return true;
        }
        catch (IOException ioe) {
            gLogger.error((Object)"IOException caught while trying to delete dma collection!!", (Throwable)ioe);
            return false;
        }
    }

    public static void deleteKVStoreSummaryStatEntry(Configuration conf, String id) {
        SplunkMiniSDK sdk = SplunkMiniSDK.createForSearch(conf);
        try {
            sdk.delete("/servicesNS/nobody/search/storage/collections/data/HunkDMAStats/" + id, new String[0]);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Successfully deleted Summary Stat Entry from KV Store for summaryId=" + id));
            }
        }
        catch (Exception ex) {
            gLogger.error((Object)("Exception caught while trying to delete summary stat entry:" + ex.toString()), (Throwable)ex);
        }
    }

    class DMASummaryMetadata {
        Map<String, Map<String, String>> bucketsMap = new HashMap<String, Map<String, String>>();

        DMASummaryMetadata(ObjectNode node) {
            JsonNode bucketArray = node.get("buckets");
            for (JsonNode jsonNode : bucketArray) {
                HashMap<String, String> bucketMap = new HashMap<String, String>();
                bucketMap.put("bucket_path", jsonNode.get("bucket_path").getTextValue());
                bucketMap.put("bucket_et", jsonNode.get("bucket_et").getTextValue());
                bucketMap.put("bucket_lt", jsonNode.get("bucket_lt").getTextValue());
                bucketMap.put("bucket_size", jsonNode.get("bucket_size").getTextValue());
                bucketMap.put("summary_complete", jsonNode.get("summary_complete").getTextValue());
                bucketMap.put("summary_size", jsonNode.get("summary_size").getTextValue());
                bucketMap.put("summary_path", jsonNode.get("summary_path").getTextValue());
                String bucketId = jsonNode.get("bucket_id").getTextValue();
                String indexName = jsonNode.get("index").getTextValue();
                this.bucketsMap.put(DataModelBuckets.getBucketKey(indexName, bucketId), bucketMap);
            }
        }

        DMASummaryMetadata() {
        }

        public Map<String, String> getBucketMetadata(String bucketKey) {
            return this.bucketsMap.get(bucketKey);
        }

        public void setBucketMetadata(String bucketKey, Map<String, String> bucketMap) {
            gLogger.debug((Object)("Update Summary Metadata: bucketKey=" + bucketKey + " bucketMap=" + bucketMap.toString()));
            this.bucketsMap.put(bucketKey, bucketMap);
        }

        public ObjectNode getJson() {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode stats = objectMapper.createObjectNode();
            stats.put("_key", DataModelBuckets.this.summaryId);
            ArrayNode bucketArray = stats.putArray("buckets");
            for (Map.Entry<String, Map<String, String>> entry : this.bucketsMap.entrySet()) {
                ObjectNode bucketNode = objectMapper.createObjectNode();
                String[] bucketIndexAndId = entry.getKey().split("\\+");
                bucketNode.put("index", bucketIndexAndId[0]);
                bucketNode.put("bucket_id", bucketIndexAndId[1]);
                Map<String, String> b = entry.getValue();
                bucketNode.put("bucket_path", b.get("bucket_path"));
                bucketNode.put("bucket_et", b.get("bucket_et"));
                bucketNode.put("bucket_lt", b.get("bucket_lt"));
                bucketNode.put("bucket_size", b.get("bucket_size"));
                bucketNode.put("summary_complete", b.get("summary_complete"));
                bucketNode.put("summary_path", b.get("summary_path"));
                bucketNode.put("summary_size", b.get("summary_size"));
                bucketArray.add((JsonNode)bucketNode);
            }
            return stats;
        }
    }
}

