/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.data_delivery;

import com.splunk.collect.IndexS2SListener;
import com.splunk.data_delivery.ForwardingHandler;
import com.splunk.data_delivery.S2SStreamingRelay;
import com.splunk.io.FastBufferedInputStream;
import com.splunk.s2s.Event;
import com.splunk.s2s.S2SString;
import com.splunk.s2s.StreamingS2S;
import com.splunk.s2s.TCPSignature;
import com.splunk.sdk.SplunkMiniSDK;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;

public class ConnectionHandler
extends Thread {
    private static final Logger gLogger = Logger.getLogger(S2SStreamingRelay.class);
    private static final String TCP_OUT_INFO_URI = "/services/data/outputs/tcp/group";
    private static final Pattern semicolonPattern = Pattern.compile(";");
    private static final Pattern equalsPattern = Pattern.compile("=");
    private static final S2SString capabilitiesKey = new S2SString("__s2s_capabilities");
    private Socket _socket;
    private byte[] _handshakeBytes;
    private StreamingS2S s2s;
    private ForwardingHandler handler;
    private TokenAuthenticator tokenAuthenticator;
    private final S2SString tokenKey = new S2SString("__s2s_token");

    public ConnectionHandler(Socket socket, byte[] bytes, ForwardingHandler handler) {
        this._socket = socket;
        this._handshakeBytes = bytes;
        this.handler = handler;
        this.tokenAuthenticator = new TokenAuthenticator(handler.getSDK(), socket.getLocalPort());
    }

    public void terminate() {
        this.s2s.terminate();
    }

    @Override
    public void run() {
        try {
            this.runImpl();
        }
        catch (Exception e) {
            gLogger.error((Object)"Exception caught while handling connection", (Throwable)e);
        }
        finally {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("ConnectionHandler finished with socket " + this._socket));
            }
            if (null != this._socket) {
                try {
                    this._socket.close();
                }
                catch (IOException ex) {
                    gLogger.warn((Object)"Problem while closing client socket", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws IOException {
        if (this._socket.isClosed()) {
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Socket was closed before it could be handled: " + this._socket));
            }
            return;
        }
        if (gLogger.isDebugEnabled()) {
            gLogger.debug((Object)("Handling connection for socket " + this._socket));
        }
        TCPSignature tcpSig = null;
        InputStream in = null;
        boolean wantsAcks = false;
        IndexS2SListener isl = null;
        try {
            DataOutputStream out = new DataOutputStream(this._socket.getOutputStream());
            out.writeInt(this._handshakeBytes.length);
            out.write(this._handshakeBytes);
            out.flush();
            in = this._socket.getInputStream();
            tcpSig = new TCPSignature();
            tcpSig.readFromS2SV4(in, null);
            Event e1 = Event.readOldS2SEvent(in, null);
            Event e2 = Event.readOldS2SEvent(in, null);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("TCP signature: " + tcpSig));
                gLogger.debug((Object)("Reading event: " + e1));
                gLogger.debug((Object)("Reading event: " + ConnectionHandler.hideToken(e2)));
            }
            if (!this.hasProperToken(e2)) {
                gLogger.warn((Object)"Rejecting connection because it did not present an acceptable token");
                return;
            }
            isl = this.handler.createListener(false, null);
        }
        catch (EOFException ex) {
            String msg = ex.getMessage();
            if (null == msg) {
                msg = "";
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Handled health-check connection from forwarder. " + msg));
            }
            return;
        }
        catch (SocketException ex) {
            String msg = ex.getMessage();
            if (null == msg) {
                msg = "";
            }
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)("Handled health-check connection from forwarder. " + msg));
            }
            return;
        }
        catch (Throwable th) {
            gLogger.error((Object)"Unexpected problem while handling connection from forwarder", th);
            return;
        }
        this.s2s = new StreamingS2S(tcpSig, new FastBufferedInputStream(in, 16384), isl);
        try {
            this.s2s.run();
        }
        finally {
            isl.finish();
        }
    }

    boolean wantsAcknowledgement(Event e) {
        String[] parts;
        String capabilities = this.getField(capabilitiesKey, e);
        if (null == capabilities) {
            return false;
        }
        for (String pt : parts = semicolonPattern.split(capabilities)) {
            String[] subKV = equalsPattern.split(pt);
            if (subKV.length != 2) continue;
            String subkey = subKV[0];
            String subval = subKV[1];
            if (!"ack".equals(subkey) || !"1".equals(subval)) continue;
            return true;
        }
        return false;
    }

    private boolean hasProperToken(Event e) throws IOException {
        String eventToken = this.getField(this.tokenKey, e);
        Set<String> acceptable = this.tokenAuthenticator.getAcceptableTokens();
        if (acceptable.isEmpty()) {
            return true;
        }
        return acceptable.contains(eventToken);
    }

    static String hideToken(Event e) {
        String str = e.toString();
        Matcher m = Pattern.compile("__s2s_token=\"([^\"]*)\"").matcher(str);
        if (m.find()) {
            str = str.substring(0, m.start(1)) + "<REDACTED>" + str.substring(m.end(1));
        }
        return str;
    }

    private String getField(S2SString key, Event e) {
        for (Event.KVPair kv : e.getFields()) {
            if (!key.equals(kv._key)) continue;
            return kv._val.toString();
        }
        return null;
    }

    static class TokenAuthenticator {
        SplunkMiniSDK sdk;
        int localPort;

        public TokenAuthenticator(SplunkMiniSDK sdk, int localPort) {
            this.sdk = sdk;
            this.localPort = localPort;
        }

        public boolean acceptToken(String token) throws IOException {
            Set<String> acceptable = this.getAcceptableTokens();
            if (acceptable.isEmpty()) {
                return true;
            }
            return acceptable.contains(token);
        }

        Set<String> getAcceptableTokens() throws IOException {
            SplunkMiniSDK.SplunkResponse response = null;
            try {
                response = this.sdk.get(ConnectionHandler.TCP_OUT_INFO_URI, new String[0]);
            }
            catch (SplunkMiniSDK.SplunkResponseException ex) {
                gLogger.warn((Object)"Unable to reach endpoint (/services/data/outputs/tcp/group), allowing connection", (Throwable)ex);
                return new HashSet<String>();
            }
            return this.getAcceptableTokens(response);
        }

        Set<String> getAcceptableTokens(SplunkMiniSDK.SplunkResponse response) throws IOException {
            HashSet<String> acceptableTokens = new HashSet<String>();
            Iterator iter = response.entries().getElements();
            while (iter.hasNext()) {
                JsonNode node = (JsonNode)iter.next();
                JsonNode content = node.get("content");
                ArrayNode serversArr = (ArrayNode)content.get("servers");
                if (null == serversArr) continue;
                for (int i = 0; i < serversArr.size(); ++i) {
                    JsonNode tcpOutToken;
                    JsonNode server = serversArr.get(i);
                    String s = server.getTextValue();
                    String[] parts = s.split(":");
                    if (parts.length != 2 || !this.matchesOurHost(parts[0]) || !this.matchesOurPort(parts[1]) || null == (tcpOutToken = content.get("token"))) continue;
                    acceptableTokens.add(tcpOutToken.getTextValue());
                }
            }
            return acceptableTokens;
        }

        boolean matchesOurPort(String port) {
            boolean matches = false;
            try {
                int targetPort = Integer.parseInt(port);
                matches = targetPort == this.localPort;
            }
            catch (NumberFormatException ex) {
                matches = false;
            }
            return matches;
        }

        boolean matchesOurHost(String name) {
            boolean matches = false;
            try {
                InetAddress localAddress = InetAddress.getByName(null);
                InetAddress targetAddress = InetAddress.getByName(name);
                matches = localAddress.equals(targetAddress);
            }
            catch (UnknownHostException ex) {
                matches = false;
            }
            return matches;
        }
    }
}

