#!/bin/sh
#
# This is a simple script to pipe readlog.py output into ausearch -i
# so the log file details are translated.  
# see "man ausearch"
#
# run readlog.py | ausearch | Grep off lines with ----
#

. `dirname $0`/common.sh

if [ "x$KERNEL" = "xLinux" ] ; then
	assertInvokerIsSuperuser
	assertHaveCommand service
	assertHaveCommandGivenPath /sbin/ausearch
	if [ -n "`service auditd status`" -a "$?" -eq 0 ] ; then
		`dirname $0`/readlog.py -s /tmp/seekposition -f /var/log/audit/audit.log | tee $TEE_DEST | /sbin/ausearch -i 2>/dev/null | grep -v '^----'
	fi
elif [ "x$KERNEL" = "xSunOS" ] ; then
	:
elif [ "x$KERNEL" = "xDarwin" ] ; then
	:
elif [ "x$KERNEL" = "xFreeBSD" ] ; then
	:
fi
