/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.PathResolver;
import com.splunk.roll.PathResolverV2;
import com.splunk.roll.util.Time;
import com.splunk.roll.util.TimeRange;
import com.splunk.util.LazySeq;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class PathResolverV3
extends PathResolverV2 {
    public static final int VERSION = 3;
    private static final TimeUnit MILLIS = TimeUnit.MILLISECONDS;

    public PathResolverV3(Path rollRoot, PathResolverV2.GroupSeqFactory bucketGroups, long groupSize, Time minFirstLevelLength) {
        super(rollRoot, bucketGroups, groupSize, minFirstLevelLength, 3);
    }

    @Override
    protected TimeRange getBucketGroupRange(TimeRange bucketRange, LazySeq<Time> groupSeq) {
        TimeRange tr = null;
        while (tr == null) {
            tr = super.getBucketGroupRange(bucketRange, groupSeq);
            if (PathResolverV3.isWithinTimeRange(tr, bucketRange)) continue;
            tr = null;
            boolean hadMore = groupSeq.hasMoreUnchecked();
            if (hadMore) continue;
            throw new IllegalStateException("GroupSeq should be an infinite sequence.");
        }
        return tr;
    }

    public static boolean isWithinTimeRange(TimeRange range, TimeRange bucketRange) {
        boolean earlyMatch = bucketRange.getLow(MILLIS) >= range.getLow(MILLIS);
        boolean lateMatch = bucketRange.getHigh(MILLIS) <= range.getHigh(MILLIS);
        return earlyMatch && lateMatch;
    }

    public static PathResolver createWithDefaults(Path rollRoot, Configuration conf) {
        Time secondGroupTimeLength = new Time(conf.getLong("roll.pathresolver2.min.second.level.length.secs", DEFAULT_MIN_SECOND_LEVEL_TIME_LENGTH_SECS), TimeUnit.SECONDS);
        Time minFirstLevelLength = new Time(conf.getLong("roll.pathresolver2.min.first.level.length.secs", DEFAULT_MIN_FIRST_LEVEL_LENGTH_SECS), TimeUnit.SECONDS);
        int groupSizeMultiplier = conf.getInt("roll.pathresolver2.group.size.multiplier", 1);
        return new PathResolverV3(rollRoot, PathResolverV3.getDefaultBucketGroups(secondGroupTimeLength, 2), groupSizeMultiplier, minFirstLevelLength);
    }
}

