/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.roll;

import com.splunk.roll.Bucket;
import com.splunk.roll.BucketName;
import com.splunk.roll.PathResolver;
import com.splunk.roll.util.GeometricSeries;
import com.splunk.roll.util.PathFilterU;
import com.splunk.roll.util.Time;
import com.splunk.roll.util.TimeRange;
import com.splunk.util.LazySeq;
import com.splunk.util.PathGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.log4j.Logger;

public class PathResolverV2
extends PathResolver {
    private static final Logger gLogger = Logger.getLogger(PathResolverV2.class);
    protected static final String CONF_MIN_FIRST_LEVEL_LENGTH_SECS = "roll.pathresolver2.min.first.level.length.secs";
    protected static final String CONF_MIN_SECOND_LEVEL_TIME_LENGTH_SECS = "roll.pathresolver2.min.second.level.length.secs";
    protected static final String CONF_GROUP_SIZE_MULTIPLIER = "roll.pathresolver2.group.size.multiplier";
    public static final long DEFAULT_MIN_FIRST_LEVEL_LENGTH_SECS = new Time(864000000L, TimeUnit.MILLISECONDS).getAs(TimeUnit.SECONDS);
    public static final long DEFAULT_MIN_SECOND_LEVEL_TIME_LENGTH_SECS = new Time(86400000L, TimeUnit.MILLISECONDS).getAs(TimeUnit.SECONDS);
    public static final int DEFAULT_GROUP_SIZE_MULTIPLIER = 1;
    protected static final int GEOMETRIC_GROUP_DIFFERENCE_RATIO = 2;
    public static final int VERSION = 2;
    private final GroupSeqFactory groupFactory;
    private final long groupSize;
    private final Time minFirstLevelLength;

    public PathResolverV2(Path rollRoot, GroupSeqFactory bucketGroups, long groupSize, Time minFirstLevelLength, int version) {
        super(rollRoot, version);
        this.groupFactory = bucketGroups;
        this.groupSize = groupSize;
        this.minFirstLevelLength = minFirstLevelLength;
    }

    @Override
    protected String doResolvePath(Bucket b, String versionedRoot) {
        return versionedRoot + "/" + b.getIndex() + "/" + b.getServerGuid() + "/" + this.getBucketGroupDirectories(b) + "/" + PathResolver.getNormalizedBucketName(b.getName());
    }

    private String getBucketGroupDirectories(Bucket b) {
        TimeRange bucketGroupRange = this.getBucketGroupRange(b.getTimeRange(), this.groupFactory.createGroupSeq());
        int multiplierForFindingSmallestLargeGroup = 1;
        LazySeq<Time> groupsLargeEnoughForBeingFirstLevelGroups = PathResolverV2.dropSmallGroups(this.groupFactory.createGroupSeq(), this.minFirstLevelLength.getTime(), multiplierForFindingSmallestLargeGroup);
        TimeRange firstLevelRange = this.getBucketGroupRange(bucketGroupRange, groupsLargeEnoughForBeingFirstLevelGroups);
        return this.toPath(firstLevelRange) + "/" + this.toPath(bucketGroupRange);
    }

    String toPath(TimeRange bucketGroupRange) {
        return bucketGroupRange.getHigh(TimeUnit.SECONDS) + "_" + bucketGroupRange.getLow(TimeUnit.SECONDS);
    }

    static TimeRange fromPath(String pathedTimeRange) {
        String[] highLow = pathedTimeRange.split("_");
        return new TimeRange(Long.parseLong(highLow[0]), Long.parseLong(highLow[1]), TimeUnit.SECONDS);
    }

    protected TimeRange getBucketGroupRange(TimeRange bucketRange, LazySeq<Time> groupSeq) {
        Time modTime = PathResolverV2.findGroup(bucketRange, groupSeq, this.groupSize);
        return this.getTimeRangeForModTimeGroup(bucketRange, modTime);
    }

    private TimeRange getTimeRangeForModTimeGroup(TimeRange bucketRange, Time modTime) {
        long modTimeMillis = modTime.getTime();
        long multiplier = bucketRange.getLow().getTime() / modTimeMillis;
        long timeRangeEt = multiplier * modTimeMillis;
        long timeRangeLt = timeRangeEt + modTimeMillis;
        return new TimeRange(timeRangeLt, timeRangeEt, TimeUnit.MILLISECONDS);
    }

    private static long getLength(TimeRange range) {
        return range.getHigh().getTime() - range.getLow().getTime();
    }

    public static Time findGroup(TimeRange range, LazySeq<Time> groups, long rangeMultiplier) {
        long bucketLength = PathResolverV2.getLength(range);
        LazySeq<Time> largeGroups = PathResolverV2.dropSmallGroups(groups, bucketLength, rangeMultiplier);
        return PathResolverV2.doFindGroup(range, bucketLength, largeGroups);
    }

    public static LazySeq<Time> dropSmallGroups(LazySeq<Time> groups, long rangeLength, long lengthMultiplier) {
        if (groups.getHead() == null) {
            groups.hasMoreUnchecked();
        }
        while (groups.getHead().getTime() < rangeLength * lengthMultiplier && groups.hasMoreUnchecked()) {
        }
        return PathResolverV2.guardAgainstRunningOutOfGroups(groups);
    }

    private static LazySeq<Time> guardAgainstRunningOutOfGroups(LazySeq<Time> groups) {
        if (groups.getHead() != null) {
            return groups;
        }
        return new LazySeq.Once<Time>(Arrays.asList(new Time(Long.MAX_VALUE, Time.UNIT)));
    }

    private static Time doFindGroup(TimeRange bucketRange, long bucketLength, LazySeq<Time> group) {
        long offset = bucketRange.getLow().getTime() % group.getHead().getTime();
        while (group.getHead().getTime() < offset + bucketLength && group.hasMoreUnchecked()) {
        }
        return PathResolverV2.guardAgainstRunningOutOfGroups(group).getHead();
    }

    @Override
    protected Iterable<Bucket.RemoteBucket> doResolveBuckets(FileSystem fs, String index, TimeRange range, String versionedRootPath) {
        int levels = 5;
        boolean indexLevel = true;
        int serverGuidLevel = 2;
        int firstGroupRangeLevel = 3;
        int secondGroupRangeLevel = 4;
        int bucketLevel = 5;
        HashMap<Integer, PathFilter> filters = new HashMap<Integer, PathFilter>();
        if (index != null) {
            filters.put(1, new PathFilterU.NameFilter(index));
        }
        filters.put(3, new TimeRangeFilter(range));
        filters.put(4, new TimeRangeFilter(range));
        filters.put(5, new BucketTimeRangeFilter(range));
        final List<LazySeq<FileStatus>> chain = PathGenerator.chain(fs, new Path(versionedRootPath), 5, filters);
        return new LazySeq<Bucket.RemoteBucket>(new LazySeq.Generator<Bucket.RemoteBucket>(){
            final LazySeq<FileStatus> bucketPaths;
            final LazySeq<FileStatus> indexes;
            final LazySeq<FileStatus> serverGuids;
            {
                this.bucketPaths = (LazySeq)chain.get(5);
                this.indexes = (LazySeq)chain.get(1);
                this.serverGuids = (LazySeq)chain.get(2);
            }

            @Override
            public List<Bucket.RemoteBucket> generate() throws IOException {
                if (this.bucketPaths.hasMore()) {
                    FileStatus bucketPath = this.bucketPaths.getHead();
                    FileStatus indexPath = this.indexes.getHead();
                    return Arrays.asList(new Bucket.RemoteBucket(bucketPath.getPath(), PathResolverV2.getBucketNameFromPath(bucketPath.getPath()), indexPath.getPath().getName(), this.serverGuids.getHead().getPath().getName()));
                }
                return Collections.emptyList();
            }
        });
    }

    private static BucketName getBucketNameFromPath(Path path) {
        return new BucketName(path.getName());
    }

    public static PathResolver createWithDefaults(Path rollRoot, Configuration conf) {
        Time secondGroupTimeLength = new Time(conf.getLong(CONF_MIN_SECOND_LEVEL_TIME_LENGTH_SECS, DEFAULT_MIN_SECOND_LEVEL_TIME_LENGTH_SECS), TimeUnit.SECONDS);
        Time minFirstLevelLength = new Time(conf.getLong(CONF_MIN_FIRST_LEVEL_LENGTH_SECS, DEFAULT_MIN_FIRST_LEVEL_LENGTH_SECS), TimeUnit.SECONDS);
        int groupSizeMultiplier = conf.getInt(CONF_GROUP_SIZE_MULTIPLIER, 1);
        return new PathResolverV2(rollRoot, PathResolverV2.getDefaultBucketGroups(secondGroupTimeLength, 2), groupSizeMultiplier, minFirstLevelLength, 2);
    }

    public static GroupSeqFactory getDefaultBucketGroups(final Time startTime, final int ratio) {
        return new GroupSeqFactory(){

            @Override
            public LazySeq<Time> createGroupSeq() {
                return new GeometricSeries(startTime, ratio);
            }
        };
    }

    public static interface GroupSeqFactory {
        public LazySeq<Time> createGroupSeq();
    }

    private static class BucketTimeRangeFilter
    implements PathFilter {
        private TimeRange range;

        public BucketTimeRangeFilter(TimeRange range) {
            this.range = range;
        }

        public boolean accept(Path path) {
            BucketName bucketName = PathResolverV2.getBucketNameFromPath(path);
            return new Bucket(bucketName, null, null).getTimeRange().overlaps(this.range);
        }
    }

    private static class TimeRangeFilter
    implements PathFilter {
        private TimeRange range;

        public TimeRangeFilter(TimeRange range) {
            this.range = range;
        }

        public boolean accept(Path path) {
            try {
                return PathResolverV2.fromPath(path.getName()).overlaps(this.range);
            }
            catch (Exception e) {
                gLogger.warn((Object)("Exception when trying to filter directories by time range. Path=" + path + " exception=" + e + ". Won't accept the path and ignore the exception."));
                return false;
            }
        }
    }
}

