/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mr.packaging;

import com.splunk.mr.packaging.ManifestLine;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class TgzCompressor {
    private static final Logger gLogger = Logger.getLogger(TgzCompressor.class);
    private final int longFileMode;
    private TarArchiveOutputStream out;

    public TgzCompressor(int longFileMode) {
        this.longFileMode = longFileMode;
    }

    public void init(OutputStream out) throws IOException {
        this.out = this.wrapTarArchiveOutputStream(out);
        this.out.setLongFileMode(this.longFileMode);
    }

    private TarArchiveOutputStream wrapTarArchiveOutputStream(OutputStream out) throws IOException {
        return new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(out)));
    }

    public void addManifestLine(ManifestLine line) throws IOException {
        TarArchiveEntry entry = this.createEntry(line);
        if (entry.isSymbolicLink() || entry.getFile().exists()) {
            this.addEntry(entry);
            this.writeEntry(entry);
            this.closeEntry();
        } else {
            gLogger.warn((Object)("File that was in manifest did not exist: " + line.getPath()));
        }
    }

    private TarArchiveEntry createEntry(ManifestLine line) {
        TarArchiveEntry entry = this.doCreateEntry(line);
        entry.setMode(this.getCompressLibAdjustedFileMode(line));
        return entry;
    }

    private TarArchiveEntry doCreateEntry(ManifestLine line) {
        if (line.getType().equals((Object)ManifestLine.Type.LINK)) {
            return this.createSymlinkEntry(line);
        }
        return new TarArchiveEntry(line.getFile(), line.getPath());
    }

    private TarArchiveEntry createSymlinkEntry(ManifestLine line) {
        File manifestPath = new File(line.getPath());
        String[] linkSplit = manifestPath.getName().split(" -> ");
        String linkFilename = linkSplit[0];
        String linkPointerName = linkSplit[1];
        File linkFileWithoutArrow = new File(manifestPath.getParentFile(), linkFilename);
        TarArchiveEntry entry = new TarArchiveEntry(linkFileWithoutArrow.getPath(), 50);
        entry.setLinkName(linkPointerName);
        return entry;
    }

    private int getCompressLibAdjustedFileMode(ManifestLine line) {
        if (line.getType().equals((Object)ManifestLine.Type.DIR)) {
            return 16384 + line.getMode();
        }
        return 32768 + line.getMode();
    }

    private void addEntry(TarArchiveEntry entry) throws IOException {
        this.out.putArchiveEntry((ArchiveEntry)entry);
    }

    private void writeEntry(TarArchiveEntry entry) throws FileNotFoundException, IOException {
        if (entry.isFile() && !entry.isSymbolicLink()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(entry.getFile()));
            try {
                IOUtils.copyLarge((InputStream)in, (OutputStream)this.out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private void closeEntry() throws IOException {
        this.out.closeArchiveEntry();
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

