/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.filter.schema;

import com.splunk.filter.schema.SchemaFilter;
import com.splunk.util.WildcardList;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class BaseSchemaFilter<S, F>
implements SchemaFilter<S, F> {
    private static Logger gLogger = Logger.getLogger(BaseSchemaFilter.class);
    protected static final String FILTERED_SCHEMA_NAME = "filtered_schema";
    private static final String DEFAULT_FIELD_DELIMITER = ".";
    private static final String DEFAULT_REPEATABLE_FIELD_NAME_SUFFIX = "{}";
    protected String fieldDelimiter = ".";
    protected String repeatableFieldNameSuffix = "{}";

    public S filter(S schema, WildcardList requiredFields, boolean noMatchReturnAll, boolean matchAllNoFiltering, boolean ignoreRepeatableFieldsSuffix) {
        if (requiredFields.matchesAll() && matchAllNoFiltering) {
            return schema;
        }
        List<F> fields = this.filter(null, schema, requiredFields, ignoreRepeatableFieldsSuffix);
        if (fields.isEmpty()) {
            this.processMatchNothing(schema);
            if (noMatchReturnAll) {
                return schema;
            }
        }
        return this.createSchema(fields);
    }

    public S filter(S schema, WildcardList requiredFields, boolean noMatchReturnAll, boolean matchAllNoFiltering) {
        return this.filter(schema, requiredFields, noMatchReturnAll, matchAllNoFiltering, false);
    }

    @Override
    public S filter(S schema, WildcardList requiredFields) {
        return this.filter(schema, requiredFields, false);
    }

    @Override
    public S filter(S schema, WildcardList requiredFields, boolean ignoreRepeatableFieldsSuffix) {
        return this.filter(schema, requiredFields, false, true, ignoreRepeatableFieldsSuffix);
    }

    @Override
    public List<F> filter(String prefix, S schema, WildcardList requiredFields, boolean ignoreRepeatableFieldSuffix) {
        ArrayList result = new ArrayList();
        List<F> fields = this.getFields(schema);
        for (int i = 0; i < fields.size(); ++i) {
            boolean leaf;
            F field = fields.get(i);
            String candidate = this.getMatchingCandidate(prefix, field, ignoreRepeatableFieldSuffix);
            if (gLogger.isDebugEnabled()) {
                gLogger.debug((Object)String.format("Candidate=[%s], current_field=[%s], parent_field=[%s]", candidate, field, schema));
            }
            if (leaf = this.isLeaf(field)) {
                this.processLeafField(result, field, i, candidate, requiredFields);
                continue;
            }
            this.processNonLeafField(result, field, i, candidate, requiredFields);
        }
        return result;
    }

    @Override
    public List<F> filter(String prefix, S schema, WildcardList requiredFields) {
        return this.filter(prefix, schema, requiredFields, false);
    }

    @Override
    public void processLeafField(List<F> result, F field, int fieldIndex, String candidate, WildcardList requiredFields) {
        if (requiredFields.matches(candidate)) {
            result.add(field);
        }
    }

    @Override
    public void processNonLeafField(List<F> result, F field, int fieldIndex, String candidate, WildcardList requiredFields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeaf(F field) {
        return true;
    }

    @Override
    public boolean isRepeatable(F field) {
        throw new UnsupportedOperationException();
    }

    protected List<F> getFields(S schema) {
        throw new UnsupportedOperationException();
    }

    protected String getMatchingCandidate(String prefix, F field, boolean ignoreRepeatableFieldSuffix) {
        prefix = prefix == null ? "" : prefix + this.fieldDelimiter;
        prefix = prefix + this.getFieldName(field);
        if (!ignoreRepeatableFieldSuffix && this.isRepeatable(field)) {
            prefix = prefix + this.repeatableFieldNameSuffix;
        }
        return prefix;
    }

    protected String getMatchingCandidate(String prefix, F field) {
        return this.getMatchingCandidate(prefix, field, false);
    }

    protected String getFieldName(F field) {
        throw new UnsupportedOperationException();
    }

    protected void processMatchNothing(S schema) {
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public String getRepeatableFieldNameSuffix() {
        return this.repeatableFieldNameSuffix;
    }

    public void setRepeatableFieldNameSuffix(String repeatableFieldNameSuffix) {
        this.repeatableFieldNameSuffix = repeatableFieldNameSuffix;
    }
}

