/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.workspaces.AmazonWorkspaces;
import com.amazonaws.services.workspaces.model.CreateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.CreateWorkspacesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceBundlesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspaceDirectoriesResult;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesRequest;
import com.amazonaws.services.workspaces.model.DescribeWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebootWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebootWorkspacesResult;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesRequest;
import com.amazonaws.services.workspaces.model.RebuildWorkspacesResult;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesRequest;
import com.amazonaws.services.workspaces.model.TerminateWorkspacesResult;
import com.amazonaws.services.workspaces.model.transform.CreateWorkspacesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.CreateWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceBundlesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceBundlesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspaceDirectoriesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.DescribeWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.InvalidParameterValuesExceptionUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.RebootWorkspacesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.RebootWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.RebuildWorkspacesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.RebuildWorkspacesResultJsonUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.ResourceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.ResourceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.workspaces.model.transform.TerminateWorkspacesRequestMarshaller;
import com.amazonaws.services.workspaces.model.transform.TerminateWorkspacesResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonWorkspacesClient
extends AmazonWebServiceClient
implements AmazonWorkspaces {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonWorkspaces.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonWorkspacesClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonWorkspacesClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonWorkspacesClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonWorkspacesClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonWorkspacesClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonWorkspacesClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonWorkspacesClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new ResourceLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceUnavailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidParameterValuesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("workspaces.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/workspaces/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/workspaces/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkspacesResult createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateWorkspacesRequestMarshaller().marshall(super.beforeMarshalling(createWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateWorkspacesResultJsonUnmarshaller unmarshaller = new CreateWorkspacesResultJsonUnmarshaller();
            JsonResponseHandler<CreateWorkspacesResult> responseHandler = new JsonResponseHandler<CreateWorkspacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreateWorkspacesResult createWorkspacesResult = (CreateWorkspacesResult)response.getAwsResponse();
            return createWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles(DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspaceBundlesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspaceBundlesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspaceBundlesRequestMarshaller().marshall(super.beforeMarshalling(describeWorkspaceBundlesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeWorkspaceBundlesResultJsonUnmarshaller unmarshaller = new DescribeWorkspaceBundlesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeWorkspaceBundlesResult> responseHandler = new JsonResponseHandler<DescribeWorkspaceBundlesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspaceBundlesResult describeWorkspaceBundlesResult = (DescribeWorkspaceBundlesResult)response.getAwsResponse();
            return describeWorkspaceBundlesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootWorkspacesResult rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebootWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RebootWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RebootWorkspacesRequestMarshaller().marshall(super.beforeMarshalling(rebootWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RebootWorkspacesResultJsonUnmarshaller unmarshaller = new RebootWorkspacesResultJsonUnmarshaller();
            JsonResponseHandler<RebootWorkspacesResult> responseHandler = new JsonResponseHandler<RebootWorkspacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RebootWorkspacesResult rebootWorkspacesResult = (RebootWorkspacesResult)response.getAwsResponse();
            return rebootWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspacesResult describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspacesRequestMarshaller().marshall(super.beforeMarshalling(describeWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeWorkspacesResultJsonUnmarshaller unmarshaller = new DescribeWorkspacesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeWorkspacesResult> responseHandler = new JsonResponseHandler<DescribeWorkspacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspacesResult describeWorkspacesResult = (DescribeWorkspacesResult)response.getAwsResponse();
            return describeWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories(DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeWorkspaceDirectoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeWorkspaceDirectoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeWorkspaceDirectoriesRequestMarshaller().marshall(super.beforeMarshalling(describeWorkspaceDirectoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeWorkspaceDirectoriesResultJsonUnmarshaller unmarshaller = new DescribeWorkspaceDirectoriesResultJsonUnmarshaller();
            JsonResponseHandler<DescribeWorkspaceDirectoriesResult> responseHandler = new JsonResponseHandler<DescribeWorkspaceDirectoriesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeWorkspaceDirectoriesResult describeWorkspaceDirectoriesResult = (DescribeWorkspaceDirectoriesResult)response.getAwsResponse();
            return describeWorkspaceDirectoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebuildWorkspacesResult rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebuildWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RebuildWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RebuildWorkspacesRequestMarshaller().marshall(super.beforeMarshalling(rebuildWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RebuildWorkspacesResultJsonUnmarshaller unmarshaller = new RebuildWorkspacesResultJsonUnmarshaller();
            JsonResponseHandler<RebuildWorkspacesResult> responseHandler = new JsonResponseHandler<RebuildWorkspacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            RebuildWorkspacesResult rebuildWorkspacesResult = (RebuildWorkspacesResult)response.getAwsResponse();
            return rebuildWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateWorkspacesResult terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateWorkspacesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TerminateWorkspacesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TerminateWorkspacesRequestMarshaller().marshall(super.beforeMarshalling(terminateWorkspacesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            TerminateWorkspacesResultJsonUnmarshaller unmarshaller = new TerminateWorkspacesResultJsonUnmarshaller();
            JsonResponseHandler<TerminateWorkspacesResult> responseHandler = new JsonResponseHandler<TerminateWorkspacesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            TerminateWorkspacesResult terminateWorkspacesResult = (TerminateWorkspacesResult)response.getAwsResponse();
            return terminateWorkspacesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public DescribeWorkspaceBundlesResult describeWorkspaceBundles() throws AmazonServiceException, AmazonClientException {
        return this.describeWorkspaceBundles(new DescribeWorkspaceBundlesRequest());
    }

    @Override
    public DescribeWorkspacesResult describeWorkspaces() throws AmazonServiceException, AmazonClientException {
        return this.describeWorkspaces(new DescribeWorkspacesRequest());
    }

    @Override
    public DescribeWorkspaceDirectoriesResult describeWorkspaceDirectories() throws AmazonServiceException, AmazonClientException {
        return this.describeWorkspaceDirectories(new DescribeWorkspaceDirectoriesRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        return result;
    }
}

