/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.search;

import com.splunk.search.ParseNode;
import com.splunk.search.ParseNodeLeaf;
import com.splunk.search.SearchContext;
import java.util.Map;
import java.util.regex.Pattern;

public class ParseNodeCmp
extends ParseNodeLeaf {
    Operator _op = null;
    String _lhs = null;
    String _rhs = null;
    boolean _is_numeric = false;
    boolean _is_literal_term = false;
    boolean _is_case_sensitive = false;
    boolean _is_cidr_match = false;
    double _nrhs = Double.NaN;
    boolean _orLT = false;
    boolean _orGT = false;
    boolean _orEQ = false;
    Pattern _regex;

    public ParseNodeCmp() {
    }

    public ParseNodeCmp(Operator op, String lhs, String rhs) {
        this._op = op;
        this._lhs = lhs;
        this._rhs = rhs;
    }

    public ParseNodeCmp(Operator op, String lhs, Double rhs) {
        this(op, lhs, rhs.toString());
        this._is_numeric = true;
    }

    public ParseNodeCmp(Operator op, String lhs, Long rhs) {
        this(op, lhs, rhs.toString());
        this._is_numeric = true;
    }

    public String getLeftHandSide() {
        return this._lhs;
    }

    public String getRightHandSide() {
        return this._rhs;
    }

    public boolean isNegated() {
        return this._is_negated;
    }

    public boolean isCaseSensitive() {
        return this._is_case_sensitive;
    }

    public boolean isNumeric() {
        return this._is_numeric;
    }

    public boolean hasRegex() {
        return this._regex != null;
    }

    @Override
    public boolean matches(SearchContext sc, boolean defaultLeafResult) {
        String val = sc.getFieldValue(this._lhs);
        if (val == null) {
            return defaultLeafResult;
        }
        if (this._is_cidr_match) {
            return defaultLeafResult;
        }
        boolean cmpResult = false;
        boolean done = false;
        if (this._is_numeric) {
            try {
                double nval = Double.parseDouble(val);
                cmpResult = this._orLT && nval < this._nrhs || this._orGT && nval > this._nrhs || this._orEQ && nval == this._nrhs;
                done = true;
            }
            catch (NumberFormatException nval) {
                // empty catch block
            }
        }
        if (!done) {
            if (!this._is_case_sensitive) {
                val = val.toLowerCase();
            }
            if (this._orLT == this._orGT && defaultLeafResult && val.endsWith("/") && "source".equals(this._lhs)) {
                int starIdx = this._rhs.indexOf(42);
                String rhsPrefix = starIdx < 0 ? this._rhs : this._rhs.substring(0, starIdx);
                cmpResult = val.startsWith(rhsPrefix) || this._rhs.startsWith(val);
                cmpResult = cmpResult == this._orEQ;
                done = true;
            }
            if (!done) {
                if (this._regex != null) {
                    cmpResult = this._regex.matcher(val).matches() == this._orEQ;
                } else {
                    int rv = val.compareTo(this._rhs);
                    cmpResult = this._orLT && rv < 0 || this._orGT && rv > 0 || this._orEQ && rv == 0;
                }
            }
        }
        return cmpResult != this._is_negated;
    }

    @Override
    public void initFrom(Map<String, Object> data) {
        ParseNodeCmp.checkNodeType(data, ParseNode.Type.cmp);
        super.initFrom(data);
        this._op = Operator.toOperator(String.valueOf(data.get("op")));
        this._lhs = String.valueOf(data.get("lhs"));
        this._rhs = String.valueOf(data.get("rhs"));
        this._is_numeric = Boolean.valueOf(String.valueOf(data.get("is_numeric")));
        this._is_literal_term = Boolean.valueOf(String.valueOf(data.get("is_literal_term")));
        this._is_case_sensitive = Boolean.valueOf(String.valueOf(data.get("is_case_sensitive")));
        this._is_cidr_match = Boolean.valueOf(String.valueOf(data.get("is_cidr_match")));
        if (this._op == Operator.NOT_EQUALS) {
            this._orGT = true;
            this._orLT = true;
            this._orEQ = false;
        } else {
            this._orLT = this._op == Operator.LESS_THAN || this._op == Operator.LESS_THAN_EQUALS;
            this._orGT = this._op == Operator.GREATER_THAN || this._op == Operator.GREATER_THAN_EQUALS;
            boolean bl = this._orEQ = this._op == Operator.EQUALS || this._op == Operator.DOUBLE_COLONS || this._op == Operator.LESS_THAN_EQUALS || this._op == Operator.GREATER_THAN_EQUALS;
        }
        if (!this._is_case_sensitive) {
            this._rhs = this._rhs.toLowerCase();
        }
        if (this._is_numeric) {
            this._nrhs = Double.parseDouble(this._rhs);
        } else if (this._orGT == this._orLT && this._rhs.contains("*")) {
            StringBuilder sb = new StringBuilder(this._rhs.length());
            for (int i = 0; i < this._rhs.length(); ++i) {
                char c = this._rhs.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    sb.append(c);
                    continue;
                }
                if (c == '*') {
                    sb.append(".*?");
                    continue;
                }
                sb.append("\\").append(c);
            }
            this._regex = Pattern.compile(sb.toString());
        }
    }

    @Override
    public ParseNode.Type getType() {
        return ParseNode.Type.cmp;
    }

    public Operator getOperator() {
        return this._op;
    }

    public static enum Operator {
        LESS_THAN_EQUALS("<="),
        LESS_THAN("<"),
        EQUALS("="),
        DOUBLE_COLONS("::"),
        GREATER_THAN(">"),
        GREATER_THAN_EQUALS(">="),
        NOT_EQUALS("!=");

        String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Operator toOperator(String value) {
            for (Operator op : Operator.values()) {
                if (!op.value.equals(value)) continue;
                return op;
            }
            throw new IllegalArgumentException("Invalid operator:" + value);
        }
    }
}

